/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.FallenWalnutsBlock;
import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingWalnutsBlock
extends FallingBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public HangingWalnutsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0).move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!HangingWalnutsBlock.isFullyGrown(state) && (double)random.nextFloat() < 0.2) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public void onBrokenAfterFall(Level world, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        if (world.getBlockState(pos).isAir() || world.getBlockState(pos).is(BlockTags.REPLACEABLE)) {
            if (world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP)) {
                world.setBlock(pos, BFBlocks.FALLEN_WALNUTS.defaultBlockState(), 2);
            }
        } else {
            if (world.getBlockState(pos).isFaceSturdy((BlockGetter)world, pos, Direction.UP)) {
                world.setBlock(pos.above(), BFBlocks.FALLEN_WALNUTS.defaultBlockState(), 2);
            }
            if (world.getBlockState(pos).is(BFBlocks.FALLEN_WALNUTS) && (Integer)world.getBlockState(pos).getValue((Property)FallenWalnutsBlock.COUNT) != 3) {
                world.setBlock(pos, (BlockState)BFBlocks.FALLEN_WALNUTS.defaultBlockState().setValue((Property)FallenWalnutsBlock.COUNT, (Comparable)Integer.valueOf((Integer)world.getBlockState(pos).getValue((Property)FallenWalnutsBlock.COUNT) + 1)), 2);
            } else if (world.getBlockState(pos).is(Blocks.FARMLAND) || world.getBlockState(pos).is(Blocks.DIRT_PATH)) {
                if (world.getBlockState(pos.above()).is(BFBlocks.FALLEN_WALNUTS) && (Integer)world.getBlockState(pos.above()).getValue((Property)FallenWalnutsBlock.COUNT) != 3) {
                    world.setBlock(pos.above(), (BlockState)BFBlocks.FALLEN_WALNUTS.defaultBlockState().setValue((Property)FallenWalnutsBlock.COUNT, (Comparable)Integer.valueOf((Integer)world.getBlockState(pos.above()).getValue((Property)FallenWalnutsBlock.COUNT) + 1)), 2);
                } else {
                    world.setBlock(pos.above(), BFBlocks.FALLEN_WALNUTS.defaultBlockState(), 2);
                }
            }
        }
        super.onBrokenAfterFall(world, pos, fallingBlockEntity);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN) && !world.isWaterAt(pos) || world.getBlockState(pos.above()).is(BFBlocks.WALNUT_LEAVES) && !world.isWaterAt(pos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (HangingWalnutsBlock.canFallThrough(state) && pos.getY() >= world.getMinBuildHeight()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            this.falling(fallingBlockEntity);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        }
    }

    public static boolean canFallThrough(BlockState walnutState) {
        return HangingWalnutsBlock.isFullyGrown(walnutState);
    }

    protected int getDelayAfterPlace() {
        return 30;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !HangingWalnutsBlock.isFullyGrown(state);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!HangingWalnutsBlock.isFullyGrown(state)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return !HangingWalnutsBlock.isFullyGrown(state);
    }

    private static boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 3;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, world, pos, type);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return BFItems.WALNUT.getDefaultInstance();
    }
}

