/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.OldTrellisBlock;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.DecorativeVine;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DecorativeTrellisBlock
extends OldTrellisBlock
implements BonemealableBlock {
    private final boolean canDuplicate;
    public TrellisVariant variant;
    public DecorativeVine vine;

    public DecorativeTrellisBlock(boolean canDuplicate, Item item, TrellisVariant variant, DecorativeVine vine, BlockBehaviour.Properties settings) {
        super(settings);
        this.canDuplicate = canDuplicate;
        BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.put(item, this);
        BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.put(this, item);
        this.variant = variant;
        this.vine = vine;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (player.getItemInHand(hand).is(Items.SHEARS)) {
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            world.setBlock(pos, (BlockState)TrellisUtil.getTrellisFromVariant(this.variant).defaultBlockState().setValue((Property)FACING, (Comparable)facing), 2);
            DecorativeTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.get((Object)this)));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.isCreative()) {
            DecorativeTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.vine.getPlantItem()));
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)TrellisUtil.getTrellisFromVariant(this.variant));
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.canDuplicate;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return this.canDuplicate;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.canDuplicate) {
            DecorativeTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.get((Object)this)));
        }
    }

    public static BlockState getDecorativeTrellisFromPlant(Item item) {
        if (item != null && BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.containsKey(item)) {
            return BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.get(item).defaultBlockState();
        }
        return BFTrellises.TRELLISES.get("trellis").defaultBlockState();
    }
}

