/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.hecco.bountifulfares.block.interfaces.DyeableCeramicBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.item.custom.DyeableCeramicBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CeramicDoorBlock
extends DoorBlock
implements DyeableCeramicBlockInterface {
    private final BlockSetType blockSetType;

    public CeramicDoorBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings, blockSetType);
        this.blockSetType = blockSetType;
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        if (DyeableCeramicBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.getCloneItemStack(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)this);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(BFItems.ARTISAN_BRUSH) && !player.isShiftKeyDown() && itemStack.getTagElement("display") != null) {
            DyeableCeramicBlockEntity dyeableCeramicBlockEntity;
            BlockEntity blockEntity;
            int brushColor = itemStack.getTagElement("display").getInt("color");
            if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && world.getBlockState(pos.above()).is((Block)this)) {
                world.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)OPEN, (Comparable)((Boolean)state.getValue((Property)OPEN)))).setValue((Property)HINGE, (Comparable)((DoorHingeSide)state.getValue((Property)HINGE))), 0);
                blockEntity = world.getBlockEntity(pos.above());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
            }
            if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && world.getBlockState(pos.below()).is((Block)this)) {
                world.setBlock(pos.below(), (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)OPEN, (Comparable)((Boolean)state.getValue((Property)OPEN)))).setValue((Property)HINGE, (Comparable)((DoorHingeSide)state.getValue((Property)HINGE))), 0);
                blockEntity = world.getBlockEntity(pos.below());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
            }
            world.removeBlock(pos, false);
            world.setBlock(pos, this.withPropertiesOf(state), 0);
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
            blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                if (dyeableCeramicBlockEntity.color != brushColor) {
                    dyeableCeramicBlockEntity.color = brushColor;
                    dyeableCeramicBlockEntity.setChanged();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!this.blockSetType.canOpenByHand()) {
                return InteractionResult.PASS;
            }
            state = (BlockState)state.cycle((Property)OPEN);
            world.setBlock(pos, state, 10);
            this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.getValue((Property)OPEN));
            world.gameEvent((Entity)player, this.isOpen(state) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, pos);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue((Property)HALF);
        DyeableCeramicBlockEntity entity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos);
        DyeableCeramicBlockEntity topentity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.above());
        DyeableCeramicBlockEntity bottomentity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.below());
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && world.getBlockState(pos.above()).is((Block)this) && entity.color == topentity.color) {
            if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
                return neighborState.is((Block)this) && neighborState.getValue((Property)HALF) != doubleBlockHalf ? (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)neighborState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN)))).setValue((Property)HINGE, (Comparable)((DoorHingeSide)neighborState.getValue((Property)HINGE)))).setValue((Property)POWERED, (Comparable)((Boolean)neighborState.getValue((Property)POWERED))) : Blocks.AIR.defaultBlockState();
            }
            if (direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos)) {
                world.scheduleTick(pos.above(), (Block)this, 1);
                return Blocks.AIR.defaultBlockState();
            }
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && world.getBlockState(pos.below()).is((Block)this) && entity.color == bottomentity.color) {
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl;
        boolean bl2 = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.relative(state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (bl = false);
        if (!this.defaultBlockState().is(sourceBlock) && bl != (Boolean)state.getValue((Property)POWERED) && bl != (Boolean)state.getValue((Property)POWERED)) {
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.cycle((Property)OPEN);
                this.playOpenCloseSound(null, world, pos, bl);
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.playSound(entity, pos, open ? this.blockSetType.doorOpen() : this.blockSetType.doorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        world.setBlock(pos.above(), (BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        BlockEntity blockEntity = world.getBlockEntity(pos.above());
        if (blockEntity instanceof DyeableCeramicBlockEntity) {
            DyeableCeramicBlockEntity entity = (DyeableCeramicBlockEntity)blockEntity;
            DyeableCeramicBlockItem thisEntity = (DyeableCeramicBlockItem)itemStack.getItem();
            entity.color = thisEntity.getColor(itemStack);
            entity.setChanged();
        }
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && world.getBlockState(pos.above()).is((Block)this)) {
            world.scheduleTick(pos.above(), (Block)this, 1);
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && world.getBlockState(pos.below()).is((Block)this)) {
            world.scheduleTick(pos.below(), (Block)this, 1);
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.destroyBlock(pos, true);
        super.tick(state, world, pos, random);
    }
}

