/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.CeramicDishBlockEntity;
import net.hecco.bountifulfares.block.interfaces.CeramicDishBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.item.custom.AirTimeIncreasingItem;
import net.hecco.bountifulfares.util.BFItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CeramicDishBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock,
CeramicDishBlockInterface {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CeramicDishBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        if (CeramicDishBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.getCloneItemStack(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)BFBlocks.CERAMIC_DISH);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.getItemInHand(hand);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CeramicDishBlockEntity) {
            CeramicDishBlockEntity blockEntity2 = (CeramicDishBlockEntity)blockEntity;
            ItemStack itemStack = player.getItemInHand(hand);
            ItemStack stack = blockEntity2.getItem(0);
            if (itemStack.is(BFItems.ARTISAN_BRUSH) && itemStack.getTagElement("display") != null) {
                int brushColor = itemStack.getTagElement("display").getInt("color");
                world.removeBlock(pos, false);
                world.setBlockAndUpdate(pos, this.withPropertiesOf(state));
                blockEntity2.insertItem(stack);
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
                BlockEntity blockEntity3 = world.getBlockEntity(pos);
                if (blockEntity3 instanceof CeramicDishBlockEntity) {
                    CeramicDishBlockEntity ceramicDishBlockEntity = (CeramicDishBlockEntity)blockEntity3;
                    if (ceramicDishBlockEntity.color != brushColor) {
                        ceramicDishBlockEntity.color = brushColor;
                        ceramicDishBlockEntity.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                if (!item.isEmpty() && blockEntity2.canInsertItem()) {
                    blockEntity2.insertItem(item);
                    if (!player.isCreative()) {
                        item.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!stack.isEmpty()) {
                    boolean shouldIgnore;
                    if (player.isShiftKeyDown() && item.isEmpty()) {
                        player.setItemInHand(hand, stack);
                        blockEntity2.removeItem();
                        blockEntity2.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                    if (stack.is(BFItemTags.EATABLE_ON_DISH) && stack.isEdible() && player.canEat(shouldIgnore = stack.getItem().getFoodProperties().canAlwaysEat())) {
                        int i;
                        int hunger = Objects.requireNonNull(stack.getItem().getFoodProperties()).getNutrition();
                        float sat = stack.getItem().getFoodProperties().getSaturationModifier();
                        List effects = stack.getItem().getFoodProperties().getEffects();
                        player.getFoodData().eat(hunger, sat);
                        world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 0.5f, 0.8f + world.random.nextFloat());
                        world.playSound(null, pos, SoundEvents.PLAYER_BURP, SoundSource.BLOCKS, 0.3f, 1.0f);
                        if (stack.getItem() instanceof AirTimeIncreasingItem) {
                            int maxAir;
                            int air = player.getAirSupply();
                            if (air < (maxAir = player.getMaxAirSupply()) - AirTimeIncreasingItem.airTickIncrease) {
                                player.setAirSupply(air + AirTimeIncreasingItem.airTickIncrease);
                            } else {
                                player.setAirSupply(maxAir);
                            }
                        }
                        if (stack.is(Items.CHORUS_FRUIT)) {
                            this.chorusTeleport(world, (LivingEntity)player);
                        }
                        for (i = 0; i < effects.size(); ++i) {
                            MobEffectInstance effect = (MobEffectInstance)((Pair)effects.get(i)).getFirst();
                            int length = effect.getDuration();
                            int amplifier = effect.getAmplifier();
                            MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), length, amplifier);
                            player.addEffect(newEffect);
                        }
                        for (i = 0; i < 4 + world.random.nextIntBetweenInclusive(0, 4); ++i) {
                            world.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)pos.getX() + world.random.nextGaussian() / 12.0 + 0.5, (double)pos.getY() + 0.2, (double)pos.getZ() + world.random.nextGaussian() / 12.0 + 0.5, ((double)world.random.nextFloat() - 0.5) / 8.0, ((double)world.random.nextFloat() - 0.5) / 8.0, ((double)world.random.nextFloat() - 0.5) / 8.0);
                        }
                        blockEntity2.removeItem();
                        blockEntity2.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CeramicDishBlockEntity) {
                CeramicDishBlockEntity entity = (CeramicDishBlockEntity)blockEntity;
                CeramicDishBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)entity.getItem(0));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        return CeramicDishBlock.canSupportRigidBlock((BlockGetter)world, (BlockPos)blockPos) || CeramicDishBlock.canSupportCenter((LevelReader)world, (BlockPos)blockPos, (Direction)Direction.UP);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CeramicDishBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public void chorusTeleport(Level world, LivingEntity user) {
        if (!world.isClientSide) {
            double d = user.getX();
            double e = user.getY();
            double f = user.getZ();
            for (int i = 0; i < 16; ++i) {
                double g = user.getX() + (user.getRandom().nextDouble() - 0.5) * 16.0;
                double h = Mth.clamp((double)(user.getY() + (double)(user.getRandom().nextInt(16) - 8)), (double)world.getMinBuildHeight(), (double)(world.getMinBuildHeight() + ((ServerLevel)world).getLogicalHeight() - 1));
                double j = user.getZ() + (user.getRandom().nextDouble() - 0.5) * 16.0;
                if (user.isPassenger()) {
                    user.stopRiding();
                }
                Vec3 vec3d = user.position();
                if (!user.randomTeleport(g, h, j, true)) continue;
                world.gameEvent(GameEvent.TELEPORT, vec3d, GameEvent.Context.of((Entity)user));
                SoundEvent soundEvent = user instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                world.playSound((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                user.playSound(soundEvent, 1.0f, 1.0f);
                break;
            }
        }
    }
}

