/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BrownJackOStrawBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final VoxelShape NORTH_SOUTH_UPPER = Shapes.join((VoxelShape)Block.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)21.0, (double)13.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape NORTH_SOUTH_LOWER = Shapes.join((VoxelShape)Block.box((double)7.0, (double)-1.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), (VoxelShape)Block.box((double)4.0, (double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape EAST_WEST_UPPER = Shapes.join((VoxelShape)Block.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)21.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape EAST_WEST_LOWER = Shapes.join((VoxelShape)Block.box((double)7.0, (double)-1.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), (VoxelShape)Block.box((double)6.0, (double)12.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.OR);

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                return NORTH_SOUTH_UPPER;
            }
            return NORTH_SOUTH_LOWER;
        }
        if (state.getValue((Property)FACING) == Direction.EAST || state.getValue((Property)FACING) == Direction.WEST) {
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                return EAST_WEST_UPPER;
            }
            return EAST_WEST_LOWER;
        }
        return NORTH_SOUTH_UPPER;
    }

    public BrownJackOStrawBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return (blockState.isFaceSturdy((BlockGetter)world, blockPos, Direction.UP) || world.getBlockState(pos.below()).is(Blocks.FARMLAND)) && world.getBlockState(pos.above()).is(Blocks.AIR) || world.getBlockState(pos.above()).is(Blocks.WATER);
        }
        return blockState.is((Block)this);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.getBlockState(pos.above(1)).is(Blocks.AIR) && state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            world.setBlock(pos.above(1), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        if (world.getBlockState(pos.above(1)).is(Blocks.WATER) && state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            world.setBlock(pos.above(1), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    private static void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState = world.getBlockState(blockPos = pos.below())).is(state.getBlock()) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState2 = blockState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(blockPos, blockState2, 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (!(direction.getAxis() != Direction.Axis.Y || doubleBlockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || neighborState.is((Block)this) && neighborState.getValue(HALF) != doubleBlockHalf)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!(direction.getAxis() != Direction.Axis.Y || doubleBlockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || neighborState.is((Block)this) && neighborState.getValue(HALF) != doubleBlockHalf)) {
            return (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            BrownJackOStrawBlock.onBreakInCreative(world, pos, state, player);
        } else if (world.getBlockState(pos.above()).is((Block)this) && state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            world.destroyBlock(pos, true);
            world.destroyBlock(pos.above(), false);
        } else if (world.getBlockState(pos.below()).is((Block)this) && state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            world.destroyBlock(pos, true);
            world.destroyBlock(pos.below(), false);
        }
    }

    public SoundType getSoundType(BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return BFSounds.JACK_O_STRAW;
        }
        return BFSounds.SILENT;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }
}

