/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.kaleidoscopecookery.cookery;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.kaleidoscopecookery.cookery.PotBe;
import com.github.wallev.maidsoulkitchen.util.BubbleUtil;
import com.github.wallev.maidsoulkitchen.util.InvUtil;
import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.PotRecipe;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@TaskClassAnalyzer(value=TaskInfo.KC_POT)
public class PotCookRule
extends TickCookRule<PotBlockEntity, PotRecipe> {
    public static final Item CONTAINER = Items.f_42399_;
    public static final Item FLINT = Items.f_42409_;
    private static final PotCookRule INSTANCE = new PotCookRule();
    private ItemStack bowl = ItemStack.f_41583_;
    private boolean needBowl = false;
    private int stirFrySpace = 0;
    private int stirFryMinCount = 0;
    private int time = 0;

    public PotCookRule() {
        super((Item)ModItems.KITCHEN_SHOVEL.get());
    }

    public static PotCookRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<PotBlockEntity> cookBeBase, MaidCookManager<PotRecipe> cm) {
        PotBe potBe = (PotBe)cookBeBase;
        PotBlockEntity potBlockEntity = (PotBlockEntity)potBe.getBe();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        if (potBlockEntity.getStatus() == 2 && hasOutputAvailableSlot) {
            if (potBlockEntity.isNeedBowl()) {
                return cm.hasItem(CONTAINER);
            }
            IItemHandlerModifiable inputInv = cm.getInputInv();
            ItemStack shovel = InvUtil.getStack((IItemHandler)inputInv, (Item)ModItems.KITCHEN_SHOVEL.get());
            return !shovel.m_41619_();
        }
        boolean hasMaidRecs = cm.hasMaidRecs(cookBeBase);
        if (hasMaidRecs) {
            boolean stateMatch = cookBeBase.cookStateMatch();
            if (stateMatch) {
                return true;
            }
            if (potBe.canFlitByItem()) {
                return cm.hasItem(FLINT);
            }
        }
        return false;
    }

    @Override
    public void cookMake(CookBeBase<PotBlockEntity> cookBeBase, MaidCookManager<PotRecipe> cm) {
        boolean hasMaidRecs;
        this.init(cookBeBase, cm);
        IItemHandlerModifiable inputInv = cm.getInputInv();
        PotBe potBe = (PotBe)cookBeBase;
        PotBlockEntity potBlockEntity = (PotBlockEntity)potBe.getBe();
        if (potBlockEntity.getStatus() == 2 && !potBlockEntity.isNeedBowl()) {
            ItemStack shovel = InvUtil.getStack((IItemHandler)inputInv, this.kitchenTool);
            if (shovel.m_41619_()) {
                this.stop();
                return;
            }
            this.swapItem(InteractionHand.MAIN_HAND, shovel, this.maid, (IItemHandler)inputInv);
            cookBeBase.useItemWithSneak(shovel, inputInv);
        }
        if (hasMaidRecs = cm.hasMaidRecs(cookBeBase)) {
            boolean canStart = cookBeBase.cookStateMatch();
            if (canStart || potBe.canFlitByItem()) {
                // empty if block
            }
            if (!canStart) {
                this.stop();
                return;
            }
            EntityMaid maid = cm.getMaid();
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            ItemInventory itemInventory = cm.getItemInventory();
            ItemStack oil = maidRec.oil();
            ItemStack oilItem = this.getItem(oil.m_41720_(), itemInventory);
            if (oilItem.m_41619_()) {
                cm.getItemInventory().markDirty();
                this.stop();
                return;
            }
            potBe.useItem(oilItem, inputInv);
            potBe.insertInputs(maidRec, itemInventory);
            ItemStack toolItemStack = maidRec.tool();
            ItemStack swappedTool = this.swapTool(toolItemStack, itemInventory, maid, InteractionHand.MAIN_HAND, (IItemHandler)inputInv);
            if (swappedTool.m_41619_()) {
                this.stop();
                return;
            }
            this.kitchenToolInHand = swappedTool;
            PotRecipe potRecipe = (PotRecipe)maidRec.recCast();
            if (potRecipe.isNeedBowl()) {
                this.needBowl = true;
                ItemStack container = maidRec.container();
                this.bowl = this.getItem(container.m_41720_(), itemInventory);
            }
            this.stirFryMinCount = potRecipe.getStirFryCount();
            this.time = potRecipe.getTime();
            this.stirFrySpace = (this.time - 20) / this.stirFryMinCount;
            BubbleUtil.makeResultsBubble(maid, maidRec.result(), maidRec.time() + 20);
        } else {
            this.stop();
        }
    }

    @Override
    public void tickCookMake(CookBeBase<PotBlockEntity> cookBeBase, MaidCookManager<PotRecipe> cm) {
        int nextInt;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        ItemInventory itemInventory = cm.getItemInventory();
        if (this.tick++ % this.stirFrySpace == 0) {
            if (this.maid.m_21205_() != this.kitchenToolInHand) {
                ItemStack swappedTool = this.swapTool(this.kitchenToolInHand, itemInventory, this.maid, InteractionHand.MAIN_HAND, (IItemHandler)inputInv);
                if (swappedTool.m_41619_()) {
                    this.stop();
                    return;
                }
                this.kitchenToolInHand = swappedTool;
            }
            cookBeBase.useItem(this.kitchenToolInHand, inputInv);
            return;
        }
        if (((PotBlockEntity)this.be).getStatus() == 2 || this.tick - 30 > this.time) {
            IItemHandlerModifiable outputInv = cm.getOutputInv();
            if (this.needBowl) {
                result = cookBeBase.useItem(this.bowl, outputInv);
                if (!result.m_19077_()) {
                    boolean bl = true;
                }
            } else {
                result = cookBeBase.useItemWithSneak(this.kitchenToolInHand, outputInv);
                if (!result.m_19077_()) {
                    boolean bl = true;
                }
            }
            this.stop();
        }
        if (this.tick % 5 == 0 && this.tick % (nextInt = this.maid.m_217043_().m_216339_(1, 10)) == 0) {
            if (this.maid.m_21205_() != this.kitchenToolInHand) {
                ItemStack swappedTool = this.swapTool(this.kitchenToolInHand, itemInventory, this.maid, InteractionHand.MAIN_HAND, (IItemHandler)inputInv);
                if (swappedTool.m_41619_()) {
                    this.stop();
                    return;
                }
                this.kitchenToolInHand = swappedTool;
            }
            cookBeBase.useItem(this.kitchenToolInHand, inputInv);
        }
    }

    @Override
    public boolean tickCan(CookBeBase<PotBlockEntity> cookBeBase, MaidCookManager<PotRecipe> cm) {
        return super.tickCan(cookBeBase, cm);
    }

    @Override
    public void tickStop(CookBeBase<PotBlockEntity> cookBeBase, MaidCookManager<PotRecipe> cm) {
        this.backpackTool(cookBeBase, cm);
        super.tickStop(cookBeBase, cm);
        cm.getItemInventory().markDirty();
        cm.setNextCheckTickCount(0);
        this.kitchenToolInHand = ItemStack.f_41583_;
        this.bowl = ItemStack.f_41583_;
        this.needBowl = false;
        this.stirFrySpace = 0;
        this.stirFryMinCount = 0;
        this.time = 0;
    }

    @Override
    protected TickCookRule<PotBlockEntity, PotRecipe> create() {
        return new PotCookRule();
    }
}

