/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.util;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.util.IEnum;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class EnumCodecUtil {
    public static <E extends Enum<E>> EnumCodec<E> fromEnum(Supplier<E[]> enums) {
        return EnumCodecUtil.fromEnumWithMapping(enums, name -> name);
    }

    static <E extends Enum<E>> EnumCodec<E> fromEnumWithMapping(Supplier<E[]> enums, Function<String, String> keyFun) {
        Enum[] ae = (Enum[])enums.get();
        if (ae.length > 16) {
            Map<String, Enum> map = Arrays.stream(ae).collect(Collectors.toMap(p_274905_ -> (String)keyFun.apply(((IEnum)((Object)p_274905_)).getSerializedName()), p_274903_ -> p_274903_));
            return new EnumCodec(ae, p_216438_ -> p_216438_ == null ? null : (Enum)map.get(p_216438_));
        }
        return new EnumCodec(ae, p_274908_ -> {
            for (Enum e : ae) {
                if (!((String)keyFun.apply(((IEnum)((Object)e)).getSerializedName())).equals(p_274908_)) continue;
                return e;
            }
            return null;
        });
    }

    static Keyable keys(final IEnum[] enums) {
        return new Keyable(){

            public <T> Stream<T> keys(DynamicOps<T> p_184758_) {
                return Arrays.stream(enums).map(IEnum::getSerializedName).map(arg_0 -> p_184758_.createString(arg_0));
            }
        };
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> p_184406_, Function<String, E> p_184407_) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(p_184407_.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + p_184404_)), p_184401_ -> Optional.ofNullable((String)p_184406_.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + String.valueOf(p_184401_))));
    }

    public static <E> Codec<E> orCompressed(final Codec<E> pFirst, final Codec<E> pSecond) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                return p_184484_.compressMaps() ? pSecond.encode(p_184483_, p_184484_, p_184485_) : pFirst.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                return p_184480_.compressMaps() ? pSecond.decode(p_184480_, p_184481_) : pFirst.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return String.valueOf(pFirst) + " orCompressed " + String.valueOf(pSecond);
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> p_184422_, IntFunction<E> p_184423_, int p_184424_) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(p_184423_.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + p_184414_)), p_274850_ -> {
            int i = p_184422_.applyAsInt(p_274850_);
            return i == p_184424_ ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(p_274850_)) : DataResult.success((Object)i);
        });
    }

    public static class EnumCodec<E extends Enum<E>>
    implements Codec<E> {
        private final Codec<E> codec;
        private final Function<String, E> resolver;

        public EnumCodec(E[] enums, Function<String, E> resolver) {
            this.codec = EnumCodecUtil.orCompressed(EnumCodecUtil.stringResolverCodec(e -> ((IEnum)((Object)e)).getSerializedName(), resolver), EnumCodecUtil.idResolverCodec(e -> e.ordinal(), p_216459_ -> p_216459_ >= 0 && p_216459_ < enums.length ? enums[p_216459_] : null, -1));
            this.resolver = resolver;
        }

        public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> pOps, T pInput) {
            return this.codec.decode(pOps, pInput);
        }

        public <T> DataResult<T> encode(E pInput, DynamicOps<T> pOps, T pPrefix) {
            return this.codec.encode(pInput, pOps, pPrefix);
        }

        @Nullable
        public E byName(@Nullable String pName) {
            return (E)((Enum)this.resolver.apply(pName));
        }

        public E byName(@Nullable String pName, E pDefaultValue) {
            return (E)((Enum)Objects.requireNonNullElse(this.byName(pName), pDefaultValue));
        }
    }
}

