/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.datagen.lang;

import com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang.MsmLangUtil;
import com.github.wallev.maidsoulkitchen.init.ModItems;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLanguageProvider
extends LanguageProvider {
    private final Map<String, Pair<LangVal, LangVal>> map = new HashMap<String, Pair<LangVal, LangVal>>();
    private final Local currentLocal;

    public ModLanguageProvider(PackOutput output, String modid, Local locale) {
        super(output, modid, locale.name().toLowerCase(Locale.ENGLISH));
        this.currentLocal = locale;
    }

    protected void addTranslations() {
        this.addLocalLang();
        this.addModCompatLang();
    }

    protected void addModCompatLang() {
        try {
            MsmLangUtil.autonGenModLang(this, this.currentLocal.name().toLowerCase(Locale.ENGLISH));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addLocalLang() {
        this.initLang();
        for (Map.Entry<String, Pair<LangVal, LangVal>> entry : this.map.entrySet()) {
            String key = entry.getKey();
            Pair<LangVal, LangVal> pair = entry.getValue();
            String value = switch (this.currentLocal) {
                case Local.ZH_CN -> ((LangVal)pair.getSecond()).val();
                default -> ((LangVal)pair.getFirst()).val();
            };
            this.add(key, value);
        }
    }

    protected void initLang() {
        this.addItemLang();
        this.addTooltipsLang();
        this.addEffectLang();
        this.addChatBubbleLang();
        this.addConfigLang();
        this.addTaskLang();
        this.addOverlayLang();
        this.addTopLang();
        this.addMessageLang();
        this.addRuleLang();
        this.addGuiLang();
        this.addPatchouliLang();
    }

    protected void addItemLang() {
        this.addItemLang((Item)ModItems.BURN_PROTECT_BAUBLE.get(), "\u00a76Burn Protect Bauble", "\u00a76\u71c3\u7740\u4fdd\u62a4\u9970\u54c1");
        this.addItemLang((Item)ModItems.CULINARY_HUB.get(), "Culinary hub", "\u70f9\u996a\u4e2d\u67a2");
    }

    protected void addTooltipsLang() {
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.usage", "[Usage]", "[\u4f7f\u7528\u65b9\u6cd5]");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.usage.0", "Press and hold [SHIFT] to view details", "\u6309\u4f4f[SHIFT]\u67e5\u770b\u8be6\u60c5");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.usage.1", "- Right-click to open the Gui and select the mode of binding", "- \u53f3\u952e\u6253\u5f00Gui\u9009\u62e9\u7ed1\u5b9a\u7684\u6a21\u5f0f");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.usage.2", "- Shift-right-click the box to bind the box, and Shift again-right-click the box to unbind", "- Shift\u53f3\u51fb\u7bb1\u5b50\u7ed1\u5b9a\u7bb1\u5b50\uff0c\u518d\u6b21Shift\u53f3\u51fb\u7bb1\u5b50\u53d6\u6d88\u7ed1\u5b9a");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.usage.3", "- Place it in the fifth slot of the first column of the maid's backpack to take effect", "- \u653e\u5728\u5973\u4ec6\u80cc\u5305\u7b2c\u4e00\u680f\u7b2c\u4e94\u4e2a\u683c\u5b50\u751f\u6548");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.function", "[Function]", "[\u529f\u80fd]");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.function.1", "Allows maids to interact directly with other chests while cooking", "\u5141\u8bb8\u5973\u4ec6\u5728\u70f9\u996a\u65f6\u76f4\u63a5\u4e0e\u5176\u4ed6\u7bb1\u5b50\u4e92\u52a8");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.function.2", "There are three types of chests that can be bound, with a maximum of 3 of each", "\u53ef\u7ed1\u5b9a\u4e09\u79cd\u7c7b\u578b\u7684\u7bb1\u5b50\uff0c\u6bcf\u79cd\u6700\u591a\u53ef\u7ed1\u5b9a3\u4e2a");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.warn", "[Warning]", "[\u4f7f\u7528\u8b66\u544a]");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.warn.empty", "There are currently no chests bound to it, which will render the [Culinary Hub] useless", "\u5f53\u524d\u8fd8\u672a\u7ed1\u5b9a\u4efb\u4f55\u7bb1\u5b50\uff0c\u8fd9\u5c06\u4f7f[\u70f9\u996a\u4e2d\u67a2]\u53d1\u6325\u4e0d\u4e86\u4f5c\u7528");
        this.addLang("tooltips.maidsoulkitchen.culinary_hub.desc.warn.left", "There are currently %s chests left unbound, please continue to bind them, otherwise [Culinary Hub] will not be fully effective", "\u5f53\u524d\u8fd8\u5269%s\u7c7b\u578b\u7684\u7bb1\u5b50\u672a\u7ed1\u5b9a\uff0c\u8bf7\u7ee7\u7eed\u7ed1\u5b9a\u5b83\u4eec\uff0c\u5426\u5219[\u70f9\u996a\u4e2d\u67a2]\u53d1\u6325\u4e0d\u4e86\u5168\u90e8\u4f5c\u7528");
        this.addLang("tooltips.maidsoulkitchen.burn_protect_bauble.desc.function", "[Function]", "[\u529f\u80fd]");
        this.addLang("tooltips.maidsoulkitchen.burn_protect_bauble.desc.function.1", "Prevents the maid from burning when cooking", "\u9632\u6b62\u5973\u4ec6\u5728\u70f9\u996a\u65f6\u88ab\u70eb\u4f24");
        this.addLang("tooltips.maidsoulkitchen.amount.title", "Craft One Amount Ingredient:", "\u6d89\u53ca\u5230\u7684\u539f\u6750\u6599:");
    }

    protected void addEffectLang() {
        this.addLang("effect.maidsoulkitchen.burn_protect", "Burn Protect", "\u6297\u71c3");
    }

    protected void addChatBubbleLang() {
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.none_food.0", "No food for %s... Can't raise them!", "\u6ca1\u6709%s\u7684\u98df\u7269\u4e86... \u517b\u4e0d\u4e86\u5b83\u4eec\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.none_food.1", "%s, there's no food for you... I have to wrong you, go hungry for a while!", "%s,\u6ca1\u6709\u4f60\u4eec\u98df\u7269\u4e86... \u53ea\u80fd\u59d4\u5c48\u4f60\u4eec,\u5148\u997f\u4e00\u6bb5\u65f6\u95f4\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.none_food.2", "This %s is too picky... I won't raise them anymore, there's no food!", "\u8fd9%s\u4e5f\u592a\u6311\u98df\u4e86... \u4e0d\u517b\u4e86\u4e0d\u517b\u4e86,\u90fd\u6ca1\u6709\u98df\u7269,\u517b\u5565\u554a\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.max_number.0", "There are too many %s... I won't feed them anymore!", "\u8fd9%s\u592a\u591a\u4e86... \u6211\u4e0d\u518d\u5582\u517b\u5b83\u4eec\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.max_number.1", "There are too many %s... Can't feed them anymore!", "\u8fd9%s\u592a\u591a\u4e86\u5427... \u4e0d\u80fd\u518d\u5582\u517b\u5b83\u4eec\u4e86\u5566\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.type.max_number.2", "This %s eats too much... I won't raise them anymore, they eat too much!", "\u8fd9%s\u4e5f\u592a\u80fd\u5403\u4e86\u628a... \u4e0d\u517b\u4e86\u4e0d\u517b\u4e86,\u592a\u80fd\u5403\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.feed_end", "Little %s, grow up quickly~", "\u5c0f%s\u541b\uff0c\u5feb\u5feb\u957f\u5927\u54e6~");
        this.addLang("chat_bubble.maidsoulkitchen.inner.feed_animal.no_animals", "There seem to be no animals that can be raised~", "\u8fd9\u4f3c\u4e4e\u6ca1\u6709\u53ef\u4ee5\u517b\u6b96\u7684\u52a8\u7269\u8bf6~");
        this.addLang("chat_bubble.maidsoulkitchen.cook.collect_ingredients", "Let me see what food can be made~", "\u8ba9\u6211\u6765\u770b\u770b\u90fd\u53ef\u4ee5\u5236\u4f5c\u90a3\u4e9b\u98df\u7269~");
        this.addLang("chat_bubble.maidsoulkitchen.cook.no_ingredient_cook", "\u252d\u252e\ufe4f\u252d\u252e There's no raw material in the warehouse, can't cook!", "\u252d\u252e\ufe4f\u252d\u252e\u4ed3\u5e93\u600e\u4e48\u4ec0\u4e48\u539f\u6750\u6599\u90fd\u6ca1\u6709\u554a\uff0c\u90fd\u4e0d\u80fd\u7092\u83dc\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.cook.can_cook_these_food", "Wow, it can make so much food:", "\u54c7\uff0c\u53ef\u4ee5\u5236\u4f5c\u8fd9\u4e48\u591a\u98df\u7269\u8bf6: ");
        this.addLang("chat_bubble.maidsoulkitchen.cook.food_amount", "portion", "\u4efd");
        this.addLang("chat_bubble.maidsoulkitchen.cook.master", "Master", "\u4e3b\u4eba");
        this.addLang("chat_bubble.maidsoulkitchen.cook.make_food.0", "It's time to fry %d portions of %s love bento for master %s~", "\u662f\u65f6\u5019\u7ed9\u4e3b\u4eba%s\u7092%d\u4efd%s\u7231\u5fc3\u4fbf\u5f53\u4e86~");
        this.addLang("chat_bubble.maidsoulkitchen.cook.make_food.1", "It's time to fry %d portions of %s love bento~", "\u662f\u65f6\u5019\u7ed9\u7092%d\u4efd%s\u7231\u5fc3\u4fbf\u5f53\u4e86~");
        this.addLang("chat_bubble.maidsoulkitchen.cook.make_food.2", "It's time for %d portions of %s!", "\u662f\u65f6\u5019\u6765%d\u4efd%s\u4e86\uff01");
        this.addLang("chat_bubble.maidsoulkitchen.cook.make_food.3", "Is %s delicious? Let's have %d portions~", "%s\u597d\u5403\u4e48\uff0c\u6765%d\u4efd\u770b\u770b~");
        this.addLang("chat_bubble.maidsoulkitchen.cook.make_food.4", "%d portions of %s, let's start!", "%d\u4efd%s\uff0c\u542f\u52a8\uff01");
    }

    protected void addConfigLang() {
        this.addLang("config.maidsoulkitchen.title", "Maid Kitchen: Farm And Cook", "\u5973\u4ec6\u53a8\u623f\uff1a\u519c\u8015\u4e0e\u70f9\u996a");
        this.addLang("config.maidsoulkitchen.title.tip", "[Addon: Farm And Cook]", "[\u62d3\u5c55\uff1a\u519c\u8015\u4e0e\u70f9\u996a]");
        this.addLang("config.maidsoulkitchen.task", "Task", "\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.task.melon_stem_list", "Melon Stem List", "\u74dc\u82d7\u914d\u7f6e");
        this.addLang("config.maidsoulkitchen.task.melon_stem_list.tooltip", "These entries configure the melon stem list\nrule: \u00a7eattached_melon_stem_block_id\nEg: \u00a7eminecraft:attached_pumpkin_stem \u00a7eminecraft:attached_pumpkin_stem ...", "\u8fd9\u4e9b\u6761\u76ee\u914d\u7f6e\u4e86\u8981\u91c7\u96c6\u7684\u74dc\u7684\u74dc\u82d7\n\u89c4\u5219: \u00a7e\u74dc\u82d7\u7684\u65b9\u5757id\n\u4f8b\u5982: \u00a7eminecraft:attached_pumpkin_stem \u00a7eminecraft:attached_pumpkin_stem ...");
        this.addLang("config.maidsoulkitchen.task.melon_and_stem_list", "Melon And Stem List", "\u74dc\u7c7b\u74dc\u82d7\u914d\u7f6e");
        this.addLang("config.maidsoulkitchen.task.melon_and_stem_list.tooltip", "These entries configure the melon stem and melon_block list\nrule: \u00a7emelon_item_id(silk touch)\u00a7c,\u00a7eattached_melon_stem_block_id\nEg: \u00a7eminecraft:melon\u00a7c,\u00a7eminecraft:attached_melon_stem", "\u8fd9\u4e9b\u6761\u76ee\u914d\u7f6e\u4e86\u8981\u91c7\u96c6\u7684\u74dc\n\u89c4\u5219: \u00a7e\u74dc\u7684\u7269\u54c1id(\u7cbe\u51c6\u91c7\u96c6)\u00a7c,\u00a7e\u74dc\u82d7\u7684\u65b9\u5757id\n\u4f8b\u5982: \u00a7eminecraft:melon\u00a7c,\u00a7eminecraft:attached_melon_stem");
        this.addLang("config.maidsoulkitchen.task.cook_selected_recipes", "Cook Selected Recipe Numbs", "\u70f9\u996a\u5b9a\u5411\u914d\u65b9\u6700\u5927\u6570\u91cf\u503c");
        this.addLang("config.maidsoulkitchen.task.cook_selected_recipes.tooltip", "Cook Selected Recipe Numbs", "\u70f9\u996a\u5b9a\u5411\u914d\u65b9\u6700\u5927\u6570\u91cf\u503c");
        this.addLang("config.maidsoulkitchen.task.fruit_search_yoffset", "Fruit Task Search YOffset Numbs", "\u6c34\u679c\u519c\u573a\u68c0\u7d22\u9ad8\u5ea6\u503c");
        this.addLang("config.maidsoulkitchen.task.fruit_search_yoffset.tooltip", "Change the working mode to the retrieval start height value of the maid of the fruit task", "\u6539\u53d8\u5de5\u4f5c\u6a21\u5f0f\u4e3a\u6c34\u679c\u7684\u5973\u4ec6\u7684\u68c0\u7d22\u8d77\u59cb\u9ad8\u5ea6\u503c");
        this.addLang("config.maidsoulkitchen.task.feed_animal_t", "Max Number of the same type Animal", "\u7e41\u6b96\u540c\u79cd\u52a8\u7269\u7684\u6700\u5927\u6570\u91cf");
        this.addLang("config.maidsoulkitchen.task.feed_animal_t.tooltip", "The max number of the same animal around when the maid breeds animals", "\u5973\u4ec6\u5904\u4e8e\u7e41\u6b96\u52a8\u7269\u6a21\u5f0f\u65f6\uff0c\u5468\u56f4\u6700\u5927\u53ef\u4ee5\u7e41\u6b96\u7684\u540c\u79cd\u52a8\u7269\u6570\u91cf");
        this.addLang("config.maidsoulkitchen.render", "Render", "\u6e32\u67d3");
        this.addLang("config.maidsoulkitchen.render.ld_banner_render", "let's do banner", "let's do\u65d7\u5e1c");
        this.addLang("config.maidsoulkitchen.render.ld_banner_render.tooltip", "Maid can render let's do Banner.", "\u5973\u4ec6\u4f1a\u6e32\u67d3Let's do\u7cfb\u5217\u7684\u65d7\u5e1c");
        this.addLang("config.maidsoulkitchen.register", "Register", "\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.restart_warn.tooltip", "\u00a7cWarning\uff1a This requires a reboot for this to take effect", "\u00a7c\u6ce8\u610f\uff1a \u8fd9\u9700\u8981\u91cd\u542f\u624d\u751f\u6548");
        this.addLang("config.maidsoulkitchen.register.berry_farm_task", "Berry Farm Task", "\u6d46\u679c\u519c\u573a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.berry_farm_task.tooltip", "This can make the berry farm task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6d46\u679c\u519c\u573a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.fruit_farm_task", "Fruit Farm Task", "\u6c34\u679c\u519c\u573a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.fruit_farm_task.tooltip", "This can make the fruit farm task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c34\u679c\u519c\u573a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.feed_animal_t", "BreedT Task", "\u7e41\u6b962\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.feed_animal_t.tooltip", "This can make the breed_t task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u7e41\u6b962\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.compat_melon_farm_task", "Compat Melon Farm Task", "\u517c\u5bb9\u74dc\u7c7b\u519c\u573a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.compat_melon_farm_task.tooltip", "This can make the compat melon farm task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u517c\u5bb9\u74dc\u7c7b\u519c\u573a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.serene_seasons_farm_task", "SereneSeasons Farm Task", "\u56db\u5b63\u519c\u573a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.serene_seasons_farm_task.tooltip", "This can make the sereneseasons farm task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u56db\u5b63\u519c\u573a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.eclipticseasons_farm", "Ecliptic Seasons Farm Task", "\u8282\u6c14\u519c\u573a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.eclipticseasons_farm.tooltip", "This can make the ecliptic seasons farm task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u8282\u6c14\u519c\u573a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.feed_and_drink_task", "Feed And Drink Task", "\u5582\u98df\u4e0e\u996e\u6c34\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.feed_and_drink_task.tooltip", "This can make the feed and drink task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u5582\u98df\u4e0e\u996e\u6c34\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.furnace_task", "Furnace Task", "\u7194\u7089\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.furnace_task.tooltip", "This can make the furnace task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u7194\u7089\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.fd_cook_pot", "FD Cook Pot Task", "\u519c\u592b\u4e50\u4e8b\u53a8\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.fd_cook_pot.tooltip", "This can make the fd cook pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u519c\u592b\u4e50\u4e8b\u53a8\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.fd_cutting_board", "FD Cutting Board Task", "\u519c\u592b\u4e50\u4e8b\u7827\u677f\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.fd_cutting_board.tooltip", "This can make the fd cutting board task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u519c\u592b\u4e50\u4e8b\u7827\u677f\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.cd_cuisine_skillet", "Cd Cuisine Skillet Task", "\u6599\u7406\u4e50\u4e8b\u7092\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.cd_cuisine_skillet.tooltip", "This can make the cd cuisine skillet task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6599\u7406\u4e50\u4e8b\u7092\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.bd_grill", "Bd Grill Task", "\u70e7\u70e4\u4e50\u4e8b\u70e7\u70e4\u67b6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.bd_grill.tooltip", "This can make the bd grill skillet task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u70e7\u70e4\u4e50\u4e8b\u70e7\u70e4\u67b6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.bd_basin", "Bd Basin Task", "\u70e7\u70e4\u4e50\u4e8b\u914d\u6599\u76c6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.bd_basin.tooltip", "This can make the bd basin skillet task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u70e7\u70e4\u4e50\u4e8b\u914d\u6599\u76c6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.md_cook_pot", "MD Cook Pot Task", "\u65f7\u5de5\u4e50\u4e8b\u94dc\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.md_cook_pot.tooltip", "This can make the md cook pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u519c\u592b\u65f7\u5de5\u4e50\u4e8b\u94dc\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.fr_kettle", "Fr Kettle", "\u519c\u592b\u6687\u4e8b\u8336\u58f6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.fr_kettle.tooltip", "This can make the fr kettle task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u519c\u592b\u6687\u4e8b\u8336\u58f6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.bnc_key", "Bnc Key", "\u996e\u9152\u4f5c\u4e50\u53d1\u9175\u6876\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.bnc_key.tooltip", "This can make the bnc key task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u996e\u9152\u4f5c\u4e50\u53d1\u9175\u6876\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.yhc_tea_kettle", "Yhc Tea Kettle Task", "\u5996\u602a\u5f52\u5bb6\u8336\u58f6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.yhc_tea_kettle.tooltip", "This can make the yhc tea kettle task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u5996\u602a\u5f52\u5bb6\u8336\u58f6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.yhc_fermentation_tank", "Yhc Fermentation Tank Task", "\u5996\u602a\u5f52\u5bb6\u53d1\u9175\u6876\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.yhc_fermentation_tank.tooltip", "This can make the yhc fermentation tank task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u5996\u602a\u5f52\u5bb6\u53d1\u9175\u6876\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.yhc_drying_rack", "Yhc Drying Rack Task", "\u5996\u602a\u5f52\u5bb6\u6652\u5e72\u67b6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.yhc_drying_rack.tooltip", "This can make the yhc drying rack task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u5996\u602a\u5f52\u5bb6\u6652\u5e72\u67b6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.yhc_moka", "Yhc Moka Task", "\u5996\u602a\u5f52\u5bb6\u6469\u5361\u58f6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.yhc_moka.tooltip", "This can make the yhc moka task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u5996\u602a\u5f52\u5bb6\u6469\u5361\u58f6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.cp_crock_pot", "Cp Crock Pot Task", "\u70f9\u996a\u9505\u70f9\u996a\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.cp_crock_pot.tooltip", "This can make the cp crock pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u70f9\u996a\u9505\u70f9\u996a\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.db_beer", "Db Beer Task", "\u559d\u5564\u9152\u5566\u5564\u9152\u6876\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.db_beer.tooltip", "This can make the db beer task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u559d\u5564\u9152\u5566\u5564\u9152\u6876\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.kk_brew_barrel", "Kk Brew Barrel Task", "\u80e1\u841d\u535c\u53a8\u623f\u917f\u9020\u6876\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.kk_brew_barrel.tooltip", "This can make the kk brew barrel task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u80e1\u841d\u535c\u53a8\u623f\u917f\u9020\u6876\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.kk_air_compressor", "Kk Air Compressor Task", "\u80e1\u841d\u535c\u53a8\u623f\u7a7a\u6c14\u538b\u7f29\u673a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.kk_air_compressor.tooltip", "This can make the kk air compressor task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u80e1\u841d\u535c\u53a8\u623f\u7a7a\u6c14\u538b\u7f29\u673a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dbk_cooking_pot", "Dbk Cooking Pot", "\u99a5\u90c1\u70d8\u7119\u5c0f\u70f9\u996a\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dbk_cooking_pot.tooltip", "This can make the dbk cooking pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u99a5\u90c1\u70d8\u7119\u5c0f\u70f9\u996a\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dbp_mini_fridge", "Dbp Mini Fridge Task", "\u6c99\u6ee9\u6d3e\u5bf9\u5c0f\u51b0\u7bb1\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dbp_mini_fridge.tooltip", "This can make the dbp mini fridge task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c99\u6ee9\u6d3e\u5bf9\u5c0f\u51b0\u7bb1\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dbp_tiki_bar", "Dbp Tiki Bar Task", "\u6c99\u6ee9\u6d3e\u5bf9\u63d0\u57fa\u5427\u53f0\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dbp_tiki_bar.tooltip", "This can make the dbp tiki bar task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c99\u6ee9\u6d3e\u5bf9\u63d0\u57fa\u5427\u53f0\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dcl_cooking_pan", "Dcl Cooking Pan Task", "\u70db\u706b\u665a\u5bb4\u6c64\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dcl_cooking_pan.tooltip", "This can make the dcl cooking pan task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u70db\u706b\u665a\u5bb4\u6c64\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dcl_cooking_pot", "Dcl Cooking Pot Task", "\u70db\u706b\u665a\u5bb4\u5e73\u5e95\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dcl_cooking_pot.tooltip", "This can make the dcl cooking pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u70db\u706b\u665a\u5bb4\u5e73\u5e95\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dcl_stove", "Dcl Stove", "\u70db\u706b\u665a\u5bb4\u70e4\u7089\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dcl_stove.tooltip", "This can make the dcl cooking stove task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u99a5\u90c1\u70d8\u7119\u70e4\u7089\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dfc_roast", "Dfc Roast", "\u6c89\u6d78\u519c\u827a\u70d8\u7119\u673a\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dfc_roast.tooltip", "This can make the dfc roast task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c89\u6d78\u519c\u827a\u70d8\u7119\u673a\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dfc_cooking_pot", "Dfc Cooking Pot Task", "\u6c89\u6d78\u519c\u827a\u70f9\u996a\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dfc_cooking_pot.tooltip", "This can make the dfc cooking pot task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c89\u6d78\u519c\u827a\u70f9\u996a\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dfc_stove", "Dfc Stove", "\u6c89\u6d78\u519c\u827a\u70e4\u7089\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dfc_stove.tooltip", "This can make the dfc stove task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u6c89\u6d78\u519c\u827a\u70e4\u7089\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dhb_cauldron", "Dhb Cauldron Task", "\u7168\u8336\u915d\u9732\u917f\u716e\u9505\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dhb_cauldron.tooltip", "This can make the dhb cauldron task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u7168\u8336\u915d\u9732\u917f\u716e\u9505\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.dhb_tea_kettle", "Dhb Tea Kettle Task", "\u7168\u8336\u915d\u9732\u8336\u58f6\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.dhb_tea_kettle.tooltip", "This can make the dhb tea kettle task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u7168\u8336\u915d\u9732\u8336\u58f6\u4efb\u52a1\u7684\u6ce8\u518c");
        this.addLang("config.maidsoulkitchen.register.fermentation_barrel", "Fermentation Barrel Task", "\u8461\u56ed\u9152\u9999\u9648\u917f\u6876\u4efb\u52a1");
        this.addLang("config.maidsoulkitchen.register.fermentation_barrel.tooltip", "This can make the fermentation barrel task enabled or not.", "\u8fd9\u4f1a\u542f\u7528\u6216\u7981\u7528\u8461\u56ed\u9152\u9999\u9648\u917f\u6876\u4efb\u52a1\u7684\u6ce8\u518c");
    }

    protected void addTaskLang() {
        this.addLang("task.maidsoulkitchen.dkb_cooking_pot", "Cooking Pot", "\u5c0f\u70f9\u996a\u9505");
        this.addLang("task.maidsoulkitchen.dkb_cooking_pot.desc", "Maid can cook food by use the let's do bakery cooking pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u99a5\u90c1\u70d8\u7119\u7684\u5c0f\u70f9\u996a\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.dkb_cooking_pot.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dbp_mini_fridge", "Mini Fridge", "\u5c0f\u51b0\u7bb1");
        this.addLang("task.maidsoulkitchen.dbp_mini_fridge.desc", "Maid can cook food by use the let's do beachparty mini fridge", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6c99\u6ee9\u6d3e\u5bf9\u7684\u5c0f\u51b0\u7bb1\u5236\u4f5c\u51b0\u6dc7\u6dcb\u7b49");
        this.addLang("task.maidsoulkitchen.dbp_mini_fridge.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dbp_tiki_bar", "Tiki Bar", "\u63d0\u57fa\u5427\u53f0");
        this.addLang("task.maidsoulkitchen.dbp_tiki_bar.desc", "Maid can cook food by use the let's do beachparty tiki bar", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6c99\u6ee9\u6d3e\u5bf9\u7684\u63d0\u57fa\u5427\u53f0\u51b2\u5236\u996e\u54c1");
        this.addLang("task.maidsoulkitchen.dbp_tiki_bar.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.bnc_key", "Fermentation Barrel", "\u53d1\u9175\u6876");
        this.addLang("task.maidsoulkitchen.bnc_key.desc", "Maid can brew wine using the Brewin' and Chewin' fermentation barrel", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u996e\u9152\u4f5c\u4e50\u7684\u53d1\u9175\u6876\u917f\u9152");
        this.addLang("task.maidsoulkitchen.bnc_key.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.fr_kettle", "Teapot", "\u8336\u58f6");
        this.addLang("task.maidsoulkitchen.fr_kettle.desc", "Maid can make tea using the Farmer's Respite teapot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u519c\u592b\u6687\u4e8b\u7684\u8336\u58f6\u716e\u8336");
        this.addLang("task.maidsoulkitchen.fr_kettle.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pot", "Stock Pot", "\u6c64\u9505");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pot.desc", "Maid can cook food using the Let's Do Candlelight stock pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70db\u706b\u665a\u5bb4\u7684\u6c64\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pot.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pan", "Frying Pan", "\u5e73\u5e95\u9505");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pan.desc", "Maid can cook food using the Let's Do Candlelight frying pan", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70db\u706b\u665a\u5bb4\u7684\u5e73\u5e95\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.dcl_cooking_pan.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dcl_stove", "Oven", "\u70e4\u7089");
        this.addLang("task.maidsoulkitchen.dcl_stove.desc", "Maid can bake pastries using the Let's Do Candlelight oven", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70db\u706b\u665a\u5bb4\u7684\u70e4\u7089\u70d8\u7119\u7cd5\u70b9");
        this.addLang("task.maidsoulkitchen.dcl_stove.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dfc_cooking_pot", "Stock Pot", "\u6c64\u9505");
        this.addLang("task.maidsoulkitchen.dfc_cooking_pot.desc", "Maid can cook food using the Let's Do Farm and Charm stock pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6c89\u6d78\u519c\u827a\u7684\u6c64\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.dfc_cooking_pot.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dfc_roast", "Roaster", "\u70d8\u7119\u673a");
        this.addLang("task.maidsoulkitchen.dfc_roast.desc", "Maid can cook food using the Let's Do Farm and Charm roaster", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6c89\u6d78\u519c\u827a\u7684\u70d8\u7119\u673a\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.dfc_roast.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.dfc_stove", "Oven", "\u70e4\u7089");
        this.addLang("task.maidsoulkitchen.dfc_stove.desc", "Maid can bake pastries using the Let's Do Farm and Charm oven", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6c89\u6d78\u519c\u827a\u7684\u70e4\u7089\u70d8\u7119\u7cd5\u70b9");
        this.addLang("task.maidsoulkitchen.dfc_stove.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.farmersdelight_cooking_pot_cooking", "Cooking Pot", "\u53a8\u9505");
        this.addLang("task.maidsoulkitchen.farmersdelight_cooking_pot_cooking.desc", "Maid can cook food using the Farmer's Delight cooking pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u519c\u592b\u4e50\u4e8b\u53a8\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.farmersdelight_cooking_pot_cooking.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.farmersdelight_cutting_board_cutting", "Cutting Board", "\u7827\u677f");
        this.addLang("task.maidsoulkitchen.farmersdelight_cutting_board_cutting.desc", "Maid can process ingredients using the Farmer's Delight cutting board", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u519c\u592b\u4e50\u4e8b\u7827\u677f\u5904\u7406\u98df\u6750");
        this.addLang("task.maidsoulkitchen.farmersdelight_cutting_board_cutting.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.cuisinedelight_cuisine_skillet_cuisine", "Wok", "\u7092\u9505");
        this.addLang("task.maidsoulkitchen.cuisinedelight_cuisine_skillet_cuisine.desc", "Maid can stir-fry using the Cuisine Delight wok", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6599\u7406\u4e50\u4e8b\u7092\u9505\u7092\u83dc");
        this.addLang("task.maidsoulkitchen.cuisinedelight_cuisine_skillet_cuisine.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.barbequesdelight_grill_grilling", "Grill", "\u70e7\u70e4\u67b6");
        this.addLang("task.maidsoulkitchen.barbequesdelight_grill_grilling.desc", "Maid can grill using the Barbeque Delight grill", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70e7\u70e4\u4e50\u4e8b\u70e7\u70e4\u67b6\u70e7\u70e4");
        this.addLang("task.maidsoulkitchen.barbequesdelight_grill_grilling.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.barbequesdelight_basin_skewering", "Ingredient Basin", "\u914d\u6599\u76c6");
        this.addLang("task.maidsoulkitchen.barbequesdelight_basin_skewering.desc", "Maid can skewer ingredients using the Barbeque Delight basin", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70e7\u70e4\u4e50\u4e8b\u914d\u6599\u76c6\u4e32\u70e7\u98df\u6750");
        this.addLang("task.maidsoulkitchen.barbequesdelight_basin_skewering.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.miners_delight_copper_pot_cooking", "Copper Pot", "\u94dc\u9505");
        this.addLang("task.maidsoulkitchen.miners_delight_copper_pot_cooking.desc", "Maid can cook food using the Miner's Delight copper pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u77ff\u5de5\u4e50\u4e8b\u7684\u94dc\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.miners_delight_copper_pot_cooking.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_kettle_kettle", "Teapot", "\u8336\u58f6");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_kettle_kettle.desc", "Maid can make tea using the Youkai's Homecoming teapot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u5996\u602a\u5f52\u5bb6\u7684\u8336\u58f6\u6ce1\u8336");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_kettle_kettle.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_fermentation_tank_fermentation", "Fermentation Tank", "\u53d1\u9175\u6876");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_fermentation_tank_fermentation.desc", "Maid can brew wine using the Youkai's Homecoming fermentation tank", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u5996\u602a\u5f52\u5bb6\u7684\u53d1\u9175\u6876\u917f\u9152");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_fermentation_tank_fermentation.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_drying_rack_drying_rack", "Drying Rack", "\u6652\u5e72\u67b6");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_drying_rack_drying_rack.desc", "Maid can dry tea leaves using the Youkai's Homecoming drying rack", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u5996\u602a\u5f52\u5bb6\u7684\u6652\u5e72\u67b6\u667e\u7f6e\u8336\u53f6");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_drying_rack_drying_rack.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_moka_pot_moka_pot", "Moka Pot", "\u6469\u5361\u58f6");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_moka_pot_moka_pot.desc", "Maid can make coffee using the Youkai's Homecoming moka pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u5996\u602a\u5f52\u5bb6\u7684\u6469\u5361\u58f6\u51b2\u5496\u5561");
        this.addLang("task.maidsoulkitchen.youkaishomecoming_moka_pot_moka_pot.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.berries_farm", "Berries", "\u6d46\u679c");
        this.addLang("task.maidsoulkitchen.berries_farm.desc", "Maid can harvest berries", "\u5973\u4ec6\u4f1a\u91c7\u96c6\u6d46\u679c");
        this.addLang("task.maidsoulkitchen.fruit_farm", "Fruit", "\u6c34\u679c");
        this.addLang("task.maidsoulkitchen.fruit_farm.desc", "Maid can harvest fruit", "\u5973\u4ec6\u4f1a\u91c7\u6458\u6c34\u679c");
        this.addLang("task.maidsoulkitchen.sereneseasons_farm", "Serene Seasons Farm", "\u56db\u5b63\u519c\u573a");
        this.addLang("task.maidsoulkitchen.sereneseasons_farm.desc", "Maid can properly harvest and plant seasonal crops", "\u5973\u4ec6\u4f1a\u6b63\u786e\u6536\u83b7\u548c\u79cd\u690d\u56db\u5b63\u4f5c\u7269");
        this.addLang("task.maidsoulkitchen.eclipticseasons_farm", "Ecliptic Seasons Farm", "\u8282\u6c14\u519c\u573a");
        this.addLang("task.maidsoulkitchen.eclipticseasons_farm.desc", "Maid can properly harvest and plant solar term crops", "\u5973\u4ec6\u4f1a\u6b63\u786e\u6536\u83b7\u548c\u79cd\u690d\u8282\u6c14\u4f5c\u7269");
        this.addLang("task.maidsoulkitchen.compat_melon", "Melon (Compat)", "\u74dc\u7c7b(\u517c\u5bb9)");
        this.addLang("task.maidsoulkitchen.compat_melon.desc", "Maid will harvest vanilla and other mods' melons, need to configure", "\u5973\u4ec6\u4f1a\u6536\u83b7\u539f\u7248\u4ee5\u53ca\u5176\u4ed6\u6a21\u7ec4\u7684\u74dc\u7c7b,\u9700\u8981\u81ea\u884c\u914d\u7f6e");
        this.addLang("task.maidsoulkitchen.compat_melon.condition.has_silk_touch", "Holding a tool with Silk Touch enchantment in main hand allows precise harvesting of melons", "\u4e3b\u624b\u6301\u6709\u5e26\u6709\u7cbe\u51c6\u91c7\u96c6\u9644\u9b54\u7684\u5de5\u5177\u65f6\uff0c\u80fd\u591f\u7cbe\u51c6\u91c7\u96c6\u74dc");
        this.addLang("task.maidsoulkitchen.feed_animal_t", "BreedT", "\u7e41\u6b962");
        this.addLang("task.maidsoulkitchen.feed_animal_t.desc", "Maid will attempt to breed different types of surrounding animals", "\u5973\u4ec6\u5c1d\u8bd5\u7e41\u6b96\u5468\u56f4\u4e0d\u540c\u79cd\u7c7b\u7684\u52a8\u7269");
        this.addLang("task.maidsoulkitchen.feed_animal_t.condition.can_feed", "Have items that can breed animals in the maid's inventory", "\u5973\u4ec6\u80cc\u5305\u4e2d\u6709\u53ef\u4ee5\u7e41\u6b96\u52a8\u7269\u7684\u7269\u54c1");
        this.addLang("task.maidsoulkitchen.feed_animal_t.condition.assault_weapon", "Main hand holds an assault weapon (to kill excess animals)", "\u4e3b\u624b\u6301\u6709\u653b\u51fb\u6027\u6b66\u5668\uff08\u7528\u4e8e\u6740\u6b7b\u8d85\u8fc7\u4e0a\u9650\u7684\u52a8\u7269\uff09");
        this.addLang("task.maidsoulkitchen.minecraft_furnace_smelting", "Furnace", "\u7194\u7089");
        this.addLang("task.maidsoulkitchen.minecraft_furnace_smelting.desc", "Maid will cook food or smelt ores, etc.", "\u5973\u4ec6\u4f1a\u70f9\u996a\u98df\u7269\u6216\u8005\u7194\u70bc\u77ff\u7269\u7b49");
        this.addLang("task.maidsoulkitchen.feedanddrink", "Feed and Drink", "\u5582\u98df\u4e0e\u996e\u6c34");
        this.addLang("task.maidsoulkitchen.feedanddrink.desc", "Maid will actively feed hungry or thirsty masters nearby", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u6295\u5582\u5468\u56f4\u9965\u6e34\u7684\u4e3b\u4eba");
        this.addLang("task.maidsoulkitchen.crockpot_crock_pot_crock_pot_cooking", "Crock Pot", "\u70f9\u996a\u9505");
        this.addLang("task.maidsoulkitchen.crockpot_crock_pot_crock_pot_cooking.desc", "Maid can cook food using the Crock Pot", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u70f9\u996a\u9505\u7684\u70f9\u996a\u9505\u70f9\u996a\u98df\u7269");
        this.addLang("task.maidsoulkitchen.crockpot_crock_pot_crock_pot_cooking.enable_condition.has_enough_favor", "Maid favor level >= 2", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e2");
        this.addLang("task.maidsoulkitchen.drinkbeer_beer_barrel_brewing", "Beer Barrel", "\u5564\u9152\u6876");
        this.addLang("task.maidsoulkitchen.drinkbeer_beer_barrel_brewing.desc", "Maid can brew beer using the Drink Beer beer barrel", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u548c\u5564\u9152\u5566\u7684\u5564\u9152\u6876\u917f\u9152");
        this.addLang("task.maidsoulkitchen.drinkbeer_beer_barrel_brewing.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_brewing_barrel_brewing_barrel", "Brewing Barrel", "\u917f\u9020\u6876");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_brewing_barrel_brewing_barrel.desc", "Maid can brew wine using the Kitchen Karrot brewing barrel", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u80e1\u841d\u535c\u53a8\u623f\u7684\u917f\u9020\u6876\u917f\u9152");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_brewing_barrel_brewing_barrel.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_air_compressor_air_compressing", "Air Compressor", "\u7a7a\u6c14\u538b\u7f29\u673a");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_air_compressor_air_compressing.desc", "Maid can make food using the Kitchen Karrot air compressor", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u80e1\u841d\u535c\u53a8\u623f\u7684\u7a7a\u6c14\u538b\u7f29\u673a\u5236\u4f5c\u98df\u7269");
        this.addLang("task.maidsoulkitchen.kitchenkarrot_air_compressor_air_compressing.enable_condition.has_enough_favor", "Maid favor level >= 1", "\u5973\u4ec6\u597d\u611f\u5ea6\u7b49\u7ea7\u5927\u4e8e\u7b49\u4e8e1");
        this.addLang("task.maidsoulkitchen.cook", "Cook", "\u70f9\u996a");
        this.addLang("task.maidsoulkitchen.cook.desc", "Maid will cook using cooking utensils", "\u5973\u4ec6\u4f1a\u70f9\u996a\u53a8\u5177\u8fdb\u884c\u70f9\u996a");
        this.addLang("task.maidsoulkitchen.idle", "Idle", "\u7a7a\u95f2");
    }

    protected void addOverlayLang() {
        this.addLang("overlay.maidsoulkitchen.book.tips", "The book will change the working mode to the retrieval start height value of the maid of the fruit\nRight-click +1, stealth right-click -1\nThe search range is 2 blocks up from the starting height", "\u4e66\u672c\u4f1a\u6539\u53d8\u5de5\u4f5c\u6a21\u5f0f\u4e3a\u6c34\u679c\u7684\u5973\u4ec6\u7684\u68c0\u7d22\u8d77\u59cb\u9ad8\u5ea6\u503c\n\u53f3\u51fb+1,\u6f5c\u884c\u53f3\u51fb-1\n\u68c0\u7d22\u8303\u56f4\u4e3a\u8d77\u59cb\u9ad8\u5ea6\u5411\u4e0a\u5ef6\u4f382\u683c");
        this.addLang("overlay.maidsoulkitchen.book.tips.search_yoffset", "SearchYOffest: ", "\u68c0\u7d22\u8d77\u59cb\u9ad8\u5ea6: ");
    }

    protected void addTopLang() {
        this.addLang("top.maidsoulkitchen.entity_maid.farm.rule", "Rule: ", "\u89c4\u5219: ");
        this.addLang("top.maidsoulkitchen.entity_maid.farm.fruit.search_y_offset", "Y_Retrieval: ", "\u68c0\u7d22\u9ad8\u5ea6: ");
        this.addLang("top.maidsoulkitchen.entity_maid.task.cook.type", "Type: ", "\u70f9\u996a\u7c7b\u578b: ");
    }

    protected void addMessageLang() {
        this.addLang("message.maidsoulkitchen.book.max_yoffset", "The value of YOffset must be within the range of -5 to 5", "\u68c0\u7d22\u8d77\u59cb\u9ad8\u5ea6\u7684\u53d6\u503c\u8303\u56f4\u4e3a-5\u52305");
        this.addLang("message.maidsoulkitchen.culinary_hub.bine_type_max", "The maximum number of chests of the type currently bound is 3", "\u5f53\u524d\u7ed1\u5b9a\u7684\u7c7b\u578b\u7684\u7bb1\u5b50\u6700\u591a\u4e3a3\u4e2a");
        this.addLang("message.maidsoulkitchen.warning.title", "---------------- Maidsoul Kitchen warning---------------", "----------------\u5973\u4ec6\u53a8\u623f\u8b66\u544a---------------");
        this.addLang("message.maidsoulkitchen.warning.compat_failed", "Some mods have failed to be compatible, and they have been automatically blocked for you!", "\u5f53\u524d\u6709\u90e8\u5206mod\u517c\u5bb9\u5931\u8d25\uff0c\u5df2\u81ea\u52a8\u4e3a\u60a8\u62e6\u622a\uff01");
        this.addLang("message.maidsoulkitchen.warning.clicked_to_report", "Please click here to give feedback to the author, otherwise it will never be resolved! ", "\u8bf7\u70b9\u51fb\u6b64\u5904\uff0c\u5411\u4f5c\u8005\u53cd\u9988\uff0c\u4e0d\u7136\u6c38\u8fdc\u4e0d\u4f1a\u5f97\u5230\u89e3\u51b3\uff01");
        this.addLang("message.maidsoulkitchen.warning.clicked_to_export", "Click here to open the folder, find %s, attach this file!", "\u70b9\u51fb\u6b64\u5904\u6253\u5f00\u6587\u4ef6\u5939\uff0c\u627e\u5230%s\uff0c\u9644\u4e0a\u6b64\u6587\u4ef6\u5373\u53ef\uff01");
        this.addLang("message.maidsoulkitchen.warning.feedbacked", "If you've already given feedback, or if the author already knows, you can ignore this information!", "\u5982\u679c\u60a8\u5df2\u7ecf\u53cd\u9988\u4e86\uff0c\u6216\u8005\u4f5c\u8005\u5df2\u7ecf\u77e5\u6653\uff0c\u53ef\u5ffd\u7565\u6b64\u4fe1\u606f\uff01");
        this.addLang("message.maidsoulkitchen.warning.failed_task", ">- Task: ", ">- \u4efb\u52a1\uff1a");
        this.addLang("message.maidsoulkitchen.warning.failed_modid", ", modid; ", "\uff0c\u6a21\u7ec4ID\uff1a");
        this.addLang("message.maidsoulkitchen.warning.end", "-----------------------------------------", "-----------------------------------------");
    }

    protected void addRuleLang() {
        this.addLang("rule.berry.maidsoulkitchen.berry_minecraft", "Minecraft", "\u539f\u7248");
        this.addLang("rule.berry.maidsoulkitchen.berry_minecraft.desc", "The maid will actively collect the minecraft sweet berries around here", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u539f\u7248\u7684\u751c\u6d46\u679c");
        this.addLang("rule.berry.maidsoulkitchen.berry_l2_harvester", "LightLand", "\u83b1\u7279\u5170\u4f5c\u7269");
        this.addLang("rule.berry.maidsoulkitchen.berry_l2_harvester.desc", "The maid will actively collect the lightland series crops around here", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u83b1\u7279\u5170\u7cfb\u5217\u7684\u4f5c\u7269");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_greentea", "Farmer's Respite (Green Tea Leaves)", "\u519c\u592b\u6687\u4e8b\uff08\u7eff\u8336\u53f6\uff09");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_greentea.desc", "The maid will take the initiative to collect the green tea leaves of the surrounding farmers respite", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u519c\u592b\u6687\u4e8b\u7684\u7eff\u8336\u53f6");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_greentea.condition.hastool", "Maid backpack with shears required", "\u9700\u8981\u5973\u4ec6\u80cc\u5305\u91cc\u6709\u526a\u5200");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_yellowtea", "Farmer's Respite (Yellow Tea Leaves)", "\u519c\u592b\u6687\u4e8b\uff08\u9ec4\u8336\u53f6\uff09");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_yellowtea.desc", "The maid will take the initiative to collect the yellow tea leaves of the surrounding farmers respite", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u519c\u592b\u6687\u4e8b\u7684\u9ec4\u8336\u53f6");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_yellowtea.condition.hastool", "Maid backpack with shears required", "\u9700\u8981\u5973\u4ec6\u80cc\u5305\u91cc\u6709\u526a\u5200");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_blacktea", "Farmer's Respite (Black Tea Leaves)", "\u519c\u592b\u6687\u4e8b\uff08\u7ea2\u8336\u53f6\uff09");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_blacktea.desc", "The maid will take the initiative to collect the black tea leaves of the surrounding farmers respite", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u519c\u592b\u6687\u4e8b\u7684\u7ea2\u8336\u53f6");
        this.addLang("rule.berry.maidsoulkitchen.berry_farmersrespite_blacktea.condition.hastool", "Maid backpack with shears required", "\u9700\u8981\u5973\u4ec6\u80cc\u5305\u91cc\u6709\u526a\u5200");
        this.addLang("rule.berry.maidsoulkitchen.berry_simple_farming", "Simple Farming", "\u7b80\u5355\u519c\u4e1a");
        this.addLang("rule.berry.maidsoulkitchen.berry_simple_farming.desc", "The maid will take the initiative to collect all kinds of shrubs from the simple farming around them", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u7b80\u5355\u519c\u4e1a\u7684\u5404\u79cd\u704c\u6728");
        this.addLang("rule.berry.maidsoulkitchen.berry_vinery", "Vinery", "\u8461\u56ed\u9152\u9999");
        this.addLang("rule.berry.maidsoulkitchen.berry_vinery.desc", "The maid will take the initiative to collect the various grapes that are fragrant from the surrounding viney", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u96c6\u5468\u56f4\u8461\u56ed\u9152\u9999\u7684\u5404\u79cd\u8461\u8404");
        this.addLang("rule.berry.maidsoulkitchen.berry_compat", "Compat", "\u517c\u5bb9\u6a21\u5f0f");
        this.addLang("rule.berry.maidsoulkitchen.berry_compat.desc", "The maid will try to gather various berries around here", "\u5973\u4ec6\u4f1a\u5c1d\u8bd5\u91c7\u96c6\u5468\u56f4\u7684\u5404\u79cd\u6d46\u679c");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_fruit_stack", "Fruit Stack", "\u679c\u6808\u4e30\u76c8");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_fruit_stack.desc", "The maid will take the initiative to pick a variety of fruits from the surrounding fruit stack", "\u5973\u4ec6\u4f1a\u91c7\u6458\u5468\u56f4\u679c\u6808\u4e30\u76c8\u7684\u5404\u79cd\u6c34\u679c");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_simple_farming", "Simple Farming", "\u7b80\u5355\u519c\u4e1a");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_simple_farming.desc", "The maid will take the initiative to pick a variety of fruits from the surrounding simple farming", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u6458\u5468\u56f4\u7b80\u5355\u519c\u4e1a\u7684\u5404\u79cd\u6c34\u679c");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_vinery", "Vinery", "\u8461\u56ed\u9152\u9999");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_vinery.desc", "The maid will take the initiative to pick a variety of fruits from the surrounding vinery", "\u5973\u4ec6\u4f1a\u4e3b\u52a8\u91c7\u6458\u5468\u56f4\u8461\u56ed\u9152\u9999\u7684\u5404\u79cd\u6c34\u679c");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_compat", "Compat", "\u517c\u5bb9\u6a21\u5f0f");
        this.addLang("rule.fruit.maidsoulkitchen.fruit_compat.desc", "The maid will try to pick various fruits around here", "\u5973\u4ec6\u4f1a\u5c1d\u8bd5\u91c7\u6458\u5468\u56f4\u7684\u5404\u79cd\u6c34\u679c");
    }

    protected void addGuiLang() {
        this.addLang("gui.maidsoulkitchen.btn.display.tooltip.1", "Click to search, click to take back again!", "\u70b9\u51fb\u53ef\u641c\u7d22\uff0c\u518d\u6b21\u70b9\u51fb\u6536\u56de\uff01");
        this.addLang("gui.maidsoulkitchen.btn.display.tooltip.2", "Scroll to switch display modes!", "\u6eda\u52a8\u5207\u6362\u663e\u793a\u6a21\u5f0f\uff01");
        this.addLang("gui.maidsoulkitchen.btn.display.mode.default", "Default", "\u9ed8\u8ba4");
        this.addLang("gui.maidsoulkitchen.btn.display.mode.can_cook", "Can cook", "\u53ef\u70f9\u996a");
        this.addLang("gui.maidsoulkitchen.btn.display.mode.not_cook", "Not cook", "\u4e0d\u53ef\u70f9\u996a");
        this.addLang("gui.maidsoulkitchen.btn.task_setting", "Task Setting", "\u4efb\u52a1\u8bbe\u7f6e");
        this.addLang("gui.maidsoulkitchen.btn.task_setting.desc", " -\u00a7a used to configer task, for example various of cooking task", " -\u00a7a \u7528\u4e8e\u4e00\u4e9b\u4efb\u52a1\u7684\u8bbe\u7f6e,\u6bd4\u5982\u5404\u79cd\u6a21\u5f0f\u7684\u70f9\u996a");
        this.addLang("gui.maidsoulkitchen.btn.task_book", "Task Book", "\u4efb\u52a1\u624b\u518c");
        this.addLang("gui.maidsoulkitchen.btn.task_book.desc", " -\u00a7a used to open the task book entry from memorizable gensokyo", " -\u00a7a \u7528\u4e8e\u8df3\u8f6c\u5230\u624b\u518c\u5bf9\u5e94\u7684\u7ae0\u8282");
        this.addLang("gui.maidsoulkitchen.btn.task_info", "Task Info", "\u4efb\u52a1\u4fe1\u606f");
        this.addLang("gui.maidsoulkitchen.btn.task_info.desc", " -\u00a7a used to display simple info", " -\u00a7a \u7528\u4e8e\u7b80\u5355\u663e\u793a\u8be5\u4efb\u52a1\u7684\u4fe1\u606f");
        this.addLang("gui.maidsoulkitchen.btn.task_warn_text", " -\u00a7c is dev, hope, wish", " -\u00a7c \u8fd8\u5728\u5f00\u53d1\u4e2d,\u656c\u8bf7\u671f\u5f85");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.blacklist", "Blacklist", "\u9ed1\u540d\u5355");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.whitelist", "Whitelist", "\u767d\u540d\u5355");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.whitelist.desc.0", "Change maid cook mode: Blacklist", "\u5207\u6362\u5973\u4ec6\u70f9\u996a\u6a21\u5f0f: \u9ed1\u540d\u5355");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.whitelist.desc.1", "- The maid will randomly cook from all recipes removed from the blacklist", "- \u5973\u4ec6\u4f1a\u4ece\u9664\u53bb\u9ed1\u540d\u5355\u91cc\u6240\u6709\u7684\u914d\u65b9\u91cc\u968f\u673a\u70f9\u996a");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.blacklist.desc.0", "Change maid cook mode: Whitelist", "\u5207\u6362\u5973\u4ec6\u70f9\u996a\u6a21\u5f0f: \u767d\u540d\u5355");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.type.blacklist.desc.1", "- The maid will cook randomly from the selected recipe", "- \u5973\u4ec6\u4f1a\u4ece\u9009\u5b9a\u7684\u914d\u65b9\u91cc\u968f\u673a\u70f9\u996a");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.can_cook", "The food is cookable: ", "\u5f53\u524d\u98df\u7269\u662f\u5426\u53ef\u70f9\u996a\uff1a");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.can_cook.true", "Yes", "\u662f");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.can_cook.false", "No", "\u5426");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.warn.now_type", "Now cook mode: ", "\u5f53\u524d\u70f9\u996a\u6a21\u5f0f: ");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.warn.not_select", "This cook mode type isn't selected, so can't select", "\u5f53\u524d\u70f9\u996a\u6a21\u5f0f\u4e0d\u662f\u5b9a\u5411\u6a21\u5f0f\uff0c\u65e0\u6cd5\u9009\u62e9");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.warn.over_size", "This cook selected recipes is over size : %d, so can't add", "\u5f53\u524d\u70f9\u996a\u5b9a\u5411\u914d\u65b9\u6570\u5df2\u7ecf\u8d85\u989d\uff1a%d, \u65e0\u6cd5\u6dfb\u52a0");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.selected_recs", "The recipe in %d/%d is currently selected", "\u5f53\u524d\u5df2\u9009\u62e9%d/%d\u914d\u65b9");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.info.warn", "Task Warning\uff1a", "\u4efb\u52a1\u8b66\u544a\uff1a");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.info.warn.crockpot", "- There are some problems with the recipe analysis of the crockpot task, which will be updated and optimized in the future!", "- \u7531\u4e8e\u70f9\u996a\u9505\u7684\u7279\u6b8a\u6027\uff0c\u914d\u65b9\u89e3\u6790\u6709\u4e00\u4e9b\u95ee\u9898\uff0c\u4f1a\u5728\u540e\u7eed\u7684\u66f4\u65b0\u4f18\u5316\uff01");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.info.warn.furnace", "- Due to the peculiarity of the furnace, it is not currently possible to interact with the culinary hub, but it will be updated and optimized in the future!", "- \u7531\u4e8e\u7194\u7089\u7684\u7279\u6b8a\u6027\uff0c\u6240\u4ee5\u5f53\u524d\u8fd8\u4e0d\u80fd\u4e0e\u70f9\u996a\u4e2d\u67a2\u4ea4\u4e92\uff0c\u4f1a\u5728\u540e\u7eed\u7684\u66f4\u65b0\u4f18\u5316\uff01");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.info.warn.furnace.1", "- Due to the special nature of the furnace's recipe, it is not currently controlled by the black and white list, and will be updated and optimized in the future!", "- \u7531\u4e8e\u7194\u7089\u7684\u914d\u65b9\u7279\u6b8a\u6027\uff0c\u6240\u4ee5\u5f53\u524d\u8fd8\u6ca1\u53d7\u5230\u9ed1\u767d\u540d\u5355\u7684\u63a7\u5236\uff0c\u4f1a\u5728\u540e\u7eed\u7684\u66f4\u65b0\u4f18\u5316\uff01");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.info.warn.cuttingboard", "- Due to the particularity of the cutting board task, it is not possible to interact with the culinary hub at present, and it will be updated and optimized in the future!", "- \u7531\u4e8e\u7827\u677f\u4efb\u52a1\u7684\u7279\u6b8a\u6027\uff0c\u6240\u4ee5\u5f53\u524d\u8fd8\u4e0d\u80fd\u4e0e\u70f9\u996a\u4e2d\u67a2\u4ea4\u4e92\uff0c\u4f1a\u5728\u540e\u7eed\u7684\u66f4\u65b0\u4f18\u5316\uff01");
        this.addLang("gui.maidsoulkitchen.widget.cook_guide.task.desc", "Now Task: %s", "\u5f53\u524d\u4efb\u52a1: %s");
        this.addLang("gui.maidsoulkitchen.widget.cook_guide.task.recipe_type", "RecipeType: %s", "\u914d\u65b9\u7c7b\u578b: %s");
        this.addLang("gui.maidsoulkitchen.widget.cook_guide.task.choose_cook_type", "Click to select a cooking mode.", "\u70b9\u51fb\u9009\u62e9\u4e00\u4e2a\u70f9\u996a\u6a21\u5f0f\u628a\uff01");
        this.addLang("gui.maidsoulkitchen.patchouli_warning.download", "Download Patchouli", "\u4e0b\u8f7d Patchouli");
        this.addLang("gui.maidsoulkitchen.patchouli_warning.tips", "You'll need to install the Patchouli mod to open book entry feature", "\u4f60\u9700\u8981\u4e0b\u8f7dPatchouli Mod\u624d\u53ef\u4ee5\u542f\u7528\u8df3\u8f6c\u5230\u624b\u518c\u5bf9\u5e94\u7ae0\u8282\u529f\u80fd");
        this.addLang("gui.maidsoulkitchen.cook_setting_screen.title", "Cook Guide", "\u70f9\u996a\u6307\u5357");
        this.addLang("gui.maidsoulkitchen.farm_config_screen.title", "Farm Guide", "\u519c\u573a\u6307\u5357");
        this.addLang("gui.maidsoulkitchen.compat_farm_configer_screen.title", "CompatFarm Guide", "\u519c\u8015\u6307\u5357");
        this.addLang("gui.maidsoulkitchen.berry_farm_configure_screen.title", "Berry Farm Guide", "\u6d46\u679c\u519c\u573a\u6307\u5357");
        this.addLang("gui.maidsoulkitchen.fruit_farm_configer_screen.title", "Fruit Farm Guide", "\u6c34\u679c\u519c\u573a\u6307\u5357");
        this.addLang("gui.maidsoulkitchen.fruit_farm_configer_screen.farm.fruit.search_y_offset", "Y_Retrieval: %s", "\u68c0\u7d22\u9ad8\u5ea6: %s");
        this.addLang("gui.maidsoulkitchen.config.no_config", "This task has no configuration.", "\u8fd9\u4e2a\u4efb\u52a1\u6ca1\u6709\u914d\u7f6e.");
        this.addLang("gui.maidsoulkitchen.config.global_config", "Configure this task globally.", "\u5168\u5c40\u914d\u7f6e\u8be5\u4efb\u52a1.");
        this.addLang("gui.maidsoulkitchen.search", "Search...", "\u641c\u7d22...");
        this.addLang("gui.maidsoulkitchen.to_setting_cook_task", "Click to enter the settings screen and select a cooking mode handle!", "\u70b9\u51fb\u8fdb\u5165\u8bbe\u7f6e\u754c\u9762\u9009\u62e9\u4e00\u4e2a\u70f9\u996a\u6a21\u5f0f\u628a\uff01");
        this.addLang("gui.maidsoulkitchen.culinary_hub.bag.ingredient", "Ingredient", "\u8f93\u5165\u539f\u6599");
        this.addLang("gui.maidsoulkitchen.culinary_hub.bag.other", "SA | IA | OA | Output", "\u542f\u52a8\u6761\u4ef6 | \u8f93\u5165\u539f\u6599\u6761\u4ef6 | \u8f93\u51fa\u6761\u4ef6 | \u8f93\u51fa");
        this.addLang("gui.maidsoulkitchen.culinary_hub.bag.title", "Cook Bag", "\u70f9\u996a\u888b");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.title", "Culinary hub config", "\u70f9\u996a\u4e2d\u67a2\u914d\u7f6e");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode", "Bind Mode", "\u6a21\u5f0f\u7ed1\u5b9a");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.ingredient", "Ingredient", "\u8f93\u5165\u539f\u6599");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.start_addition", "Start Addition", "\u542f\u52a8\u6761\u4ef6");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.ingredient_addition", "Ingredient Addition", "\u8f93\u5165\u539f\u6599\u6761\u4ef6");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.output_addition", "Output Addition", "\u8f93\u51fa\u6761\u4ef6");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.output", "Output", "\u8f93\u51fa");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses", "Clear", "\u6e05\u9664");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.ingredient.tooltip", "Here is the button to bind the box that stores the ingredients needed for cooking\n\nSuch as red mushrooms and white mushrooms in the mushroom pot, rice and tomatoes for Farmer's Delight's rice, tomato sauce", "\u8fd9\u91cc\u662f\u7528\u6765\u7ed1\u5b9a\u5b58\u653e\u70f9\u996a\u6240\u9700\u8981\u7684\u539f\u6750\u6599\u7684\u7bb1\u5b50\u7684\u6309\u94ae\n\n\u6bd4\u5982\u8611\u83c7\u7172\u7684\u7ea2\u8272\u8611\u83c7\u3001\u767d\u8272\u8611\u83c7\uff0c\u519c\u592b\u4e50\u4e8b\u7684\u7c73\u996d\u3001\u756a\u8304\u9171\u6240\u9700\u8981\u7684\u7a3b\u7c73\u3001\u756a\u8304");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.start_addition.tooltip", "Here is the button to bind the box that stores the items needed to start the prerequisites for cooking utensils\n\nSuch as the water (bucket) needed for the teakettle for the youkai's home coming, and the fuel (coal) needed for the crockpot for the crockpot\n\nBut at present, the source of these resources can only be the maid's backpack, so it is better to use it with the gap\n\nRemember to disable the effective slot (the fifth block in the first column).", "\u8fd9\u91cc\u662f\u7528\u6765\u7ed1\u5b9a\u5b58\u653e\u542f\u52a8\u53a8\u5177\u70f9\u996a\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6240\u9700\u8981\u7684\u7269\u54c1\u7684\u7bb1\u5b50\u7684\u6309\u94ae\n\n\u6bd4\u5982\u5996\u602a\u5f52\u5bb6\u7684\u8336\u58f6\u9700\u8981\u7684\u6c34\u8d44\u6e90\uff08\u6c34\u6876\uff09\u3001\u70f9\u996a\u9505\u7684\u70f9\u996a\u9505\u9700\u8981\u7684\u71c3\u6599\uff08\u7164\u70ad\uff09\n\n\u4f46\u76ee\u524d\u8fd9\u4e9b\u8d44\u6e90\u7684\u6765\u6e90\u8fd8\u53ea\u80fd\u662f\u5973\u4ec6\u80cc\u5305\uff0c\u6240\u4ee5\u548c\u9699\u95f4\u642d\u914d\u4f7f\u7528\u6548\u679c\u66f4\u4f73\u54e6\n\n\u4f46\u8bb0\u7684\u628a\u751f\u6548\u680f\u4f4d\uff08\u7b2c\u4e00\u680f\u7b2c\u4e94\u683c\uff09\u7981\u7528\u54e6");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.ingredient_addition.tooltip", "...", "...");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.output_addition.tooltip", "Here is the button to bind the box that stores the containers needed to take out the food that has already been cooked\n\nFor example, the bowl needed to take out the mushroom pot in the Farmer's Delight's cooking pot, and the glass bottle for apple cider", "\u8fd9\u91cc\u662f\u7528\u6765\u7ed1\u5b9a\u5b58\u653e\u53d6\u51fa\u53a8\u5177\u5df2\u7ecf\u70f9\u996a\u597d\u7684\u98df\u7269\u6240\u9700\u8981\u7684\u5bb9\u5668\u7684\u7bb1\u5b50\u7684\u6309\u94ae\n\n\u6bd4\u5982\u519c\u592b\u4e50\u4e8b\u7684\u53a8\u9505\u53d6\u51fa\u8611\u83c7\u7172\u6240\u9700\u8981\u7684\u7897\uff0c\u82f9\u679c\u9152\u6240\u9700\u8981\u7684\u73bb\u7483\u74f6");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.bind_mode.output.tooltip", "Here is the button to bind the box for storing cooked food\n\nsuch as the cooked mushroom pot, rice, and cider", "\u8fd9\u91cc\u662f\u7528\u6765\u7ed1\u5b9a\u5b58\u653e\u70f9\u996a\u597d\u7684\u98df\u7269\u7684\u7bb1\u5b50\u7684\u6309\u94ae\n\n\u6bd4\u5982\u70f9\u996a\u597d\u7684\u8611\u83c7\u7172\u3001\u7c73\u996d\u3001\u82f9\u679c\u9152");
        this.addLang("gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses.tooltip", "Clear the coordinates of bound boxes with one click", "\u4e00\u952e\u6e05\u9664\u5df2\u7ed1\u5b9a\u8fc7\u7684\u7bb1\u5b50\u7684\u5750\u6807");
        this.addLang("gui.maidsoulkitchen.culinary_hub.already_bind_types", "The current block is bound to the following types: ", "\u5f53\u524d\u65b9\u5757\u5df2\u7ed1\u5b9a\u4ee5\u4e0b\u7c7b\u578b\uff1a");
        this.addLang("gui.maidsoulkitchen.culinary_hub.can_sneak_bind", "The current block can be sneak bound!", "\u5f53\u524d\u65b9\u5757\u53ef\u6f5c\u884c\u7ed1\u5b9a\uff01");
        this.addLang("gui.maidsoulkitchen.culinary_hub.right_click_to_bind", "Right-click on the air and choose one to bind!", "\u8fd8\u6ca1\u9009\u62e9\u7ed1\u5b9a\u7c7b\u578b\u5462\uff0c\u9762\u5bf9\u7a7a\u6c14\u53f3\u952e\u9009\u62e9\u4e00\u4e2a\u5427\uff01");
        this.addLang("gui.maidsoulkitchen.culinary_hub.current_binding_type", "Current binding type:", "\u5f53\u524d\u7ed1\u5b9a\u7c7b\u578b\uff1a");
        this.addLang("gui.maidsoulkitchen.development", "(Development)", "(\u5f00\u53d1\u4e2d)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type", "Source%d: ", "\u6765\u6e90%d: ");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.main_hand", "Mainhand", "\u4e3b\u624b");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.off_hand", "Offhand", "\u526f\u624b");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.maid_backpack", "Backpack", "\u80cc\u5305");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.hub_start_addition", "Culinary hub(Start Addition)", "\u70f9\u996a\u4e2d\u67a2(\u542f\u52a8\u6761\u4ef6)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.hub_ingredient", "Culinary hub(Ingredinet)", "\u70f9\u996a\u4e2d\u67a2(\u8f93\u5165\u539f\u6599)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.hub_ingredient_addition", "Culinary hub(Ingredient Addition)", "\u70f9\u996a\u4e2d\u67a2(\u8f93\u5165\u539f\u6599\u6761\u4ef6)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.hub_output_addition", "Culinary hub(Output Addition)", "\u70f9\u996a\u4e2d\u67a2(\u8f93\u51fa\u6761\u4ef6)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.hub_output", "Culinary hub(Output)", "\u70f9\u996a\u4e2d\u67a2(\u8f93\u51fa)");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type.pickup", "Pickup => Mainhand\u3001Offhand\u3001Backpack", "\u62fe\u53d6 => \u4e3b\u624b\u3001\u526f\u624b\u3001\u80cc\u5305");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_type.mandatory", "Mandatory", "\u5fc5\u987b");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_type.maybe", "Maybe", "\u53ef\u80fd");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.ingredient_type.output", "Result", "\u6210\u54c1");
        this.addLang("gui.maidsoulkitchen.btn.cook_guide.output_to", "Output to: ", "\u8f93\u51fa\u81f3%d: ");
    }

    protected void addPatchouliLang() {
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.cook", "Cook", "\u70f9\u996a");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.cook.pages.0.1.text", "Maid can cook by using mod blocks.$(br) You just need to put recipe ingredient on the maid inventory.", "\u5973\u4ec6\u4f1a\u4f7f\u7528\u6a21\u7ec4\u53a8\u5177\u65b9\u5757\u8fdb\u884c\u70f9\u996a.$(br)\u4f60\u53ea\u9700\u8981\u628a\u914d\u65b9\u539f\u6599\u653e\u5165\u5230\u5973\u4ec6\u80cc\u5305.$(br)\u4e0b\u9762\u5c06\u4f1a\u4ecb\u7ecd\u5973\u4ec6\u70f9\u996a\u4efb\u52a1\u7684\u4e00\u4e9b\u4fe1\u606f,\u8bf7\u8be6\u7ec6\u9605\u8bfb");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.cook.pages.1.1.text", "You can use the Cooking Hub to set the location of the cooking ingredients and the food chests$(br) It needs to be placed in the fifth slot in the first column of the maid's backpack$(br) If present, it interacts with the Cooking Hub - the bound crate interacts$(br) Ps:It is even more effective when used with gaps$(br)- Right-click to open the GUI and select the type you want to bind$(br) - Stealth, right-click the chest to bind, and right-click again to unbind", "\u4f60\u53ef\u4ee5\u4f7f\u7528\u70f9\u996a\u4e2d\u67a2\u8bbe\u7f6e\u70f9\u996a\u7684\u539f\u6599\u4e0e\u98df\u7269\u7684\u7bb1\u5b50\u7684\u4f4d\u7f6e$(br) \u9700\u8981\u653e\u5230\u5973\u4ec6\u80cc\u5305\u7b2c\u4e00\u680f\u7b2c\u4e94\u4e2a\u683c\u5b50$(br) \u5982\u679c\u5b58\u5728\u5219\u4e0e\u70f9\u996a\u4e2d\u67a2\u4ea4\u4e92\u2014\u2014\u7ed1\u5b9a\u7684\u7bb1\u5b50\u4ea4\u4e92$(br) Ps:\u4e0e\u9699\u95f4\u642d\u914d\u4f7f\u7528\u6548\u679c\u66f4\u52a0\u54e6$(br)- \u53f3\u952e\u6253\u5f00GUI\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u7c7b\u578b$(br) - \u6f5c\u884c\u53f3\u51fb\u7bb1\u5b50\u4ee5\u7ed1\u5b9a\uff0c\u518d\u6b21\u53f3\u51fb\u53d6\u6d88\u7ed1\u5b9a");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.cook.pages.4.1.text", "This is the settings screen for the maid's cooking task, and you can click on the sidebar to jump to this screen firstn$(br)- 1.This is a display of the current maid's cooking tasks$(br)- 2. Toggle Cooking Mode: Blacklist vs. Whitelist Mode$(br) - Blacklist Mode: Randomly select the matching recipe from the remaining recipes after removing the selected recipe for cooking$(br) - Whitelist Mode: Randomly select the matching recipe from the selected recipe for cooking$(br)- 3.Select the food you want to cook$(br)- 4.You can click the up and down buttons to switch between the upper and lower page recipes, or the mouse wheel can also be used", "\u8fd9\u662f\u5973\u4ec6\u70f9\u996a\u4efb\u52a1\u7684\u8bbe\u7f6e\u754c\u9762\uff0c\u4f60\u53ef\u4ee5\u70b9\u51fb\u4fa7\u8fb9\u680f\u7b2c\u4e00\u4e2a\u8df3\u8f6c\u5230\u8fd9\u754c\u9762$(br)- 1.\u8fd9\u662f\u663e\u793a\u5f53\u524d\u5973\u4ec6\u7684\u70f9\u996a\u4efb\u52a1$(br)- 2.\u5207\u6362\u70f9\u996a\u6a21\u5f0f\uff1a\u9ed1\u540d\u5355\u4e0e\u767d\u540d\u5355\u6a21\u5f0f$(br)  - \u9ed1\u540d\u5355\u6a21\u5f0f\uff1a\u4ece\u9664\u53bb\u9009\u62e9\u7684\u914d\u65b9\u540e\u7684\u5269\u4e0b\u914d\u65b9\u4e2d\u968f\u673a\u62bd\u53d6\u7b26\u5408\u7684\u914d\u65b9\u8fdb\u884c\u70f9\u996a$(br)  - \u767d\u540d\u5355\u6a21\u5f0f\uff1a\u4ece\u9009\u5b9a\u7684\u914d\u65b9\u4e2d\u968f\u673a\u62bd\u53d6\u7b26\u5408\u7684\u914d\u65b9\u8fdb\u884c\u70f9\u996a$(br)- 3.\u9009\u62e9\u8981\u70f9\u996a\u7684\u98df\u7269$(br)- 4.\u4f60\u53ef\u4ee5\u70b9\u51fb\u4e0a\u4e0b\u6309\u94ae\u6765\u5207\u6362\u4e0a\u4e0b\u9875\u914d\u65b9,\u6216\u8005\u9f20\u6807\u6eda\u8f6e\u4e5f\u53ef\u4ee5");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.cook.pages.5.1.text", "Use this bauble to prevent kitchen homicides!", "\u4f7f\u7528\u8fd9\u4e2a\u9970\u54c1\u53ef\u4ee5\u9884\u9632\u53a8\u623f\u6740\u4eba\u6848\u54e6\uff01");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.berry.pages.0.1.text", "The maid collects berries, which can be configured on the maid task configuration screen", "\u5973\u4ec6\u4f1a\u91c7\u96c6\u6d46\u679c\uff0c\u53ef\u4ee5\u5973\u4ec6\u4efb\u52a1\u914d\u7f6e\u754c\u9762\u914d\u7f6e");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.fruit", "Fruit", "\u6c34\u679c");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.fruit.pages.0.1.text", "Maid can harvest fruits, which can be configured on the maid task configuration screen.", "\u5973\u4ec6\u53ef\u4ee5\u91c7\u6458\u6c34\u679c\uff0c\u53ef\u4ee5\u5973\u4ec6\u4efb\u52a1\u914d\u7f6e\u754c\u9762\u914d\u7f6e.");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.berry", "Berry", "\u6d46\u679c");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.other", "Other", "\u5176\u4ed6");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.other.pages.0.1.text", "Welcome to the Farming & Cooking mod", "\u6b22\u8fce\u4e0b\u8f7d\u4f7f\u7528\u519c\u8015\u4e0e\u70f9\u996a\u6a21\u7ec4");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.other.pages.0.text.link_text", "Feedback link", "\u53cd\u9988\u94fe\u63a5");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.melon", "Melon", "\u74dc\u7c7b");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.melon.pages.0.1.text", "The maid will harvest the melons around it, the same as the ontology melon quest, but the compatibility has been made, you can open the maid global configuration page or open the configuration file to configure", "\u5973\u4ec6\u4f1a\u6536\u83b7\u5468\u56f4\u7684\u74dc\uff0c\u540c\u672c\u4f53\u74dc\u7c7b\u4efb\u52a1\u4e00\u6837\uff0c\u4f46\u505a\u51fa\u4e86\u517c\u5bb9\u6027\uff0c\u4f60\u53ef\u4ee5\u6253\u5f00\u5973\u4ec6\u5168\u5c40\u914d\u7f6e\u9875\u9762\u6216\u8005\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u8fdb\u884c\u914d\u7f6e");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.sereneseasons_farm", "Serene Seasons Farm", "\u56db\u5b63\u519c\u573a");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.sereneseasons_farm.pages.0.1.text", "If you have installed Serene Seasons, the maid will plant according to the growing season", "\u5982\u679c\u4f60\u5b89\u88c5\u4e86\u9759\u8c27\u56db\u5b63\uff0c\u90a3\u4e48\u5973\u4ec6\u4f1a\u6309\u7167\u4f5c\u7269\u751f\u957f\u5b63\u8282\u6765\u79cd\u690d");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.feed_animal_t", "BreedT", "\u7e41\u6b96");
        this.addLang("patchouli.touhou_little_maid.book.entries.maidsoulkitchen.feed_animal_t.pages.0.1.text", "The number of breeds in this mode is divided by animal species, with a maximum of 20 per animal", "\u6b64\u6a21\u5f0f\u4e0b\u7e41\u6b96\u7684\u6570\u91cf\u4f1a\u6309\u7167\u52a8\u7269\u79cd\u7c7b\u6765\u533a\u5206\uff0c\u6bcf\u79cd\u52a8\u7269\u6700\u5927\u7e41\u6b96\u6570\u91cf\u4e3a20");
        this.addLang("patchouli.touhou_little_maid.book.categories.maidsoulkitchen", "Addon[Farm And Cook]", "\u62d3\u5c55[\u519c\u8015\u4e0e\u70f9\u996a]");
        this.addLang("patchouli.touhou_little_maid.book.categories.maidsoulkitchen.description", "A addon that make maid lear more skill about farm and cook.", "\u4e00\u4e2a\u9644\u5c5e\u6a21\u7ec4,\u8ba9\u5973\u4ec6\u5b66\u4f1a\u519c\u8015\u4e0e\u70f9\u996a\u6280\u5de7.");
    }

    protected void addLang(String key, String en_us, String zh_cn) {
        LangVal enLangVal = new LangVal(Local.EN_US, en_us);
        LangVal zhLangVal = new LangVal(Local.ZH_CN, zh_cn);
        this.map.put(key, (Pair<LangVal, LangVal>)Pair.of((Object)enLangVal, (Object)zhLangVal));
    }

    protected void addItemLang(Item item, String en_us, String zh_cn) {
        this.addLang(item.m_5524_(), en_us, zh_cn);
    }

    public static enum Local {
        EN_US,
        ZH_CN;

    }

    public record LangVal(Local local, String val) {
    }
}

