/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.ApiStatus;

public final class RegistrateGenericProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> registrate;
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final ExistingFileHelper existingFileHelper;
    private final LogicalSide side;
    private final ProviderType<RegistrateGenericProvider> providerType;
    private final List<Generator> generators = Lists.newArrayList();

    @ApiStatus.Internal
    RegistrateGenericProvider(AbstractRegistrate<?> registrate, GatherDataEvent event, LogicalSide side, ProviderType<RegistrateGenericProvider> providerType) {
        this.registrate = registrate;
        this.side = side;
        this.providerType = providerType;
        this.output = event.getGenerator().getPackOutput();
        this.registries = event.getLookupProvider();
        this.existingFileHelper = event.getExistingFileHelper();
    }

    public RegistrateGenericProvider add(Generator generator) {
        this.generators.add(generator);
        return this;
    }

    @Override
    public LogicalSide getSide() {
        return this.side;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.generators.clear();
        GeneratorData data = new GeneratorData(this.output, this.registries, this.existingFileHelper);
        this.registrate.genData(this.providerType, this);
        return CompletableFuture.allOf((CompletableFuture[])this.generators.stream().map(generator -> generator.generate(data)).map(provider -> provider.m_213708_(cache)).toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "generic_%s_provider".formatted(this.side.name().toLowerCase(Locale.ROOT));
    }

    public record GeneratorData(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
    }

    @FunctionalInterface
    public static interface Generator {
        public DataProvider generate(GeneratorData var1);
    }
}

