/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FluidBuilder<T extends ForgeFlowingFluid, P>
extends AbstractBuilder<Fluid, T, P, FluidBuilder<T, P>> {
    private final String sourceName;
    private final String bucketName;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory;
    @Nullable
    private final NonNullSupplier<FluidType> fluidType;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<FluidType.Properties> typeProperties;
    private NonNullConsumer<ForgeFlowingFluid.Properties> fluidProperties;
    @Nullable
    private Supplier<RenderType> layer;
    private boolean registerType;
    @Nullable
    private NonNullSupplier<? extends ForgeFlowingFluid> source;
    private final List<TagKey<Fluid>> tags;

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, FluidBuilder::defaultFluidType, ForgeFlowingFluid.Flowing::new);
    }

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidTypeFactory typeFactory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, typeFactory, ForgeFlowingFluid.Flowing::new);
    }

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, fluidType, ForgeFlowingFluid.Flowing::new);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, FluidBuilder::defaultFluidType, fluidFactory);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, typeFactory, fluidFactory).defaultLang().defaultSource().defaultBlock().defaultBucket();
        return ret;
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, fluidType, fluidFactory).defaultLang().defaultSource().defaultBlock().defaultBucket();
        return ret;
    }

    public FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        super(owner, parent, "flowing_" + name, callback, ForgeRegistries.Keys.FLUIDS);
        this.typeProperties = $ -> {};
        this.layer = null;
        this.tags = new ArrayList<TagKey<Fluid>>();
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.fluidFactory = fluidFactory;
        this.fluidType = NonNullSupplier.lazy(() -> typeFactory.create(this.makeTypeProperties(), this.stillTexture, this.flowingTexture));
        this.registerType = true;
        String bucketName = this.bucketName;
        this.fluidProperties = p -> p.bucket(() -> (Item)owner.get(bucketName, ForgeRegistries.Keys.ITEMS).get()).block(() -> (LiquidBlock)owner.get(name, ForgeRegistries.Keys.BLOCKS).get());
    }

    public FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        super(owner, parent, "flowing_" + name, callback, ForgeRegistries.Keys.FLUIDS);
        this.typeProperties = $ -> {};
        this.layer = null;
        this.tags = new ArrayList<TagKey<Fluid>>();
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.fluidFactory = fluidFactory;
        this.fluidType = fluidType;
        this.registerType = false;
        String bucketName = this.bucketName;
        this.fluidProperties = p -> p.bucket(() -> (Item)owner.get(bucketName, ForgeRegistries.Keys.ITEMS).get()).block(() -> (LiquidBlock)owner.get(name, ForgeRegistries.Keys.BLOCKS).get());
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<FluidType.Properties> cons) {
        this.typeProperties = this.typeProperties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> fluidProperties(NonNullConsumer<ForgeFlowingFluid.Properties> cons) {
        this.fluidProperties = this.fluidProperties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> defaultLang() {
        return (FluidBuilder)this.lang(f -> f.getFluidType().getDescriptionId(), RegistrateLangProvider.toEnglishName(this.sourceName));
    }

    public FluidBuilder<T, P> lang(String name) {
        return (FluidBuilder)this.lang(f -> f.getFluidType().getDescriptionId(), name);
    }

    public FluidBuilder<T, P> renderType(Supplier<RenderType> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FluidBuilder.lambda$renderType$10((Supplier)layer));
        if (this.layer == null) {
            this.onRegister(this::registerRenderType);
        }
        this.layer = layer;
        return this;
    }

    protected void registerRenderType(T entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(this.getOwner(), FMLClientSetupEvent.class, $ -> {
            if (this.layer != null) {
                RenderType layer = this.layer.get();
                ItemBlockRenderTypes.setRenderLayer((Fluid)entry, (RenderType)layer);
                ItemBlockRenderTypes.setRenderLayer((Fluid)this.getSource(), (RenderType)layer);
            }
        }));
    }

    public FluidBuilder<T, P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public FluidBuilder<T, P> source(NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid> factory) {
        this.defaultSource = false;
        this.source = NonNullSupplier.lazy(() -> (ForgeFlowingFluid)factory.apply(this.makeProperties()));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public BlockBuilder<LiquidBlock, FluidBuilder<T, P>> block() {
        return this.block(LiquidBlock::new);
    }

    public <B extends LiquidBlock> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, BlockBehaviour.Properties, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        Lazy lightLevel = Lazy.of(() -> this.fluidType.get().getLightLevel());
        ToIntFunction<BlockState> lightLevelInt = $ -> (Integer)lightLevel.get();
        return this.getOwner().block(this, this.sourceName, p -> (LiquidBlock)factory.apply(supplier, (BlockBehaviour.Properties)p)).properties(p -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()).properties(p -> p.m_60953_(lightLevelInt)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    @Beta
    public FluidBuilder<T, P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public FluidBuilder<T, P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<BucketItem, FluidBuilder<T, P>> bucket() {
        return this.bucket(BucketItem::new);
    }

    public <I extends BucketItem> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<Supplier<? extends ForgeFlowingFluid>, Item.Properties, ? extends I> factory) {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        NonNullSupplier<? extends ForgeFlowingFluid> source = this.source;
        if (source == null) {
            throw new IllegalStateException("Cannot create a bucket before creating a source block");
        }
        return this.getOwner().item(this, this.bucketName, p -> (BucketItem)factory.apply(source::get, (Item.Properties)p)).properties(p -> p.m_41495_(Items.f_42446_).m_41487_(1)).model((ctx, prov) -> prov.generated(ctx::getEntry, new ResourceLocation(this.getOwner().getModid(), "item/" + this.bucketName)));
    }

    @Beta
    public FluidBuilder<T, P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> tag(TagKey<Fluid> ... tags) {
        FluidBuilder ret = (FluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryKey(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(prov::addTag).forEach(p -> p.m_255204_(this.getSource().m_205069_().m_205785_())));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> removeTag(TagKey<Fluid> ... tags) {
        this.tags.removeAll(Arrays.asList(tags));
        return (FluidBuilder)this.removeTag(ProviderType.FLUID_TAGS, tags);
    }

    private ForgeFlowingFluid getSource() {
        NonNullSupplier<? extends ForgeFlowingFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return source.get();
    }

    private ForgeFlowingFluid.Properties makeProperties() {
        NonNullSupplier<? extends ForgeFlowingFluid> source = this.source;
        ForgeFlowingFluid.Properties ret = new ForgeFlowingFluid.Properties(this.fluidType, source == null ? null : source::get, this.asSupplier());
        this.fluidProperties.accept(ret);
        return ret;
    }

    private FluidType.Properties makeTypeProperties() {
        FluidType.Properties properties = FluidType.Properties.create();
        RegistryEntry block = this.getOwner().getOptional(this.sourceName, ForgeRegistries.Keys.BLOCKS);
        this.typeProperties.accept(properties);
        if (block.isPresent()) {
            properties.descriptionId(((Block)block.get()).m_7705_());
            this.setData(ProviderType.LANG, NonNullBiConsumer.noop());
        } else {
            properties.descriptionId(Util.m_137492_((String)"fluid", (ResourceLocation)new ResourceLocation(this.getOwner().getModid(), this.sourceName)));
        }
        return properties;
    }

    @Override
    protected T createEntry() {
        return (T)((ForgeFlowingFluid)this.fluidFactory.apply(this.makeProperties()));
    }

    @Override
    public FluidEntry<T> register() {
        NonNullSupplier<? extends ForgeFlowingFluid> source;
        if (this.fluidType != null) {
            if (this.registerType) {
                this.getOwner().simple(this, this.sourceName, ForgeRegistries.Keys.FLUID_TYPES, this.fluidType);
            }
        } else {
            throw new IllegalStateException("Fluid must have a type: " + this.getName());
        }
        if (this.defaultSource == Boolean.TRUE) {
            this.source(ForgeFlowingFluid.Source::new);
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, ForgeRegistries.Keys.FLUIDS, this, source::get);
        return (FluidEntry)super.register();
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new FluidEntry<T>(this.getOwner(), delegate);
    }

    private static FluidType defaultFluidType(FluidType.Properties properties, final ResourceLocation stillTexture, final ResourceLocation flowingTexture) {
        return new FluidType(properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flowingTexture;
                    }
                });
            }
        };
    }

    private static /* synthetic */ void lambda$renderType$10(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.m_110506_().contains(layer.get()), (Object)("Invalid render type: " + layer));
    }

    @FunctionalInterface
    public static interface FluidTypeFactory {
        public FluidType create(FluidType.Properties var1, ResourceLocation var2, ResourceLocation var3);
    }
}

