/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.base;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.ISortSlotContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;

public interface IMaidStorage {
    public ResourceLocation getType();

    default public boolean supportCollect() {
        return true;
    }

    default public boolean supportPlace() {
        return true;
    }

    default public boolean supportView() {
        return true;
    }

    public boolean isValidTarget(ServerLevel var1, LivingEntity var2, BlockPos var3, @Nullable Direction var4, BlockState var5, BlockEntity var6);

    @Nullable
    public IStorageContext onStartCollect(ServerLevel var1, EntityMaid var2, Target var3);

    @Nullable
    public IStorageContext onStartPlace(ServerLevel var1, EntityMaid var2, Target var3);

    @Nullable
    public IStorageContext onStartView(ServerLevel var1, EntityMaid var2, Target var3);

    @Nullable
    default public IStorageContext onPreviewFilter(ServerLevel level, EntityMaid maid, Target storage) {
        return null;
    }

    @Nullable
    default public ISortSlotContext onStartSorting(ServerLevel level, EntityMaid maid, Target target) {
        return null;
    }

    default public boolean isCraftGuideProvider(List<ViewedInventoryMemory.ItemCount> blockPos) {
        return blockPos.stream().anyMatch(i -> i.item().m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()));
    }
}

