/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ItemHandler;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Stack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.SimulateTargetInteractHelper;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.AbstractFilterableBlockStorage;
import studio.fantasyit.maid_storage_manager.storage.base.ISlotBasedStorage;
import studio.fantasyit.maid_storage_manager.storage.base.ISortSlotContext;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class AbstractItemHandlerContext
extends AbstractFilterableBlockStorage
implements ISortSlotContext,
ISlotBasedStorage {
    boolean isSortingSlots = false;
    int sortingSlot = -1;
    protected SimulateTargetInteractHelper helper;

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
        this.helper = new SimulateTargetInteractHelper(maid, target.getPos(), target.getSide().orElse(null), level);
        this.helper.open();
    }

    @Override
    public void startSorting() {
        if (this.helper.itemHandler == null) {
            return;
        }
        this.isSortingSlots = true;
        this.sortingSlot = this.helper.itemHandler.getSlots() - 1;
    }

    @Override
    public void tickSorting() {
        if (this.helper.itemHandler == null || !this.isSortingSlots || this.sortingSlot <= 0) {
            this.isSortingSlots = false;
            return;
        }
        int cstT = 3000 / this.helper.itemHandler.getSlots();
        while (this.sortingSlot >= 0 && cstT > 0) {
            int cur;
            if (this.helper.itemHandler.getStackInSlot(this.sortingSlot).m_41619_()) {
                --this.sortingSlot;
                continue;
            }
            --cstT;
            int targetP = -1;
            int lastSuccess = -1;
            for (cur = this.sortingSlot - 1; cur >= 0 && this.isSame(cur, this.sortingSlot); --cur) {
            }
            if (cur < 0) {
                this.sortingSlot = -1;
                this.isSortingSlots = false;
                continue;
            }
            while (cur >= 0) {
                if (this.isSame(cur, this.sortingSlot)) {
                    if (lastSuccess != cur + 1) {
                        targetP = cur;
                    }
                    lastSuccess = cur;
                }
                --cur;
            }
            if (targetP != -1) {
                int targetIndex = targetP + 1;
                this.swap(targetIndex, this.sortingSlot);
                this.sortingSlot = this.helper.itemHandler.getSlots() - 1;
                continue;
            }
            --this.sortingSlot;
        }
    }

    private void swap(int slot1, int slot2) {
        ItemStack itemStack;
        if (slot2 == slot1 || this.helper.itemHandler == null) {
            return;
        }
        Stack<ItemStack> extracted = new Stack<ItemStack>();
        while (this.helper.itemHandler.getStackInSlot(slot1).m_41613_() > 0 && !(itemStack = this.helper.itemHandler.extractItem(slot1, this.helper.itemHandler.getStackInSlot(slot1).m_41613_(), false)).m_41619_()) {
            extracted.push(itemStack);
        }
        while (this.helper.itemHandler.getStackInSlot(slot2).m_41613_() > 0 && !(itemStack = this.helper.itemHandler.extractItem(slot2, this.helper.itemHandler.getStackInSlot(slot2).m_41613_(), true)).m_41619_()) {
            @NotNull ItemStack rest = this.helper.itemHandler.insertItem(slot1, itemStack, true);
            ItemStack toInsert = itemStack.m_41777_();
            toInsert.m_41774_(rest.m_41613_());
            if (toInsert.m_41619_()) break;
            this.helper.itemHandler.insertItem(slot1, this.helper.itemHandler.extractItem(slot2, toInsert.m_41613_(), false), false);
        }
        while (!extracted.isEmpty()) {
            ItemStack tmp = (ItemStack)extracted.pop();
            int count1 = tmp.m_41613_();
            ItemStack itemStack2 = this.helper.itemHandler.insertItem(slot2, tmp, false);
            if (itemStack2.m_41613_() != count1) continue;
            break;
        }
        while (!extracted.isEmpty()) {
            this.helper.opener.m_36176_((ItemStack)extracted.pop(), true);
        }
    }

    private boolean isSame(int slot1, int slot2) {
        if (this.helper.itemHandler == null) {
            return false;
        }
        return ItemStackUtil.isSame(this.helper.itemHandler.getStackInSlot(slot1), this.helper.itemHandler.getStackInSlot(slot2), false);
    }

    @Override
    public boolean isDoneSorting() {
        return !this.isSortingSlots;
    }

    @Override
    public int getSlots() {
        if (this.helper.itemHandler == null) {
            return 0;
        }
        return this.helper.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        if (this.helper.itemHandler == null) {
            return ItemStack.f_41583_;
        }
        return this.helper.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void finish() {
        this.helper.stop();
    }
}

