/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.render.map_like;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import studio.fantasyit.maid_storage_manager.craft.work.ProgressData;
import studio.fantasyit.maid_storage_manager.data.MaidProgressData;
import studio.fantasyit.maid_storage_manager.event.RenderHandMapLikeEvent;
import studio.fantasyit.maid_storage_manager.items.ProgressPad;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.render.base.ICustomGraphics;

public class ProgressPadRender
implements RenderHandMapLikeEvent.MapLikeRenderer {
    public static final ProgressPadRender INSTANCE = new ProgressPadRender();
    private static final RenderType MAP_BACKGROUND = RenderType.m_110497_((ResourceLocation)new ResourceLocation("maid_storage_manager", "textures/gui/process_pad.png"));
    private static final ResourceLocation ELEM = new ResourceLocation("maid_storage_manager", "textures/gui/process_pad_element.png");
    private static final ImageAsset LINE = new ImageAsset(ELEM, 14, 39, 154, 2);
    private static final ImageAsset PROGRESS_ALL = new ImageAsset(ELEM, 14, 37, 154, 1);
    private static final ImageAsset PROGRESS_ALL_WAIT = new ImageAsset(ELEM, 14, 35, 154, 1);
    private static final ImageAsset PROGRESS_ALL_ERROR = new ImageAsset(ELEM, 14, 33, 154, 1);
    private static final ImageAsset BORDER = new ImageAsset(ELEM, 14, 44, 78, 41);
    private static final ImageAsset BORDER_SMALL = new ImageAsset(ELEM, 90, 44, 78, 22);
    private static final ImageAsset PROGRESS = new ImageAsset(ELEM, 15, 89, 72, 1);
    private static final ImageAsset PROGRESS_WAIT = new ImageAsset(ELEM, 15, 93, 72, 1);
    private static final ImageAsset PROGRESS_ERROR = new ImageAsset(ELEM, 15, 91, 72, 1);
    private static final int COLOR_TEXT_ITEM = -13957623;
    private static final int COLOR_TEXT_PROGRESS = -13957623;
    private static final int COLOR_TEXT_MAID = -7245312;
    private static final int COLOR_TEXT_COUNT = -1;

    @Override
    public float getWidth(RenderHandMapLikeEvent.MapLikeRenderContext context) {
        return switch (context) {
            case RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_LARGE -> 132.5f;
            case RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL -> 66.0f;
            default -> 98.0f;
        };
    }

    @Override
    public float getHeight(RenderHandMapLikeEvent.MapLikeRenderContext context) {
        return switch (context) {
            case RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL -> 65.3f;
            default -> 132.0f;
        };
    }

    @Override
    public RenderType backgroundRenderType(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, ItemStack pStack) {
        return MAP_BACKGROUND;
    }

    public ImageAsset pickProgress(ProgressData.Status status) {
        return switch (status) {
            case ProgressData.Status.WAITING -> PROGRESS_WAIT;
            case ProgressData.Status.FAILED -> PROGRESS_ERROR;
            default -> PROGRESS;
        };
    }

    public ImageAsset pickProgressAll(ProgressData.Status status) {
        return switch (status) {
            case ProgressData.Status.WAITING -> PROGRESS_ALL_WAIT;
            case ProgressData.Status.FAILED -> PROGRESS_ALL_ERROR;
            default -> PROGRESS_ALL;
        };
    }

    @Override
    public void renderOnHand(ICustomGraphics graphics, ItemStack pStack, int pCombinedLight, RenderHandMapLikeEvent.MapLikeRenderContext context) {
        int MAX_ROWS;
        int tcr = Minecraft.m_91087_().f_91074_.f_19797_ / 20;
        float widthScaleFactor = (this.getWidth(context) - 12.0f) / 78.0f;
        float maxWidth = this.getWidth(context) / 90.0f * 160.0f;
        graphics.pose().m_85841_(0.49f, 0.49f, 1.0f);
        this.blit(graphics, LINE, 14, 39, widthScaleFactor);
        UUID bindingUUID = ProgressPad.getBindingUUID(pStack);
        if (bindingUUID == null) {
            return;
        }
        ProgressData.ProgressMeta progressMeta = ProgressData.ProgressMeta.fromItemStack(pStack);
        ProgressPad.Style style = progressMeta.style();
        ProgressData data = MaidProgressData.getByMaid(progressMeta);
        if (data == null) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int maidNameWidth = font.m_92852_((FormattedText)data.maidName);
        graphics.drawString(font, data.maidName.m_7532_(), (int)(maxWidth - 2.0f - (float)maidNameWidth), 11, -13957623, false);
        if (!data.workGroups.isEmpty()) {
            Component group = data.workGroups.get(tcr % data.workGroups.size());
            int gWidth = font.m_92852_((FormattedText)group);
            graphics.drawString(font, group.m_7532_(), (int)(maxWidth - 2.0f - (float)gWidth), 25, -7245312, false);
        }
        ItemStack currentProcessingItem = !data.items.isEmpty() ? data.items.get(tcr % data.items.size()) : Items.f_42402_.m_7968_();
        graphics.pose().m_85836_();
        graphics.pose().m_252880_(10.0f, 10.0f, 0.0f);
        graphics.pose().m_85841_(1.4f, 1.4f, 1.0f);
        this.drawItemStackWithCount(graphics, currentProcessingItem, font);
        graphics.pose().m_85849_();
        if (data.total > 0) {
            if (context == RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL) {
                graphics.drawString(font, Component.m_237110_((String)"gui.maid_storage_manager.progress_pad.progress_all", (Object[])new Object[]{data.progress, data.total}).m_7532_(), 12, 45, -13957623, false);
            } else {
                graphics.drawString(font, Component.m_237110_((String)"gui.maid_storage_manager.progress_pad.progress_all", (Object[])new Object[]{data.progress, data.total}).m_7532_(), 41, 17, -13957623, false);
            }
            this.blit(graphics, this.pickProgressAll(data.status), 14, 37, widthScaleFactor * (float)data.progress / (float)data.total);
        } else if (data.working.isEmpty()) {
            graphics.drawString(font, Component.m_237115_((String)"gui.maid_storage_manager.progress_pad.no_task").m_7532_(), 12, 45, -13957623, false);
        }
        int ix = 14;
        int iy = 44;
        int row = 0;
        int COLS = switch (context) {
            case RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_LARGE -> 3;
            case RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL -> 1;
            default -> 2;
        };
        switch (context) {
            case ITEM_FRAME_SMALL: {
                int n = 1;
                break;
            }
            default: {
                int n = MAX_ROWS = 5;
            }
        }
        if (style == ProgressPad.Style.SMALL) {
            MAX_ROWS *= 2;
        }
        if (context == RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL) {
            iy += 20;
        }
        int lineHeight = switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ProgressPad.Style.NORMAL -> 39;
            case ProgressPad.Style.SMALL -> 20;
        };
        for (int i = 0; i < data.working.size(); ++i) {
            ProgressData.TaskProgress progress = data.working.get(i);
            (switch (style) {
                default -> throw new IncompatibleClassChangeError();
                case ProgressPad.Style.NORMAL -> BORDER;
                case ProgressPad.Style.SMALL -> BORDER_SMALL;
            }).blit(graphics, ix, iy);
            if (!progress.outputs().isEmpty()) {
                ItemStack display = progress.outputs().get(tcr % progress.outputs().size());
                graphics.pose().m_85836_();
                if (style == ProgressPad.Style.SMALL) {
                    graphics.pose().m_252880_((float)(ix + 2), (float)(iy + 2), 0.0f);
                } else {
                    graphics.pose().m_252880_((float)(ix + 5), (float)(iy + 5), 0.0f);
                    graphics.pose().m_85841_(1.4f, 1.4f, 1.0f);
                }
                this.drawItemStackWithCount(graphics, display, font);
                graphics.pose().m_85849_();
                int nameW = Math.min(font.m_92852_((FormattedText)display.m_41786_()), 40);
                int dNameY = switch (style) {
                    default -> throw new IncompatibleClassChangeError();
                    case ProgressPad.Style.NORMAL -> 6;
                    case ProgressPad.Style.SMALL -> 2;
                };
                this.drawCenteredString(graphics, font, display.m_41786_(), ix + 76 - 2 - nameW, iy + dNameY, 40, -13957623, false);
            }
            if (style == ProgressPad.Style.NORMAL && progress.total() != 0) {
                String progressText = String.format("%d/%d", progress.progress(), progress.total());
                int progressW = font.m_92895_(progressText);
                graphics.drawString(font, progressText, (float)(ix + 76 - 2 - progressW), (float)(iy + lineHeight - 11), -13957623, false);
            }
            if (progress.total() == 0) {
                this.blit(graphics, this.pickProgress(progress.status()), ix + 2, iy + lineHeight - 1, 1.0f);
            } else if (progress.total() != -1) {
                this.blit(graphics, this.pickProgress(progress.status()), ix + 2, iy + lineHeight - 1, 1.0f * (float)progress.progress() / (float)progress.total());
            }
            if (!progress.taker().isEmpty()) {
                Component taker = progress.taker().get(tcr % progress.taker().size());
                if (style == ProgressPad.Style.SMALL) {
                    float _scale = 0.8f;
                    float takerWidth = (float)Math.min(font.m_92852_((FormattedText)taker), 40) * _scale;
                    graphics.pose().m_85836_();
                    graphics.pose().m_252880_((float)(ix + 76 - 2) - takerWidth, (float)(iy + lineHeight) - 11.0f * _scale, 0.0f);
                    graphics.pose().m_85841_(_scale, _scale, 1.0f);
                    this.drawCenteredString(graphics, font, taker, 0, 0, 40, -7245312, false);
                    graphics.pose().m_85849_();
                } else {
                    this.drawCenteredString(graphics, font, taker, ix + 2, iy + lineHeight - 11, 40, -7245312, false);
                }
            }
            if (i % COLS != COLS - 1) {
                ix += 76;
                continue;
            }
            ix = 14;
            iy += lineHeight;
            if (++row >= MAX_ROWS) break;
        }
    }

    public void drawCenteredString(ICustomGraphics graphics, Font pFont, Component pText, int pX, int pY, int maxWidth, int pColor, boolean shadow) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        int textWidth = pFont.m_92724_(formattedcharsequence);
        int drawWidth = Math.max(textWidth, maxWidth);
        int alignWidth = Math.min(maxWidth, textWidth);
        float scale = (float)maxWidth / (float)drawWidth;
        graphics.pose().m_85836_();
        graphics.pose().m_85841_(scale, scale, scale);
        graphics.drawString(pFont, formattedcharsequence, (float)pX / scale, ((float)(pY - 3) + (14.0f - 8.0f * scale) / 2.0f) / scale, pColor, shadow);
        graphics.pose().m_85849_();
    }

    @Override
    public void extraTransform(PoseStack pPoseStack, RenderHandMapLikeEvent.MapLikeRenderContext context) {
        if (context == RenderHandMapLikeEvent.MapLikeRenderContext.BOTH_HANDS) {
            pPoseStack.m_85841_(1.1f, 1.1f, 1.0f);
            pPoseStack.m_252880_(-6.0f, 2.0f, -10.0f);
        } else if (context == RenderHandMapLikeEvent.MapLikeRenderContext.MAIN_HAND || context == RenderHandMapLikeEvent.MapLikeRenderContext.OFF_HAND) {
            pPoseStack.m_85841_(1.2f, 1.2f, 1.0f);
            pPoseStack.m_252880_(-10.0f, 0.0f, 0.0f);
        }
    }

    protected void blit(ICustomGraphics graphics, ImageAsset asset, int x, int y, float xScale) {
        graphics.pose().m_85836_();
        graphics.pose().m_252880_((float)x, (float)y, 0.0f);
        graphics.pose().m_85841_(xScale, 1.0f, 1.0f);
        asset.blit(graphics, 0, 0);
        graphics.pose().m_85849_();
    }

    protected void drawItemStackWithCount(ICustomGraphics graphics, ItemStack pStack, Font font) {
        graphics.renderItem(pStack, 0, 0);
        if (pStack.m_41613_() != 1) {
            String s = String.valueOf(pStack.m_41613_());
            int wCount = font.m_92895_(s);
            graphics.pose().m_85837_(16.0 - (double)wCount * 0.7, 12.0, 1.0);
            graphics.pose().m_85841_(0.7f, 0.7f, 1.0f);
            graphics.drawString(font, s, 0.0f, 0.0f, -1, true);
        }
    }
}

