/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.render;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import studio.fantasyit.maid_storage_manager.api.IEntityGraphicsBufferSourceGetter;

public class CraftingChatBubbleRenderer
implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;
    private final Font font;
    private final ResourceLocation bg;
    private final List<FormattedCharSequence> split;
    private final int barBackgroundColor;
    private final int barForegroundColor1;
    private final int barForegroundColor;
    private final double progress;
    private final double progress1;
    private final int width;
    private final int height;

    public CraftingChatBubbleRenderer(ResourceLocation bg, Component text, int barBackgroundColor, int barForegroundColor, int barForegroundColor1, double progress, double progress1) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.bg = bg;
        this.split = this.font.m_92923_((FormattedText)text, 240);
        this.barBackgroundColor = barBackgroundColor;
        this.barForegroundColor = barForegroundColor;
        this.barForegroundColor1 = barForegroundColor1;
        this.progress1 = Mth.m_14008_((double)progress, (double)0.0, (double)1.0);
        this.progress = Mth.m_14008_((double)progress1, (double)0.0, (double)1.0);
        int tWid = this.split.stream().map(arg_0 -> ((Font)this.font).m_92724_(arg_0)).max(Comparator.comparingInt(t -> t)).orElse(100);
        this.width = Mth.m_14045_((int)tWid, (int)100, (int)240);
        Objects.requireNonNull(this.font);
        this.height = this.split.size() * 9 + 18;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int barWidth;
        int y = 0;
        for (FormattedCharSequence sequence : this.split) {
            int distance = this.width - this.font.m_92724_(sequence);
            graphics.drawString(this.font, sequence, (float)(distance / 2), (float)y, 0, false);
            y += 9;
        }
        int margin = 1;
        int barHeight = 12;
        graphics.fill(0, y += 2, this.width, y + barHeight, this.barBackgroundColor);
        if (this.progress > 0.0) {
            barWidth = (int)((double)(this.width - 2 * margin) * this.progress);
            graphics.getPoseStack().m_85837_(0.0, 0.0, -0.01);
            graphics.fill(margin, y + margin, barWidth, y + barHeight - margin, this.barForegroundColor);
        }
        graphics.fill(0, y += barHeight, this.width, y + 6, this.barBackgroundColor);
        if (this.progress1 > 0.0) {
            barWidth = (int)((double)(this.width - 2 * margin) * this.progress1);
            graphics.getPoseStack().m_85837_(0.0, 0.0, -0.01);
            graphics.fill(margin, y + margin, barWidth, y + 6 - margin, this.barForegroundColor1);
        }
    }

    protected void fill(EntityGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        Matrix4f matrix4f = graphics.getPoseStack().m_85850_().m_252922_();
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        if (!(graphics instanceof IEntityGraphicsBufferSourceGetter)) {
            return;
        }
        IEntityGraphicsBufferSourceGetter iegbsg = (IEntityGraphicsBufferSourceGetter)graphics;
        VertexConsumer vertexconsumer = iegbsg.getBufferSource().m_6299_(RenderType.m_269058_());
        vertexconsumer.m_252986_(matrix4f, minX, minY, 0.0f).m_193479_(color).m_85969_(graphics.getPackedLight()).m_5752_();
        vertexconsumer.m_252986_(matrix4f, minX, maxY, 0.0f).m_193479_(color).m_85969_(graphics.getPackedLight()).m_5752_();
        vertexconsumer.m_252986_(matrix4f, maxX, maxY, 0.0f).m_193479_(color).m_85969_(graphics.getPackedLight()).m_5752_();
        vertexconsumer.m_252986_(matrix4f, maxX, minY, 0.0f).m_193479_(color).m_85969_(graphics.getPackedLight()).m_5752_();
    }

    public ResourceLocation getBackgroundTexture() {
        return this.bg;
    }
}

