/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class ViewedInventoryMemory
extends AbstractTargetMemory {
    public static final Codec<ViewedInventoryMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractTargetMemory.TargetData.CODEC.fieldOf("targetData").forGetter(AbstractTargetMemory::getTargetData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list(ItemCount.CODEC))).fieldOf("viewedInventory").forGetter(ViewedInventoryMemory::getViewedInventory), (App)Codec.INT.fieldOf("coolingDown").forGetter(ViewedInventoryMemory::getCoolingDown), (App)Target.CODEC.listOf().fieldOf("mark_changed").forGetter(ViewedInventoryMemory::getMarkChanged), (App)ItemStack.f_41582_.listOf().fieldOf("waitingAdd").forGetter(ViewedInventoryMemory::getWaitingAdd)).apply((Applicative)instance, ViewedInventoryMemory::new));
    public Map<String, Map<String, List<ItemCount>>> viewedInventory;
    private LinkedList<Target> markChanged;
    public int coolingDown;
    public Set<Target> lockForChange = new HashSet<Target>();
    public boolean viewing;
    private final ArrayList<ItemStack> waitingAdd;
    private int holdStamp;
    int failTime = 0;

    public ViewedInventoryMemory(AbstractTargetMemory.TargetData targetData, Map<String, Map<String, List<ItemCount>>> viewedInventory, int coolingDown, List<Target> markChanged, List<ItemStack> waitingAdd) {
        super(targetData);
        this.viewedInventory = new HashMap<String, Map<String, List<ItemCount>>>();
        for (Map.Entry<String, Map<String, List<ItemCount>>> entry : viewedInventory.entrySet()) {
            HashMap tmp = new HashMap();
            for (Map.Entry<String, List<ItemCount>> slot : entry.getValue().entrySet()) {
                tmp.put(slot.getKey(), new ArrayList(slot.getValue()));
            }
            this.viewedInventory.put(entry.getKey(), tmp);
        }
        this.coolingDown = coolingDown;
        this.markChanged = new LinkedList<Target>(markChanged);
        this.waitingAdd = new ArrayList<ItemStack>(waitingAdd);
    }

    public ViewedInventoryMemory() {
        this.viewedInventory = new HashMap<String, Map<String, List<ItemCount>>>();
        this.coolingDown = 0;
        this.markChanged = new LinkedList();
        this.waitingAdd = new ArrayList();
    }

    public int getCoolingDown() {
        return this.coolingDown;
    }

    public Map<String, Map<String, List<ItemCount>>> getViewedInventory() {
        return this.viewedInventory;
    }

    public Map<Target, List<ItemCount>> positionFlatten() {
        HashMap<Target, List<ItemCount>> result = new HashMap<Target, List<ItemCount>>();
        for (Map.Entry<String, Map<String, List<ItemCount>>> blockEntry : this.viewedInventory.entrySet()) {
            ArrayList itemCounts = new ArrayList();
            for (Map.Entry<String, List<ItemCount>> slot : blockEntry.getValue().entrySet()) {
                slot.getValue().forEach(itemCount -> {
                    boolean found = false;
                    for (int i = 0; i < itemCounts.size(); ++i) {
                        if (!ItemStack.m_150942_((ItemStack)((ItemCount)itemCounts.get(i)).getFirst(), (ItemStack)itemCount.getFirst())) continue;
                        itemCounts.set(i, new ItemCount(((ItemCount)itemCounts.get(i)).getFirst(), ((ItemCount)itemCounts.get(i)).count() + itemCount.count()));
                        found = true;
                        break;
                    }
                    if (!found) {
                        itemCounts.add(itemCount);
                    }
                });
            }
            Target pos = Target.fromStoreString(blockEntry.getKey());
            if (pos == null) continue;
            result.put(pos, itemCounts);
        }
        return result;
    }

    public List<ItemCount> getItemsAt(Target target) {
        return this.viewedInventory.getOrDefault(target.toStoreString(), Collections.emptyMap()).values().stream().flatMap(Collection::stream).toList();
    }

    public Map<String, List<ItemCount>> getItemsAtInternal(Target target) {
        return this.viewedInventory.getOrDefault(target.toStoreString(), Collections.emptyMap());
    }

    public void setItemsAtInternal(Target target, Map<String, List<ItemCount>> items) {
        HashMap itemsCopy = new HashMap();
        items.forEach((key, value) -> itemsCopy.put(key, new ArrayList(value)));
        this.viewedInventory.put(target.toStoreString(), itemsCopy);
    }

    public List<InventoryItem> flatten() {
        ArrayList<InventoryItem> result = new ArrayList<InventoryItem>();
        for (Map.Entry<String, Map<String, List<ItemCount>>> blockEntry : this.viewedInventory.entrySet()) {
            @Nullable Target pos = Target.fromStoreString(blockEntry.getKey());
            for (Map.Entry<String, List<ItemCount>> slot : blockEntry.getValue().entrySet()) {
                for (ItemCount itemCount : slot.getValue()) {
                    if (itemCount.getFirst().m_41619_()) continue;
                    boolean found = false;
                    for (int i = 0; i < result.size(); ++i) {
                        if (!ItemStack.m_150942_((ItemStack)((InventoryItem)result.get((int)i)).itemStack, (ItemStack)itemCount.getFirst())) continue;
                        ((InventoryItem)result.get(i)).addCount(pos, itemCount.getSecond());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    result.add(new InventoryItem(itemCount.item(), itemCount.count(), new ArrayList<InventoryItem.PositionCount>(List.of(new InventoryItem.PositionCount(pos, itemCount.getSecond(), false)))));
                }
            }
        }
        return result;
    }

    public void ambitiousRemoveItem(ServerLevel level, Target target, ItemStack itemStack, int count) {
        Target realTarget = this.ambitiousPos(level, target);
        this.removeItem(realTarget, itemStack, count);
    }

    public void ambitiousAddItem(ServerLevel level, Target target, ItemStack itemStack) {
        Target realTarget = this.ambitiousPos(level, target);
        this.addItem(realTarget, itemStack);
    }

    public void removeItem(Target pos, ItemStack itemStack, int count) {
        if (pos == null || itemStack == null || itemStack.m_41619_()) {
            return;
        }
        if (!this.viewedInventory.containsKey(pos.toStoreString())) {
            return;
        }
        Map<String, List<ItemCount>> map = this.viewedInventory.get(pos.toStoreString());
        String itemKey = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString();
        List list = map.getOrDefault(itemKey, new ArrayList());
        for (int i = 0; i < list.size(); ++i) {
            ItemCount itemCount = (ItemCount)list.get(i);
            if (!ItemStack.m_150942_((ItemStack)itemCount.getFirst(), (ItemStack)itemStack)) continue;
            list.set(i, new ItemCount(itemStack, itemCount.getSecond() - count));
            if (itemCount.getSecond() - count > 0) break;
            list.remove(i);
            break;
        }
        map.put(itemKey, list);
        this.viewedInventory.put(pos.toStoreString(), map);
    }

    public void addItem(Target pos, ItemStack itemStack) {
        this.addItem(pos, itemStack, itemStack.m_41613_());
    }

    public void addItem(Target pos, ItemStack itemStack, int count) {
        if (pos == null || itemStack == null || itemStack.m_41619_()) {
            return;
        }
        if (!this.viewedInventory.containsKey(pos.toStoreString())) {
            this.viewedInventory.put(pos.toStoreString(), new HashMap());
        }
        Map<String, List<ItemCount>> map = this.viewedInventory.get(pos.toStoreString());
        String itemKey = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString();
        List list = map.getOrDefault(itemKey, new ArrayList());
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            ItemCount itemCount = (ItemCount)list.get(i);
            if (!ItemStack.m_150942_((ItemStack)itemCount.getFirst(), (ItemStack)itemStack)) continue;
            list.set(i, new ItemCount(itemStack, (int)Math.min((long)itemCount.getSecond() + (long)count, 0x3FFFFFFFL)));
            found = true;
            break;
        }
        if (!found) {
            list.add(new ItemCount(itemStack.m_255036_(1), Math.min(count, 0x3FFFFFFF)));
        }
        map.put(itemKey, list);
        this.viewedInventory.put(pos.toStoreString(), map);
        if (!this.waitingAdd.isEmpty()) {
            ItemStackUtil.removeIsMatchInList(this.waitingAdd, itemStack.m_255036_(count), true);
        }
    }

    public void removeUnvisited() {
        ArrayList<String> posList = new ArrayList<String>(this.viewedInventory.keySet());
        for (String pos : posList) {
            Target storage = Target.fromStoreString(pos);
            if (storage != null && this.isVisitedPos(storage)) continue;
            this.viewedInventory.remove(pos);
        }
    }

    public void resetViewedInvForPosAsRemoved(Target pos) {
        this.viewedInventory.remove(pos.toStoreString());
    }

    public void resetViewedInvForPos(Target pos) {
        this.viewedInventory.remove(pos.toStoreString());
        this.viewedInventory.put(pos.toStoreString(), new HashMap());
    }

    public LinkedList<Target> getMarkChanged() {
        return this.markChanged;
    }

    public void addMarkChanged(Target pos) {
        if (!this.markChanged.contains(pos)) {
            this.markChanged.add(pos);
        }
    }

    public Target ambitiousPos(ServerLevel level, Target storage) {
        if (this.viewedInventory.containsKey(storage.toStoreString())) {
            return storage;
        }
        MutableObject realTarget = new MutableObject((Object)storage);
        StorageAccessUtil.checkNearByContainers((Level)level, storage.getPos(), pos -> {
            Target m = storage.sameType((BlockPos)pos, null);
            if (this.viewedInventory.containsKey(m.toStoreString())) {
                realTarget.setValue((Object)m);
            }
        });
        return (Target)realTarget.getValue();
    }

    public void removeItemFromAllTargets(ItemStack itemStack, Predicate<ItemStack> predicate) {
        for (String pos : this.viewedInventory.keySet()) {
            Map<String, List<ItemCount>> vi = this.viewedInventory.get(pos);
            for (String item : vi.keySet()) {
                vi.get(item).removeIf(itemCount -> ItemStackUtil.isSame(itemStack, itemCount.getFirst(), false) && predicate.test(itemCount.getFirst()));
            }
            HashSet<String> ks = new HashSet<String>(vi.keySet());
            for (String k : ks) {
                if (!vi.get(k).isEmpty()) continue;
                vi.remove(k);
            }
        }
        HashSet<String> ks = new HashSet<String>(this.viewedInventory.keySet());
        for (String k : ks) {
            if (!this.viewedInventory.get(k).isEmpty()) continue;
            this.viewedInventory.remove(k);
        }
    }

    public void resetMarkFailTime() {
        this.failTime = 0;
    }

    public void markFailTime() {
        if (this.markChanged.isEmpty()) {
            return;
        }
        if (this.failTime++ > 3) {
            this.markChanged.poll();
        }
    }

    public void receiveFrom(ViewedInventoryMemory memory) {
        this.resetVisitedPos();
        this.removeUnvisited();
        for (String pos : memory.viewedInventory.keySet()) {
            HashMap data = new HashMap();
            for (String item : memory.viewedInventory.get(pos).keySet()) {
                data.put(item, new ArrayList(memory.viewedInventory.get(pos).get(item)));
            }
            this.viewedInventory.put(pos, data);
        }
    }

    public void lockAmbitiousPos(ServerLevel level, Target storage) {
        this.lockForChange.clear();
        this.lockForChange.add(storage);
        StorageAccessUtil.checkNearByContainers((Level)level, storage.getPos(), pos -> {
            Target m = storage.sameType((BlockPos)pos, null);
            this.lockForChange.add(m);
        });
    }

    public void clearLock() {
        this.lockForChange.clear();
    }

    public boolean isLocked(Target target) {
        return this.lockForChange.contains(target);
    }

    public boolean isLockedAmbitious(ServerLevel level, Target target) {
        if (this.isLocked(target)) {
            return true;
        }
        MutableBoolean result = new MutableBoolean(false);
        StorageAccessUtil.checkNearByContainers((Level)level, target.getPos(), pos -> {
            Target m = target.sameType((BlockPos)pos, null);
            if (this.isLocked(m)) {
                result.setTrue();
            }
        });
        return result.booleanValue();
    }

    public boolean isViewing() {
        return this.viewing;
    }

    public void setViewing(boolean viewing) {
        this.viewing = viewing;
    }

    public List<ItemStack> getWaitingAdd() {
        return this.waitingAdd;
    }

    public void clearWaitingAdd() {
        this.waitingAdd.clear();
    }

    public void addWaitingAdd(ItemStack itemStack) {
        this.waitingAdd.add(itemStack);
    }

    public void setHoldStamp(int holdStamp) {
        this.holdStamp = holdStamp;
    }

    public boolean isHolding(int holdStamp) {
        return holdStamp < this.holdStamp;
    }

    public record ItemCount(ItemStack item, int count) {
        public static final Codec<ItemCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(ItemCount::item), (App)Codec.INT.fieldOf("count").forGetter(ItemCount::count)).apply((Applicative)instance, ItemCount::new));

        public ItemStack getFirst() {
            return this.item;
        }

        public int getSecond() {
            return this.count;
        }
    }
}

