/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;

public class MealMemory
extends AbstractTargetMemory {
    public static Codec<MealMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractTargetMemory.TargetData.CODEC.fieldOf("targetData").forGetter(AbstractTargetMemory::getTargetData)).apply((Applicative)instance, MealMemory::new));
    int coolDown = 0;
    boolean isEating = false;

    public MealMemory(AbstractTargetMemory.TargetData targetData) {
        super(targetData);
    }

    public MealMemory() {
    }

    public void setCoolDown(int coolDown) {
        this.coolDown = coolDown;
    }

    public boolean isEating() {
        return this.isEating && this.hasTarget();
    }

    public void setEating(boolean eating) {
        this.isEating = eating;
    }

    public void tick() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
    }

    public boolean shouldTakeMeal(EntityMaid maid) {
        if (this.coolDown > 0) {
            return false;
        }
        if (!StorageManagerConfigData.get(maid).allowSeekWorkMeal()) {
            return false;
        }
        String workMealTypeName = Type.WORK_MEAL.getTypeName();
        FavorabilityManager manager = maid.getFavorabilityManager();
        return !maid.m_5803_() && maid.getTask().enableEating(maid) && manager.canAdd(workMealTypeName);
    }

    public boolean isWorkMeal(EntityMaid maid, ItemStack meal) {
        List maidMeals = MaidMealManager.getMaidMeals((MaidMealType)MaidMealType.WORK_MEAL);
        for (IMaidMeal maidMeal : maidMeals) {
            if (!maidMeal.canMaidEat(maid, meal, InteractionHand.MAIN_HAND)) continue;
            return true;
        }
        return false;
    }
}

