/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.capability.CraftBlockOccupyDataProvider;
import studio.fantasyit.maid_storage_manager.craft.algo.MaidCraftPlanner;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugManager;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class CraftInitBehavior
extends Behavior<EntityMaid> {
    MaidCraftPlanner planner;
    CraftingDebugContext debugContext;

    public CraftInitBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid p_22539_) {
        if (MemoryUtil.getCurrentlyWorking(p_22539_) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(p_22539_)) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(p_22539_).isReturning()) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(p_22539_).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getCrafting(p_22539_).isGoPlacingBeforeCraft()) {
            return false;
        }
        if (RequestListItem.getItemStacksNotDone(p_22539_.m_21205_()).isEmpty()) {
            return false;
        }
        return !MemoryUtil.getCrafting(p_22539_).hasPlan();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        return !this.planner.done();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        MemoryUtil.getCrafting(maid).clearPlan();
        MemoryUtil.getCrafting(maid).resetVisitedPos();
        if (StorageManagerConfigData.get(maid).useMemorizedCraftGuide()) {
            CraftMemory crafting = MemoryUtil.getCrafting(maid);
            MemoryUtil.getViewedInventory(maid).flatten().forEach(item -> {
                CraftGuideData craftGuideData;
                if (item.itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) && (craftGuideData = CraftGuideData.fromItemStack(item.itemStack)).available()) {
                    crafting.addCraftGuide(craftGuideData);
                }
            });
        }
        this.planner = new MaidCraftPlanner(level, maid);
        CraftingDebugManager.getDebugContext(maid.m_21805_()).ifPresentOrElse(c -> {
            c.convey(this.planner);
            this.debugContext = c;
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.COMMON, "Starting craft calculator", new Object[0]);
        }, () -> {
            this.debugContext = CraftingDebugContext.Dummy.INSTANCE;
        });
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        this.planner.tick(p_22553_);
    }

    protected void stop(ServerLevel p_22548_, EntityMaid maid, long p_22550_) {
        if (!this.planner.anySuccess()) {
            RequestListItem.markAllDone(maid.m_21205_());
            MemoryUtil.getRequestProgress(maid).setTryCrafting(false);
            MemoryUtil.getRequestProgress(maid).setReturn(true);
            DebugData.sendDebug("[REQUEST_CRAFT] Failed to find recipe for any items", new Object[0]);
            ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.craft_calculated_no_result");
            MemoryUtil.getCrafting((EntityMaid)maid).calculatingProgress = 0;
            MemoryUtil.getCrafting((EntityMaid)maid).calculatingTotal = 0;
        } else {
            MemoryUtil.getCrafting(maid).setPlan(this.planner.getPlan());
            MemoryUtil.getCrafting(maid).addIgnoreTargetFromRequest(maid, p_22548_);
            ChatTexts.remove(maid);
        }
        CraftBlockOccupyDataProvider.get((Level)p_22548_).removeAllOccupiesFor(maid);
        MemoryUtil.getCrafting(maid).resetAndMarkVis(p_22548_, maid);
        MemoryUtil.clearTarget(maid);
        if (!this.debugContext.isDummy()) {
            Optional.ofNullable(maid.m_269323_()).ifPresent(o -> o.m_213846_((Component)Component.m_237113_((String)"Crafting debug done")));
            this.debugContext.stop();
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

