/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.create.GeneratorCreate;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MathUtil;

public class GeneratorCreateCrushing
extends GeneratorCreate<AbstractCrushingRecipe, RecipeType<AbstractCrushingRecipe>, RecipeWrapper, CrushingPositionState> {
    ConfigTypes.ConfigType<Integer> COUNT = new ConfigTypes.ConfigType<Integer>("count", 16, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.crushing.count"), ConfigTypes.ConfigTypeEnum.Integer);

    @Override
    @NotNull
    public ResourceLocation getType() {
        return AllRecipeTypes.CRUSHING.getId();
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)AllBlocks.CRUSHING_WHEEL_CONTROLLER.get());
    }

    @Override
    protected int getMinFullBucketCount(AbstractCrushingRecipe recipe) {
        if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41741_() == 1) {
            return super.getMinFullBucketCount(recipe);
        }
        return MathUtil.lcm(super.getMinFullBucketCount(recipe), this.COUNT.getValue());
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        super.generate(inventory, level, pos, graph, recognizedTypePositions);
        this.addRecipeForPos(level, pos, AllRecipeTypes.MILLING.getType(), graph, t -> t.m_7527_().stream().map(Ingredient::m_43908_).map(Arrays::stream).map(Stream::findFirst).noneMatch(t1 -> t1.orElse(ItemStack.f_41583_).m_41619_()));
    }

    @Override
    protected void transformSteps(AbstractCrushingRecipe recipe, List<ItemStack> items, CrushingPositionState state, List<CraftGuideStepData> step, GeneratorCreate.StepGenerateStep generateStep) {
        if (generateStep == GeneratorCreate.StepGenerateStep.OUTPUT_ITEM_SELECTIVE) {
            for (CraftGuideStepData pStep : step) {
                if (!pStep.getActionType().equals((Object)CommonTakeItemAction.TYPE)) continue;
                pStep.setAction(state.action);
                pStep.storage = Target.virtual(state.pos, null);
            }
        }
    }

    @Override
    protected CrushingPositionState getState(Level level, BlockPos pos, AbstractCrushingRecipe recipe, ICachableGeneratorGraph graph) {
        ResourceLocation action;
        BlockPos testPos = pos.m_7495_();
        if (level.m_8055_(testPos).m_60795_()) {
            while (level.m_8055_(testPos).m_60795_()) {
                testPos = testPos.m_7495_();
            }
            testPos = testPos.m_7494_();
            action = CommonPickupItemAction.TYPE;
        } else {
            testPos = pos;
            while (level.m_7702_(testPos.m_7495_()) != null && level.m_7702_(testPos.m_7495_()).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                testPos = testPos.m_7495_();
            }
            action = CommonTakeItemAction.TYPE;
        }
        return new CrushingPositionState(testPos, action);
    }

    @Override
    RecipeType<AbstractCrushingRecipe> getRecipeType() {
        return AllRecipeTypes.CRUSHING.getType();
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.crushing");
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.COUNT);
    }

    protected record CrushingPositionState(BlockPos pos, ResourceLocation action) {
    }
}

