/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.ICraftType;

public class CollectCraftEvent
extends Event
implements IModBusEvent {
    private final List<ICraftType> craftTypes;
    private final List<CraftAction> actions;
    private final List<IAutoCraftGuideGenerator> autoCraftGuideGenerators;
    private final Map<ResourceLocation, List<BiPredicate<ItemStack, ItemStack>>> itemStackPredicates;

    public CollectCraftEvent(List<ICraftType> craftTypes, List<CraftAction> actions, List<IAutoCraftGuideGenerator> autoCraftGuideGenerators, Map<ResourceLocation, List<BiPredicate<ItemStack, ItemStack>>> itemStackPredicates) {
        this.craftTypes = craftTypes;
        this.actions = actions;
        this.autoCraftGuideGenerators = autoCraftGuideGenerators;
        this.itemStackPredicates = itemStackPredicates;
    }

    public List<ICraftType> getCraftTypes() {
        return this.craftTypes;
    }

    public synchronized void addCraftType(ICraftType craftType) {
        this.craftTypes.add(craftType);
    }

    public void addAction(ResourceLocation type, CraftAction.CraftActionProvider craftActionProvider, CraftAction.CraftActionPathFindingTargetProvider craftActionPathFindingTargetProvider, double closeEnoughThreshold, boolean isCommon, int hasInput, int hasOutput, List<ActionOption<?>> options) {
        this.addAction(type, craftActionProvider, craftActionPathFindingTargetProvider, closeEnoughThreshold, isCommon, false, hasInput, hasOutput, options);
    }

    public synchronized void addAction(ResourceLocation type, CraftAction.CraftActionProvider craftActionProvider, CraftAction.CraftActionPathFindingTargetProvider craftActionPathFindingTargetProvider, double closeEnoughThreshold, boolean isCommon, long marks, int hasInput, int hasOutput, List<ActionOption<?>> options) {
        this.actions.add(new CraftAction(type, craftActionProvider, craftActionPathFindingTargetProvider, closeEnoughThreshold, isCommon, marks, hasInput, hasOutput, options));
    }

    public void addAction(ResourceLocation type, CraftAction.CraftActionProvider craftActionProvider, CraftAction.CraftActionPathFindingTargetProvider craftActionPathFindingTargetProvider, double closeEnoughThreshold, boolean isCommon, boolean noOccupy, int hasInput, int hasOutput, List<ActionOption<?>> options) {
        this.addAction(type, craftActionProvider, craftActionPathFindingTargetProvider, closeEnoughThreshold, isCommon, noOccupy ? 1L : 0L, hasInput, hasOutput, options);
    }

    public synchronized void addAutoCraftGuideGenerator(IAutoCraftGuideGenerator autoCraftGuideGenerator) {
        this.autoCraftGuideGenerators.add(autoCraftGuideGenerator);
    }

    public void addItemStackPredicate(Item type, BiPredicate<ItemStack, ItemStack> predicate) {
        this.addItemStackPredicate(BuiltInRegistries.f_257033_.m_7981_((Object)type), predicate);
    }

    public synchronized void addItemStackPredicate(ResourceLocation type, BiPredicate<ItemStack, ItemStack> predicate) {
        if (!this.itemStackPredicates.containsKey(type)) {
            this.itemStackPredicates.put(type, new ArrayList());
        }
        this.itemStackPredicates.get(type).add(predicate);
    }
}

