/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2serial.serialization.unified_processor;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.serialization.custom_handler.Handlers;
import dev.xkmc.l2serial.serialization.generic_types.GenericCodec;
import dev.xkmc.l2serial.serialization.nulldefer.NullDefer;
import dev.xkmc.l2serial.serialization.type_cache.ClassCache;
import dev.xkmc.l2serial.serialization.type_cache.FieldCache;
import dev.xkmc.l2serial.serialization.type_cache.MethodCache;
import dev.xkmc.l2serial.serialization.type_cache.TypeInfo;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedContext;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class UnifiedCodec {
    public static boolean DEBUG = false;

    public static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> Object deserializeObject(C ctx, O obj, ClassCache cls, @Nullable Object ans) throws Exception {
        if (DEBUG) {
            try {
                return UnifiedCodec.deserializeObjectImpl(ctx, obj, cls, ans);
            }
            catch (Exception e) {
                throw new Exception("Error while deserializing " + cls.cls.getName(), e);
            }
        }
        return UnifiedCodec.deserializeObjectImpl(ctx, obj, cls, ans);
    }

    public static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> O serializeObject(C ctx, O ans, ClassCache cls, @Nullable Object obj) throws Exception {
        if (DEBUG) {
            try {
                return UnifiedCodec.serializeObjectImpl(ctx, ans, cls, obj);
            }
            catch (Exception e) {
                throw new Exception("Error while serializing " + cls.cls.getName(), e);
            }
        }
        return UnifiedCodec.serializeObjectImpl(ctx, ans, cls, obj);
    }

    @Nullable
    public static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> Object deserializeValue(C ctx, @Nullable E e, TypeInfo cls, @Nullable Object ans) throws Exception {
        Optional<Either<Optional<Object>, TypeInfo>> real = ctx.fetchRealClass(e, cls);
        if (real.isPresent()) {
            Optional left = real.get().left();
            if (left.isPresent()) {
                NullDefer<?> nil;
                Object result = ((Optional)left.get()).orElse(null);
                if (result == null && (nil = NullDefer.get(cls.getAsClass())) != null) {
                    return nil.getNullDefault();
                }
                return result;
            }
            if (real.get().right().isPresent()) {
                cls = (TypeInfo)real.get().right().get();
            }
        } else {
            if (ctx.hasSpecialHandling(cls.getAsClass())) {
                return ctx.deserializeSpecial(cls.getAsClass(), e);
            }
            for (GenericCodec codec : Handlers.LIST) {
                if (!codec.predicate(cls, ans)) continue;
                return codec.deserializeValue(ctx, e, cls, ans);
            }
        }
        return UnifiedCodec.deserializeObject(ctx, ctx.castAsMap(e), cls.toCache(), ans);
    }

    public static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> E serializeValue(C ctx, TypeInfo cls, @Nullable Object obj) throws Exception {
        Optional<Pair<E, Optional<ClassCache>>> real;
        NullDefer<?> nil;
        if (obj != null && (nil = NullDefer.get(cls.getAsClass())) != null && nil.predicate(Wrappers.cast(obj))) {
            obj = null;
        }
        if ((real = ctx.writeRealClass(cls, obj)).isPresent()) {
            Object first = real.get().getFirst();
            Optional second = (Optional)real.get().getSecond();
            if (second.isEmpty()) {
                return (E)first;
            }
            O o = ctx.castAsMap((Object)first);
            return (E)UnifiedCodec.serializeObject(ctx, o, (ClassCache)second.get(), obj);
        }
        return (E)UnifiedCodec.serializeObject(ctx, ctx.createMap(), cls.toCache(), obj);
    }

    private static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> O serializeObjectImpl(C ctx, O ans, ClassCache cls, @Nullable Object obj) throws Exception {
        if (cls.getSerialAnnotation() == null) {
            throw new Exception("cannot serialize " + cls);
        }
        while (cls.getSerialAnnotation() != null) {
            TreeMap<String, FieldCache> map = new TreeMap<String, FieldCache>();
            for (FieldCache f : cls.getFields()) {
                if (f.getSerialAnnotation() == null) continue;
                map.put(f.getName(), f);
            }
            for (Map.Entry entry : map.entrySet()) {
                E content;
                FieldCache f = (FieldCache)entry.getValue();
                if (DEBUG) {
                    try {
                        content = UnifiedCodec.serializeValue(ctx, f.toType(), f.get(obj));
                    }
                    catch (Exception e) {
                        throw new Exception("Error while serializing field " + cls.cls.getName() + "." + f.getName(), e);
                    }
                } else {
                    content = UnifiedCodec.serializeValue(ctx, f.toType(), f.get(obj));
                }
                ctx.addField(ans, (String)entry.getKey(), content);
            }
            cls = cls.getSuperclass();
        }
        return ans;
    }

    private static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> Object deserializeObjectImpl(C ctx, O obj, ClassCache cls, @Nullable Object ans) throws Exception {
        if (cls.getSerialAnnotation() == null) {
            throw new Exception("invalid class " + cls + " with object " + obj);
        }
        if (ans == null) {
            ans = cls.create();
        }
        ClassCache mcls = cls;
        while (cls.getSerialAnnotation() != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (FieldCache f : cls.getFields()) {
                if (f.getSerialAnnotation() == null) continue;
                map.put(f.getName(), f);
            }
            for (Map.Entry entry : map.entrySet()) {
                FieldCache f = (FieldCache)entry.getValue();
                if (ctx.shouldRead(obj, f)) {
                    Object content;
                    Object def = f.get(ans);
                    if (DEBUG) {
                        try {
                            content = UnifiedCodec.deserializeValue(ctx, ctx.retrieve(obj, f.getName()), f.toType(), def);
                        }
                        catch (Exception e) {
                            throw new Exception("Error while deserializing field " + cls.cls.getName() + "." + f.getName(), e);
                        }
                    } else {
                        content = UnifiedCodec.deserializeValue(ctx, ctx.retrieve(obj, f.getName()), f.toType(), def);
                    }
                    f.set(ans, content);
                    continue;
                }
                NullDefer<?> nil = NullDefer.get(f.toType().getAsClass());
                if (nil == null) continue;
                f.set(ans, nil.getNullDefault());
            }
            cls = cls.getSuperclass();
        }
        cls = mcls;
        while (cls.getSerialAnnotation() != null) {
            Object m0 = null;
            for (MethodCache m : cls.getMethods()) {
                if (m.getInjectAnnotation() == null) continue;
                m0 = m;
            }
            if (m0 != null) {
                ((MethodCache)m0).invoke(ans);
                break;
            }
            cls = cls.getSuperclass();
        }
        return ans;
    }

    static <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> Optional<Wrappers.ExcSup<E>> serializeSpecial(C ctx, TypeInfo cls, Object obj) {
        if (ctx.hasSpecialHandling(cls.getAsClass())) {
            return Optional.of(() -> ctx.serializeSpecial(cls.getAsClass(), obj));
        }
        for (GenericCodec codec : Handlers.LIST) {
            if (!codec.predicate(cls, obj)) continue;
            return Optional.of(() -> codec.serializeValue(ctx, cls, obj));
        }
        return Optional.empty();
    }
}

