/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchenlegacy.task.cook;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.github.wallev.maidsoulkitchenlegacy.task.cook.LegacyMixinInfo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public enum LegacyTaskInfo {
    YHC_FERMENTITAION(TaskInfo.YHC_FERMENTATION_TANK, Mods.YHCD_LEGACY, new String[0]),
    KK_BREWING(TaskInfo.KK_BREW_BARREL, Mods.KK_LEGACY, "io.github.tt432.kitchenkarrot.blockentity.BrewingBarrelBlockEntity");

    public final ResourceLocation uid;
    public final Mods bindMod;
    public final Supplier<Boolean> configEnable;
    public final List<String> mixinList;

    private LegacyTaskInfo(ResourceLocation uid, Mods bindMod, Supplier<ForgeConfigSpec.BooleanValue> configLoad, String ... mixinList) {
        this.uid = uid;
        this.bindMod = bindMod;
        this.configEnable = () -> (Boolean)((ForgeConfigSpec.BooleanValue)configLoad.get()).get();
        this.mixinList = Lists.newArrayList((Object[])mixinList);
        for (String target : mixinList) {
            LegacyMixinInfo.putMixin(target, bindMod, uid);
        }
    }

    private LegacyTaskInfo(TaskInfo taskInfo, Mods bindMod, String ... mixinList) {
        this.uid = taskInfo.getUid();
        this.bindMod = bindMod;
        this.configEnable = () -> taskInfo.configEnabled();
        this.mixinList = Lists.newArrayList((Object[])mixinList);
        for (String target : mixinList) {
            LegacyMixinInfo.putMixin(target, bindMod, this.uid);
        }
    }

    private LegacyTaskInfo(String uid, Mods bindMod, Supplier<ForgeConfigSpec.BooleanValue> configLoad, String ... mixinList) {
        this(VResourceLocation.createMod((String)uid), bindMod, configLoad, mixinList);
    }

    public static void init() {
    }
}

