/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import studio.fantasyit.maid_storage_manager.Config;

public class ItemStackLighting {
    private static final List<Vector3f[]> shaderLightDirectionsStack = new ArrayList<Vector3f[]>();

    public static void flushAndSetup(MultiBufferSource multiBufferSource, PoseStack poseStack) {
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.m_109911_();
        }
        ItemStackLighting.setup(poseStack);
    }

    public static void setup(PoseStack poseStack) {
        Vector3f shaderLightDirections$1 = new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[0]);
        Vector3f shaderLightDirections$2 = new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[1]);
        shaderLightDirectionsStack.add(new Vector3f[]{shaderLightDirections$1, shaderLightDirections$2});
        if (Config.usingBetterLightOnItems) {
            Vector3f vec = poseStack.m_85850_().m_252922_().transformDirection(new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
            RenderSystem.setShaderLights((Vector3f)vec, (Vector3f)vec);
        }
    }

    public static void flushAndRestore(MultiBufferSource multiBufferSource) {
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.m_109911_();
        }
        ItemStackLighting.restore();
    }

    public static void restore() {
        if (shaderLightDirectionsStack.isEmpty()) {
            throw new RuntimeException("ItemStackLighting.restore() called without setup()");
        }
        Vector3f[] shaderLightDirections = shaderLightDirectionsStack.remove(shaderLightDirectionsStack.size() - 1);
        RenderSystem.setShaderLights((Vector3f)shaderLightDirections[0], (Vector3f)shaderLightDirections[1]);
    }
}

