/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.menu.container.NoPlaceFilterSlot;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class LogisticsGuideMenu
extends AbstractContainerMenu
implements ISaveFilter {
    Player player;
    ItemStack target;
    public SimpleContainer container;
    public boolean single_mode = false;
    Slot slotGuide;
    public static final int SLOT_GUIDE_OFFSET_Y = 1;
    public static final int SLOT_GUIDE_OFFSET_X = 8;
    List<Slot> playerSlots = new ArrayList<Slot>();

    public LogisticsGuideMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.LOGISTICS_GUIDE_MENU.get(), p_38852_);
        this.player = player;
        this.target = player.m_21205_();
        CompoundTag tag = this.target.m_41784_();
        this.container = new SimpleContainer(1);
        this.container.m_6836_(0, ItemStackUtil.parseStack(tag.m_128469_("item")));
        this.container.m_19164_(e -> this.save());
        this.single_mode = tag.m_128471_("single_mode");
        this.addPlayerSlots();
        this.addFilterSlots();
        this.addSpecialSlots();
    }

    @Override
    public void save() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = this.target.m_41784_();
        tag.m_128365_("item", (Tag)ItemStackUtil.saveStack(this.container.m_8020_(0)));
        tag.m_128379_("single_mode", this.single_mode);
        this.target.m_41751_(tag);
    }

    private void addFilterSlots() {
        Target output;
        this.slotGuide = this.m_38897_(new Slot((Container)this.container, 0, 40, 24));
        Target input = LogisticsGuide.getInput(this.target);
        if (input != null) {
            this.m_38897_(new NoPlaceFilterSlot(18, 78, input.getBlockStateInLevel(this.player.m_9236_()).m_60734_().m_5456_().m_7968_(), 0));
        }
        if ((output = LogisticsGuide.getOutput(this.target)) != null) {
            this.m_38897_(new NoPlaceFilterSlot(112, 78, output.getBlockStateInLevel(this.player.m_9236_()).m_60734_().m_5456_().m_7968_(), 1));
        }
    }

    private void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 118;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 118 + i * 18)));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.playerSlots.add(this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 176)));
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (this.slotGuide.f_40219_ == slotId) {
            ItemStack held = this.m_142621_();
            if (held.m_41619_() || held.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) || held.m_150930_((Item)ItemRegistry.FILTER_LIST.get())) {
                super.m_150399_(slotId, dragType, clickTypeIn, player);
            }
        } else {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private void addSpecialSlots() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return LogisticsGuideMenu.this.single_mode ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                LogisticsGuideMenu.this.single_mode = p_40208_ == 1;
                LogisticsGuideMenu.this.save();
            }
        });
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot.f_40219_ == this.slotGuide.f_40219_) {
                for (int i = 0; i < this.playerSlots.size(); ++i) {
                    if (!this.playerSlots.get(i).m_7993_().m_41619_()) continue;
                    this.playerSlots.get(i).m_5852_(slot.m_7993_());
                    slot.m_5852_(ItemStack.f_41583_);
                    this.save();
                    return ItemStack.f_41583_;
                }
            } else if ((slot.m_7993_().m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) || slot.m_7993_().m_150930_((Item)ItemRegistry.FILTER_LIST.get())) && this.slotGuide.m_7993_().m_41619_()) {
                this.slotGuide.m_5852_(slot.m_7993_());
                slot.m_5852_(ItemStack.f_41583_);
                this.save();
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.target;
    }

    public void handleUpdate(ItemSelectorGuiPacket.SlotType type, int key, int value) {
        if (Objects.requireNonNull(type) == ItemSelectorGuiPacket.SlotType.STOCKMODE) {
            this.single_mode = value == 1;
            this.save();
        }
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }
}

