/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.resort;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IFilterable;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class ResortBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    private IStorageContext context = null;
    Target target = null;
    int count = 0;

    public ResortBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.RESORT) {
            return false;
        }
        if (!MemoryUtil.getResorting(maid).hasTarget()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (Conditions.isWaitingForReturn(maid)) {
            return false;
        }
        if (Conditions.inventoryFull(maid)) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        if (!MemoryUtil.getResorting(maid).hasTarget()) {
            return;
        }
        MemoryUtil.setWorking(maid, true);
        this.target = MemoryUtil.getResorting(maid).getTarget();
        this.context = MaidStorage.getInstance().getStorage(this.target.getType()).onStartCollect(level, maid, this.target);
        if (!(this.context instanceof IFilterable)) {
            this.context = null;
        }
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.count = 0;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper maidInv = maid.getAvailableInv(false);
        Function<ItemStack, ItemStack> taker = itemStack -> {
            int maxStore;
            if (!((IFilterable)((Object)this.context)).isAvailable((ItemStack)itemStack) && (maxStore = InvUtil.maxCanPlace((IItemHandler)maidInv, itemStack)) > 0) {
                int store = Math.min(itemStack.m_41613_(), maxStore);
                ItemStack copy = itemStack.m_255036_(store);
                InvUtil.tryPlace((IItemHandler)maidInv, copy);
                ViewedInventoryUtil.ambitiousRemoveItemAndSync(maid, p_22551_, this.target, itemStack, store);
                return itemStack.m_255036_(itemStack.m_41613_() - store);
            }
            return itemStack;
        };
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(taker);
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageExtractableContext) {
                IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                if (isec.hasTask()) {
                    isec.tick(taker);
                } else {
                    List<ItemStack> filterMismatch = MemoryUtil.getResorting(maid).getNeedToResort();
                    isec.setExtract(filterMismatch, ItemStackUtil.MATCH_TYPE.MATCHING);
                }
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        MemoryUtil.setWorking(maid, false);
        if (this.context != null) {
            if (this.context.isDone()) {
                MemoryUtil.getResorting(maid).clearTarget();
            }
            MemoryUtil.getPlacingInv(maid).resetVisitedPos();
            MemoryUtil.getPlacingInv(maid).addVisitedPos(this.target);
            StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getPlacingInv(maid).addVisitedPos(this.target.sameType((BlockPos)pos, null)));
            this.context.finish();
        }
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

