/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.gather;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.base.AbstractGatherMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class RequestCraftGatherMoveBehavior
extends AbstractGatherMoveBehavior {
    CraftLayerChain plan;
    CraftLayer layer;

    public RequestCraftGatherMoveBehavior() {
        super((float)Config.collectSpeed);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isReturning()) {
            return false;
        }
        if (!Conditions.takingRequestList(owner)) {
            return false;
        }
        if (!MemoryUtil.getCrafting(owner).hasPlan()) {
            return false;
        }
        if (MemoryUtil.getCrafting(owner).isGatheringDispatched()) {
            return false;
        }
        return MemoryUtil.getCrafting(owner).plan().isCurrentGathering();
    }

    @Override
    protected AbstractTargetMemory getMemory(EntityMaid maid) {
        return MemoryUtil.getCrafting(maid);
    }

    @Override
    protected boolean hasFinishedPre(ServerLevel level, EntityMaid maid) {
        this.plan = MemoryUtil.getCrafting(maid).plan();
        this.layer = this.plan.getCurrentLayer();
        this.plan.ifChanged(() -> MemoryUtil.getCrafting(maid).resetAndMarkVis(level, maid));
        if (this.layer.hasCollectedAll()) {
            this.plan.finishGathering(maid);
            return true;
        }
        return false;
    }

    @Override
    protected void findTarget(ServerLevel level, EntityMaid maid, Target target) {
        this.plan.setStatusMessage(maid, (Component)Component.m_237115_((String)"chat_bubbles.maid_storage_manager.crafting_gathering"));
    }

    @Override
    protected void noTarget(ServerLevel level, EntityMaid maid) {
        this.plan.finishGathering(maid);
    }

    @Override
    protected boolean isTargetItem(ServerLevel level, EntityMaid maid, List<ItemStack> targets, ItemStack itemStack) {
        return targets.stream().anyMatch(i2 -> ItemStackUtil.isSameInCrafting(i2, itemStack));
    }

    @Override
    @NotNull
    protected List<ItemStack> getPriorityItems(ServerLevel level, EntityMaid maid) {
        return this.layer.getUnCollectedItems();
    }
}

