/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.dispatched;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class DispatchedGatherMoveBehavior
extends Behavior<EntityMaid> {
    public DispatchedGatherMoveBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isReturning()) {
            return false;
        }
        if (!Conditions.takingRequestList(owner)) {
            return false;
        }
        return MemoryUtil.getCrafting(owner).isGatheringDispatched();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        @Nullable UUID entityUU = RequestListItem.getStorageEntity(maid.m_21205_());
        if (entityUU == null) {
            return;
        }
        @Nullable Entity entity = level.m_8791_(entityUU);
        if (entity == null) {
            return;
        }
        MemoryUtil.setTarget(maid, entity, (float)Config.collectSpeed);
    }
}

