/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.dispatched;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.entity.VirtualItemEntity;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class DispatchedGatherBehavior
extends Behavior<EntityMaid> {
    private List<ItemStack> list;
    private List<ItemStack> originalList;
    VirtualItemEntity thrown;
    EntityMaid target;
    int index = 0;
    BehaviorBreath breath = new BehaviorBreath();

    public DispatchedGatherBehavior() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        EntityTracker et;
        PositionTracker positionTracker;
        EntityMaid targetMaid;
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isReturning()) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).isGatheringDispatched()) {
            return false;
        }
        @Nullable UUID entityUU = RequestListItem.getStorageEntity(maid.m_21205_());
        if (entityUU == null) {
            return false;
        }
        @Nullable Entity entity = level.m_8791_(entityUU);
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof EntityMaid) || MemoryUtil.isWorking(targetMaid = (EntityMaid)entity) && !MemoryUtil.isParallelWorking(targetMaid)) {
            return false;
        }
        if (entity.m_20270_((Entity)maid) < 3.0f) {
            return true;
        }
        Optional memory = maid.m_6274_().m_21952_(MemoryModuleType.f_26370_);
        if (memory.isEmpty() || !((positionTracker = ((WalkTarget)memory.get()).m_26420_()) instanceof EntityTracker) || !(et = (EntityTracker)positionTracker).m_147481_().equals((Object)entity)) {
            MemoryUtil.clearTarget(maid);
        }
        return false;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.index = 0;
        this.target = null;
        this.thrown = null;
        this.breath.reset();
        @Nullable UUID entityUU = RequestListItem.getStorageEntity(maid.m_21205_());
        if (entityUU == null) {
            return;
        }
        @Nullable Entity entity = level.m_8791_(entityUU);
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityMaid) {
            EntityMaid maid1 = (EntityMaid)entity;
            CraftMemory targetCrafting = MemoryUtil.getCrafting(maid1);
            CraftMemory currentCrafting = MemoryUtil.getCrafting(maid);
            if (targetCrafting.hasPlan() && currentCrafting.hasPlan()) {
                CraftLayerChain plan = currentCrafting.plan();
                CraftLayerChain targetPlan = targetCrafting.plan();
                if (plan.hasCurrent()) {
                    CraftLayer outLayer = plan.getCurrentLayer();
                    this.list = targetPlan.getDispatchedRemainItem(outLayer);
                    this.originalList = this.list.stream().map(ItemStack::m_41777_).toList();
                    this.target = maid1;
                    this.target.m_21573_().m_26573_();
                    MemoryUtil.joinAndStartParallelWorking(this.target);
                    MemoryUtil.setTarget(this.target, (Entity)this.target, (float)Config.collectSpeed);
                }
            }
        }
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (this.thrown != null) {
            return true;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).isGatheringDispatched()) {
            return false;
        }
        return this.target != null && this.list != null && this.index < this.list.size();
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        MemoryUtil.setLookAt(this.target, (Entity)maid);
        if (this.thrown == null) {
            ItemStack gotItem;
            ItemStack toSeekItem = this.list.get(this.index);
            if (toSeekItem.m_41613_() > toSeekItem.m_41741_()) {
                toSeekItem = toSeekItem.m_255036_(toSeekItem.m_41741_());
            }
            if (!(gotItem = InvUtil.tryExtractForCrafting((IItemHandler)this.target.getAvailableInv(false), toSeekItem)).m_41619_()) {
                Vec3 targetDir = MathUtil.getFromToWithFriction((Entity)this.target, maid.m_20318_(0.0f));
                this.thrown = InvUtil.throwItemVirtual(maid, gotItem, targetDir);
                this.list.get(this.index).m_41774_(gotItem.m_41613_());
                if (this.list.get(this.index).m_41619_()) {
                    ++this.index;
                }
            } else {
                ++this.index;
            }
            DebugData.invChange(DebugData.InvChange.OUT, this.target, gotItem);
        } else {
            DebugData.invChange(DebugData.InvChange.IN, maid, this.thrown.getItem());
            InvUtil.pickUpVirtual(maid, this.thrown);
            DebugData.invChange(DebugData.InvChange.CURRENT, maid, ItemStack.f_41583_);
            if (!this.thrown.m_6084_()) {
                this.thrown = null;
            }
            this.breath.reset();
        }
    }

    public void stop(ServerLevel level, EntityMaid maid, long gameTime) {
        MemoryUtil.getCrafting(maid).setGatheringDispatched(false);
        MemoryUtil.clearTarget(maid);
        MemoryUtil.clearTarget(this.target);
        if (MemoryUtil.getCrafting(this.target).hasPlan()) {
            MemoryUtil.getCrafting(this.target).plan().removeDispatchedItems(this.originalList);
        }
        MemoryUtil.leaveParallelWorking(this.target);
        MemoryUtil.clearPickUpItemTemp(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

