/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.logistics.output;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInsertableContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class LogisticsOutputBehavior
extends Behavior<EntityMaid> {
    private final BehaviorBreath breath = new BehaviorBreath();
    @Nullable
    IStorageContext context;
    int currentSlot = 0;
    private Target target;
    CraftLayer layer = null;

    public LogisticsOutputBehavior() {
        super(Map.of());
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (!MemoryUtil.getLogistics(maid).shouldWork()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.OUTPUT) {
            return false;
        }
        if (this.layer == null || this.layer.hasCollectedAll()) {
            return false;
        }
        if (this.currentSlot >= maid.getAvailableInv(false).getSlots()) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getCurrentLogisticsGuideItem().m_41619_()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.OUTPUT) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        if (MemoryUtil.getLogistics(maid).hasTarget()) {
            this.target = MemoryUtil.getLogistics(maid).getTarget();
            this.context = Objects.requireNonNull(MaidStorage.getInstance().getStorage(this.target.getType())).onStartPlace(level, maid, this.target);
            if (this.context != null) {
                this.context.start(maid, level, this.target);
            }
            this.layer = MemoryUtil.getLogistics(maid).getResultLayer();
        }
        this.currentSlot = 0;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < 5 && this.currentSlot < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(this.currentSlot).m_41619_()) continue;
            ++this.currentSlot;
        }
        if (this.currentSlot < availableInv.getSlots()) {
            IStorageContext iStorageContext;
            ItemStack stack = availableInv.getStackInSlot(this.currentSlot);
            if (!stack.m_41619_() && (iStorageContext = this.context) instanceof IStorageInsertableContext) {
                IStorageInsertableContext isic = (IStorageInsertableContext)iStorageContext;
                int toInsert = this.layer.memorizeItemSimulate(stack);
                ItemStack notInserted = isic.insert(stack.m_255036_(toInsert));
                this.layer.memorizeItem(stack.m_255036_(toInsert - notInserted.m_41613_()), Integer.MAX_VALUE);
                int restCount = stack.m_41613_() - toInsert + notInserted.m_41613_();
                availableInv.setStackInSlot(this.currentSlot, stack.m_255036_(restCount));
            }
            ++this.currentSlot;
        }
        if (!(this.context == null || this.currentSlot < availableInv.getSlots() && !this.context.isDone() || InvUtil.isEmpty(availableInv) || MemoryUtil.getLogistics(maid).hasMultipleGuide(maid))) {
            if (this.currentSlot >= availableInv.getSlots()) {
                this.currentSlot = 0;
            }
            if (this.context.isDone()) {
                this.context.reset();
            }
        }
    }

    protected void stop(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22550_) {
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.context != null) {
            this.context.finish();
        }
        if (Conditions.isNothingToPlace(maid)) {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.FINISH);
        } else {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.RECYCLE);
        }
        MemoryUtil.getLogistics(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

