/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.vanilla;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public class GeneratorWatering
implements IAutoCraftGuideGenerator {
    ConfigTypes.ConfigType<Boolean> BUCKET = new ConfigTypes.ConfigType<Boolean>("bucket", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.watering.bucket"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> BOTTLE = new ConfigTypes.ConfigType<Boolean>("bottle", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.watering.bottle"), ConfigTypes.ConfigTypeEnum.Boolean);

    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("maid_storage_manager", "watering");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        MutableInt count = new MutableInt(0);
        PosUtil.findAround(pos, t -> {
            if (level.m_8055_(t).m_60713_(Blocks.f_49990_)) {
                count.increment();
            }
            return null;
        });
        return count.intValue() >= 3;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        if (this.BOTTLE.getValue().booleanValue()) {
            graph.addRecipe(new ResourceLocation("maid_storage_manager", "watering_bottle"), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_})), List.of(Integer.valueOf(1)), List.of(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)), items -> {
                CraftGuideStepData step = new CraftGuideStepData(Target.virtual(pos, null), (List<ItemStack>)items, List.of(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)), CommonUseAction.TYPE);
                return new CraftGuideData(List.of(step), CommonType.TYPE);
            });
        }
        if (this.BUCKET.getValue().booleanValue()) {
            graph.addRecipe(new ResourceLocation("maid_storage_manager", "watering_bucket"), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_})), List.of(Integer.valueOf(1)), List.of(new ItemStack((ItemLike)Items.f_42447_)), items -> {
                CraftGuideStepData step = new CraftGuideStepData(Target.virtual(pos, null), (List<ItemStack>)items, List.of(new ItemStack((ItemLike)Items.f_42447_)), CommonUseAction.TYPE);
                return new CraftGuideData(List.of(step), CommonType.TYPE);
            });
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        RecipeIngredientCache.addRecipeCache(new ResourceLocation("maid_storage_manager", "watering_bottle"), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_})));
        RecipeIngredientCache.addRecipeCache(new ResourceLocation("maid_storage_manager", "watering_bucket"), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_})));
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.water");
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.BUCKET, this.BOTTLE);
    }
}

