/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.algo.base.CraftResultNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.ICraftGraphLike;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class TopologyCraftGraph
implements ICraftGraphLike {
    private int taskPerTick = 32;
    List<ItemStack> items;
    List<Integer> counts;
    List<CraftGuideData> craftGuideData;
    List<List<Pair<Integer, Integer>>> edges;
    List<Integer> inDegree = new ArrayList<Integer>();
    List<boolean[]> disableOutputEdge = new ArrayList<boolean[]>();
    Queue<CraftResultNode> queue = new LinkedList<CraftResultNode>();
    List<Integer> totalRequire;
    List<Integer> currentRequire;
    List<Boolean> isRelated;
    Stack<CraftResultNode> results;
    Set<Integer> checkNodes;
    int buildIdx = 0;
    int contextItemIdx = 0;
    int contextRequireCount;

    private int item(int i) {
        return i + this.craftGuideData.size();
    }

    private int craft(int i) {
        return i;
    }

    private int getItemIndex(ItemStack itemStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!ItemStackUtil.isSameInCrafting(this.items.get(i), itemStack)) continue;
            return i;
        }
        return -1;
    }

    public TopologyCraftGraph(List<Pair<ItemStack, Integer>> items, List<CraftGuideData> craftGuideData) {
        int i;
        this.items = new ArrayList<ItemStack>();
        this.counts = new ArrayList<Integer>();
        this.craftGuideData = new ArrayList<CraftGuideData>();
        ArrayList<ItemStack> existingFirstOutput = new ArrayList<ItemStack>();
        for (CraftGuideData inComing : craftGuideData) {
            boolean duplicate = false;
            List<ItemStack> inComingOpt = inComing.getAllOutputItems();
            for (CraftGuideData existing : this.craftGuideData) {
                List<ItemStack> existingOpt = existing.getAllOutputItems();
                if (!ItemStackUtil.isSameInCrafting(existingOpt.get(0), inComingOpt.get(0)) || inComingOpt.get(0).m_41619_()) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            this.craftGuideData.add(inComing);
            existingFirstOutput.add(inComingOpt.get(0));
            this.disableOutputEdge.add(new boolean[inComingOpt.size()]);
        }
        for (i = 0; i < this.craftGuideData.size(); ++i) {
            List<ItemStack> outputs = this.craftGuideData.get(i).getAllOutputItems();
            for (int j = 1; j < outputs.size(); ++j) {
                ItemStack i2 = outputs.get(j);
                if (!existingFirstOutput.stream().anyMatch(i1 -> ItemStackUtil.isSameInCrafting(i1, i2))) continue;
                this.disableOutputEdge.get((int)i)[j] = true;
            }
        }
        this.edges = new ArrayList<List<Pair<Integer, Integer>>>();
        this.totalRequire = new ArrayList<Integer>();
        this.currentRequire = new ArrayList<Integer>();
        this.isRelated = new ArrayList<Boolean>();
        for (i = 0; i < craftGuideData.size(); ++i) {
            this.edges.add(new ArrayList());
            this.counts.add(0);
            this.inDegree.add(0);
            this.totalRequire.add(0);
        }
        for (Pair<ItemStack, Integer> itemStackIntegerPair : items) {
            ItemStack itemStack = (ItemStack)itemStackIntegerPair.getA();
            if (itemStack.m_41619_()) continue;
            this.counts.set(this.item(this.addItemNode(itemStack.m_255036_(1))), (Integer)itemStackIntegerPair.getB());
        }
        this.buildIdx = craftGuideData.size();
        this.contextItemIdx = -1;
        this.contextRequireCount = 0;
    }

    @Override
    public void setSpeed(int taskPerTick) {
        this.taskPerTick = taskPerTick;
    }

    @Override
    public void setItemCount(ItemStack itemStack, int count) {
        int idx = this.getItemIndex(itemStack);
        if (idx == -1) {
            idx = this.addItemNode(itemStack);
        }
        this.counts.set(this.item(idx), count);
    }

    @Override
    public void addItemCount(ItemStack itemStack, int count) {
        int idx = this.getItemIndex(itemStack);
        if (idx == -1) {
            idx = this.addItemNode(itemStack);
        }
        if (this.totalRequire.get(this.item(idx)) > this.counts.get(this.item(idx))) {
            this.counts.set(this.item(idx), this.totalRequire.get(this.item(idx)));
        }
        this.counts.set(this.item(idx), this.counts.get(this.item(idx)) + count);
    }

    public void addEdge(int from, int to, int count) {
        this.edges.get(from).add((Pair<Integer, Integer>)new Pair((Object)to, (Object)count));
        this.inDegree.set(to, this.inDegree.get(to) + 1);
    }

    protected int addItemNode(ItemStack itemStack) {
        this.items.add(itemStack);
        this.edges.add(new ArrayList());
        this.counts.add(0);
        this.inDegree.add(0);
        this.isRelated.add(false);
        this.totalRequire.add(0);
        this.currentRequire.add(0);
        return this.items.size() - 1;
    }

    @Override
    public boolean buildGraph() {
        int count = 0;
        while (this.buildIdx < this.craftGuideData.size()) {
            if (count++ > this.taskPerTick) {
                return false;
            }
            CraftGuideData cgd = this.craftGuideData.get(this.buildIdx);
            List<ItemStack> items1 = cgd.getAllInputItems();
            for (int j = 0; j < items1.size(); ++j) {
                ItemStack item = items1.get(j);
                if (item.m_41619_()) continue;
                int idx = this.getItemIndex(item);
                if (idx == -1) {
                    idx = this.addItemNode(item);
                }
                this.addEdge(this.craft(this.buildIdx), this.item(idx), item.m_41613_());
            }
            List<ItemStack> items2 = cgd.getAllOutputItems();
            for (int j = 0; j < items2.size(); ++j) {
                ItemStack item;
                if (this.disableOutputEdge.get(this.buildIdx)[j] || (item = items2.get(j)).m_41619_()) continue;
                int idx = this.getItemIndex(item);
                if (idx == -1) {
                    idx = this.addItemNode(item);
                }
                this.addEdge(this.item(idx), this.craft(this.buildIdx), item.m_41613_());
            }
            ++this.buildIdx;
        }
        if (this.contextItemIdx != -1) {
            this.addRequire(this.item(this.contextItemIdx), this.contextRequireCount);
            this.isRelated.set(this.item(this.contextItemIdx), true);
            this.queue.add(new CraftResultNode(this.item(this.contextItemIdx), this.contextRequireCount, true));
            for (int i = 0; i < this.inDegree.size(); ++i) {
                if (i == this.item(this.contextItemIdx) || this.inDegree.get(i) != 0) continue;
                this.queue.add(new CraftResultNode(i, this.counts.get(i), false));
            }
            this.contextItemIdx = -1;
        }
        return true;
    }

    @Override
    public void restoreCurrent() {
        for (int i = 0; i < this.currentRequire.size(); ++i) {
            this.totalRequire.set(i, this.totalRequire.get(i) - this.currentRequire.get(i));
        }
    }

    @Override
    public void restoreCurrentAndStartContext(ItemStack item, int count) {
        this.restoreCurrent();
        this.startContext(item, count);
    }

    @Override
    public void startContext(ItemStack item, int count) {
        int idx = this.getItemIndex(item);
        if (idx == -1) {
            idx = this.addItemNode(item);
        }
        this.checkNodes = new HashSet<Integer>();
        this.checkNodes.add(this.item(idx));
        this.results = new Stack();
        this.buildIdx = 0;
        this.contextItemIdx = idx;
        this.contextRequireCount = count;
        this.isRelated = new ArrayList<Boolean>();
        this.currentRequire = new ArrayList<Integer>();
        this.inDegree = new ArrayList<Integer>();
        for (int i = 0; i < this.counts.size(); ++i) {
            this.inDegree.add(0);
            this.isRelated.add(false);
            this.currentRequire.add(0);
            this.edges.get(i).clear();
        }
    }

    private void addRequire(int i, int count) {
        if (!this.isItem(i)) {
            this.currentRequire.set(i, Math.max(this.currentRequire.get(i), count));
            this.totalRequire.set(i, Math.max(this.totalRequire.get(i), count));
        } else {
            this.currentRequire.set(i, this.currentRequire.get(i) + count);
            this.totalRequire.set(i, this.totalRequire.get(i) + count);
        }
    }

    @Override
    public boolean processQueues() {
        int dropCount = 0;
        while (!this.queue.isEmpty()) {
            if (dropCount++ > 32) {
                return false;
            }
            CraftResultNode pair = this.queue.poll();
            if (pair.related && !this.isItem(pair.index) && this.currentRequire.get(pair.index) > 0) {
                this.results.push(pair);
            }
            int lastRest = Math.max(0, this.counts.get(pair.index) - (this.totalRequire.get(pair.index) - this.currentRequire.get(pair.index)));
            int needCount = Math.max(0, this.currentRequire.get(pair.index) - lastRest);
            boolean isCurrentChecking = this.checkNodes.contains(pair.index);
            if (!this.edges.get(pair.index).isEmpty()) {
                this.checkNodes.remove(pair.index);
            }
            for (Pair<Integer, Integer> edge : this.edges.get(pair.index)) {
                int to = (Integer)edge.getA();
                int count2 = (Integer)edge.getB();
                if (isCurrentChecking) {
                    this.checkNodes.add(to);
                }
                this.isRelated.set(to, this.isRelated.get(to) != false || pair.related);
                this.inDegree.set(to, this.inDegree.get(to) - 1);
                if (this.isItem(to)) {
                    this.addRequire(to, needCount * count2);
                } else {
                    this.addRequire(to, (needCount + count2 - 1) / count2);
                }
                if (this.inDegree.get(to) != 0) continue;
                this.queue.add(new CraftResultNode(to, this.currentRequire.get(to), this.isRelated.get(to)));
            }
        }
        return true;
    }

    private boolean isItem(int to) {
        return to >= this.craftGuideData.size();
    }

    private ItemStack getItem(int to) {
        return this.items.get(to - this.craftGuideData.size());
    }

    @Override
    public List<CraftLayer> getResults() {
        if (this.checkNodes.stream().anyMatch(index -> !this.isItem((int)index) || this.counts.get((int)index) < this.totalRequire.get((int)index))) {
            return null;
        }
        ArrayList<CraftLayer> res = new ArrayList<CraftLayer>();
        CraftGuideData lastOne = null;
        int lastOneIndex = 0;
        while (!this.results.isEmpty()) {
            CraftResultNode resultNode = this.results.pop();
            if (this.isItem(resultNode.index)) continue;
            lastOne = this.craftGuideData.get(resultNode.index);
            lastOneIndex = resultNode.index;
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            Consumer<ItemStack> addWithCountMultiple = itemStack -> {
                if (itemStack.m_41619_()) {
                    return;
                }
                int count = resultNode.count * itemStack.m_41613_();
                for (ItemStack existing : itemStacks) {
                    if (!ItemStackUtil.isSameInCrafting(existing, itemStack)) continue;
                    existing.m_41769_(count);
                    return;
                }
                itemStacks.add(itemStack.m_255036_(count));
            };
            lastOne.getAllInputItemsWithOptional().forEach(addWithCountMultiple);
            res.add(new CraftLayer(Optional.of(lastOne), itemStacks, resultNode.count));
        }
        if (lastOne != null) {
            int finalLastOneIndex = lastOneIndex;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            lastOne.getAllOutputItems().stream().map(itemStack -> itemStack.m_255036_(this.currentRequire.get(finalLastOneIndex) * itemStack.m_41613_())).forEach(list::add);
            res.add(new CraftLayer(Optional.empty(), list, this.contextRequireCount));
        }
        return res;
    }

    @Override
    public List<Pair<ItemStack, Integer>> getFails() {
        return this.checkNodes.stream().filter(index -> this.counts.get((int)index) < this.totalRequire.get((int)index) && this.isItem((int)index)).map(idx -> new Pair((Object)this.getItem((int)idx), (Object)(this.totalRequire.get((int)idx) - this.counts.get((int)idx)))).toList();
    }

    @Override
    public boolean shouldStartUsingSingleItemProcess() {
        return this.results.stream().filter(l -> !this.isItem(l.index)).map(l -> this.craftGuideData.get(l.index)).anyMatch(cgd -> cgd != null && cgd.isCircular());
    }

    @Override
    public ICraftGraphLike createGraphWithItem(ICraftGraphLike.CraftAlgorithmInit<?> init) {
        ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
        for (int i = 0; i < this.items.size(); ++i) {
            int c = this.counts.get(this.item(i)) - this.totalRequire.get(this.item(i));
            items.add((Pair<ItemStack, Integer>)new Pair((Object)this.items.get(i), (Object)c));
        }
        return init.init(items, this.craftGuideData);
    }

    @Override
    public void addRemainItem(ItemStack item, int count) {
        this.addItemCount(item, count);
    }
}

