/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.compat.patchouli.entry.TaskBookEntryType;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMccMixinInterface;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IMaidsoulKitchenTask
extends IMaidTask {
    public static void putTask(ResourceLocation uid, Supplier<Boolean> canAdd, Supplier<IMaidsoulKitchenTask> task) {
        TaskInfoMap.TASK.put(uid, new TaskInfoMap(canAdd, task));
    }

    public static Map<ResourceLocation, TaskInfoMap> getTasks() {
        return TaskInfoMap.TASK;
    }

    default public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.OTHER;
    }

    default public String getBookEntry() {
        return this.getBookEntryType().name;
    }

    default public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        return this.vCreateBrainTasks(maid);
    }

    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid var1);

    default public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        List<Pair<Integer, BehaviorControl<? super EntityMaid>>> rideBrainTasks = this.vCreateRideBrainTasks(maid);
        if (!rideBrainTasks.isEmpty()) {
            return rideBrainTasks;
        }
        return super.createRideBrainTasks(maid);
    }

    default public List<Pair<Integer, VBehaviorControl>> vCreateRideBrainTasks(EntityMaid entityMaid) {
        return Collections.emptyList();
    }

    default public IItemHandlerModifiable getInventory(EntityMaid maid) {
        return maid.getAvailableInv(true);
    }

    public static class TaskInfoMap {
        private static final Map<ResourceLocation, TaskInfoMap> TASK = new LinkedHashMap<ResourceLocation, TaskInfoMap>();
        private final Supplier<Boolean> contidion;
        private final Supplier<IMaidsoulKitchenTask> task;

        public TaskInfoMap(Supplier<Boolean> contidion, Supplier<IMaidsoulKitchenTask> task) {
            this.contidion = contidion;
            this.task = task;
        }

        public Supplier<Boolean> getContidion() {
            return this.contidion;
        }

        public Supplier<IMaidsoulKitchenTask> getTask() {
            return this.task;
        }
    }

    public static class TaskMixinMap
    extends HashMap<ResourceLocation, List<String>> {
        private static final TaskMixinMap MIXIN = new TaskMixinMap();

        public static void putList(ResourceLocation task, String ... clz) {
            MIXIN.put(task, Lists.newArrayList((Object[])clz));
        }

        public static void putList(ResourceLocation task, List<String> clz) {
            MIXIN.put(task, clz);
        }

        public static boolean isApplyMixin(ResourceLocation task) {
            boolean apply = true;
            for (String targetClass : MIXIN.getOrDefault(task, List.of())) {
                if (IMccMixinInterface.applyInterfaceMixin(targetClass)) continue;
                MaidsoulKitchen.LOGGER.error("MixinError: task: {}, class: {}", (Object)task, (Object)targetClass);
                apply = false;
            }
            return apply;
        }
    }
}

