/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.item;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemInventory {
    public static final Codec<ItemInventory> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ItemCount.CODEC.listOf().fieldOf("itemsList").forGetter(o -> o.itemsList), (App)ItemDefCount.CODEC.listOf().fieldOf("stacksList").forGetter(o -> o.stacksList), (App)ItemStack.f_41582_.listOf().listOf().fieldOf("itemsMapList").forGetter(o -> o.itemsMapList), (App)ItemStack.f_41582_.listOf().listOf().fieldOf("stacksMapList").forGetter(o -> o.stacksMapList), (App)Codec.BOOL.fieldOf("dirty").forGetter(o -> o.dirty)).apply((Applicative)ins, ItemInventory::new));
    private final Map<Item, Long> items;
    private final Map<ItemDefinition, Long> stacks;
    private final Map<Item, LinkedList<ItemStack>> itemsMap;
    private final Map<ItemDefinition, LinkedList<ItemStack>> stacksMap;
    private boolean dirty = false;
    private final List<ItemCount> itemsList;
    private final List<ItemDefCount> stacksList;
    private final List<List<ItemStack>> itemsMapList;
    private final List<List<ItemStack>> stacksMapList;

    private ItemInventory(List<ItemCount> itemsList, List<ItemDefCount> stacksList, List<List<ItemStack>> itemsMapList, List<List<ItemStack>> stacksMapList, boolean dirty) {
        this.itemsList = itemsList;
        this.stacksList = stacksList;
        this.itemsMapList = itemsMapList;
        this.stacksMapList = stacksMapList;
        this.dirty = dirty;
        this.items = new HashMap<Item, Long>();
        itemsList.forEach(itemCount -> this.items.put(itemCount.item(), itemCount.count()));
        this.stacks = new HashMap<ItemDefinition, Long>();
        stacksList.forEach(itemDefCount -> this.stacks.put(itemDefCount.itemDefinition(), itemDefCount.count()));
        this.itemsMap = new HashMap<Item, LinkedList<ItemStack>>();
        itemsMapList.forEach(itemStacks -> {
            Item item = ((ItemStack)itemStacks.get(0)).m_41720_();
            this.itemsMap.put(item, new LinkedList(itemStacks));
        });
        this.stacksMap = new HashMap<ItemDefinition, LinkedList<ItemStack>>();
        stacksMapList.forEach(itemStacks -> {
            ItemDefinition itemDefinition = ItemDefinition.of((ItemStack)itemStacks.get(0));
            this.stacksMap.put(itemDefinition, new LinkedList(itemStacks));
        });
    }

    public ItemInventory() {
        this.items = new HashMap<Item, Long>();
        this.stacks = new HashMap<ItemDefinition, Long>();
        this.itemsMap = new HashMap<Item, LinkedList<ItemStack>>();
        this.stacksMap = new HashMap<ItemDefinition, LinkedList<ItemStack>>();
        this.itemsList = new LinkedList<ItemCount>();
        this.stacksList = new LinkedList<ItemDefCount>();
        this.itemsMapList = new LinkedList<List<ItemStack>>();
        this.stacksMapList = new LinkedList<List<ItemStack>>();
        this.dirty = false;
    }

    public void add(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        long count = stack.m_41613_();
        ItemDefinition itemDefinition = ItemDefinition.of(stack);
        this.items.merge(item, count, Long::sum);
        this.stacks.merge(itemDefinition, count, Long::sum);
        this.itemsMap.computeIfAbsent(item, k -> new LinkedList()).add(stack);
        this.stacksMap.computeIfAbsent(itemDefinition, k -> new LinkedList()).add(stack);
        this.addItemStack2ItemsList(stack);
        this.addItemStack2StacksList(stack);
        this.addItemStack2ItemsMapList(stack);
        this.addItemStack2StacksMapList(stack);
    }

    private void addItemStack2ItemsList(ItemStack stack) {
        for (ItemCount itemCount : this.itemsList) {
            Item item = itemCount.item();
            if (item != stack.m_41720_()) continue;
            itemCount.addCount(stack.m_41613_());
            return;
        }
        this.itemsList.add(new ItemCount(stack.m_41720_(), stack.m_41613_()));
    }

    private void addItemStack2StacksList(ItemStack stack) {
        for (ItemDefCount itemDefCount : this.stacksList) {
            ItemDefinition itemDefinition = itemDefCount.itemDefinition();
            if (!itemDefinition.equals(ItemDefinition.of(stack))) continue;
            itemDefCount.addCount(stack.m_41613_());
            return;
        }
        this.stacksList.add(new ItemDefCount(ItemDefinition.of(stack), stack.m_41613_()));
    }

    private void addItemStack2ItemsMapList(ItemStack stack) {
        for (List<ItemStack> itemStacks : this.itemsMapList) {
            Item item = itemStacks.get(0).m_41720_();
            if (item != stack.m_41720_()) continue;
            itemStacks.add(stack);
            return;
        }
        LinkedList<ItemStack> itemStacks = new LinkedList<ItemStack>();
        itemStacks.add(stack);
        this.itemsMapList.add(itemStacks);
    }

    private void addItemStack2StacksMapList(ItemStack stack) {
        for (List<ItemStack> itemStacks : this.stacksMapList) {
            ItemDefinition itemDefinition = ItemDefinition.of(itemStacks.get(0));
            if (!itemDefinition.equals(ItemDefinition.of(stack))) continue;
            itemStacks.add(stack);
            return;
        }
        LinkedList<ItemStack> itemStacks = new LinkedList<ItemStack>();
        itemStacks.add(stack);
        this.stacksMapList.add(itemStacks);
    }

    public void update() {
        if (this.dirty) {
            boolean b = false;
            this.stacksMap.values().forEach(list -> {
                ItemStack itemStack2;
                IntArrayList removeList = new IntArrayList();
                int i = 0;
                for (ItemStack itemStack2 : list) {
                    if (itemStack2 == null || itemStack2.m_41619_()) {
                        removeList.add(i);
                    }
                    ++i;
                }
                int lastRemoveIndex = 0;
                itemStack2 = removeList.iterator();
                while (itemStack2.hasNext()) {
                    int j = (Integer)itemStack2.next();
                    list.remove(j - lastRemoveIndex++);
                }
                boolean a = true;
            });
            boolean a = true;
            this.itemsMap.values().forEach(list -> {
                ItemStack itemStack2;
                IntArrayList removeList = new IntArrayList();
                int i = 0;
                for (ItemStack itemStack2 : list) {
                    if (itemStack2 == null || itemStack2.m_41619_()) {
                        removeList.add(i);
                    }
                    ++i;
                }
                int lastRemoveIndex = 0;
                itemStack2 = removeList.iterator();
                while (itemStack2.hasNext()) {
                    int j = (Integer)itemStack2.next();
                    list.remove(j - lastRemoveIndex++);
                }
                boolean c = true;
            });
            this.dirty = false;
        }
    }

    public long getItemCount(Item item) {
        return this.items.get(item);
    }

    public long getItemCount(ItemStack itemStack) {
        return this.stacks.get(ItemDefinition.of(itemStack));
    }

    public LinkedList<ItemStack> getItemStacks(Item item) {
        return this.itemsMap.get(item);
    }

    public LinkedList<ItemStack> getItemStacks(ItemDefinition definition) {
        return this.stacksMap.get(definition);
    }

    public LinkedList<ItemStack> getItemStacks(ItemStack itemStack) {
        return this.getItemStacks(itemStack.m_41720_());
    }

    public LinkedList<ItemStack> getItemStacksWithNbt(ItemStack itemStack) {
        return this.getItemStacks(ItemDefinition.of(itemStack));
    }

    public Map<Item, Long> getItems() {
        return this.items;
    }

    public Map<ItemDefinition, Long> getStacks() {
        return this.stacks;
    }

    public Map<Item, LinkedList<ItemStack>> getItemsMap() {
        return this.itemsMap;
    }

    public Map<ItemDefinition, LinkedList<ItemStack>> getStacksMap() {
        return this.stacksMap;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clear() {
        this.dirty = false;
        this.items.clear();
        this.stacks.clear();
        this.itemsMap.clear();
        this.stacksMap.clear();
    }

    private static class ItemCount {
        public static final Codec<ItemCount> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(o -> o.item), (App)Codec.LONG.fieldOf("count").forGetter(o -> o.count)).apply((Applicative)ins, ItemCount::new));
        private Item item;
        private long count;

        public ItemCount(Item item, long count) {
            this.item = item;
            this.count = count;
        }

        public Item getItem() {
            return this.item;
        }

        public void setItem(Item item) {
            this.item = item;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void addCount(long count) {
            this.count += count;
        }

        public Item item() {
            return this.item;
        }

        public long count() {
            return this.count;
        }
    }

    private static class ItemDefCount {
        public static final Codec<ItemDefCount> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ItemDefinition.CODEC.fieldOf("itemDefinition").forGetter(o -> o.itemDefinition), (App)Codec.LONG.fieldOf("count").forGetter(o -> o.count)).apply((Applicative)ins, ItemDefCount::new));
        private ItemDefinition itemDefinition;
        private long count;

        public ItemDefCount(ItemDefinition itemDefinition, long count) {
            this.itemDefinition = itemDefinition;
            this.count = count;
        }

        public ItemDefinition getItemDefinition() {
            return this.itemDefinition;
        }

        public void setItemDefinition(ItemDefinition itemDefinition) {
            this.itemDefinition = itemDefinition;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void addCount(long count) {
            this.count += count;
        }

        public ItemDefinition itemDefinition() {
            return this.itemDefinition;
        }

        public long count() {
            return this.count;
        }
    }
}

