/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.TaskCook;
import com.github.wallev.maidsoulkitchen.util.MaidUtil;
import com.github.wallev.maidsoulkitchen.util.TileUtil;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.Nullable;

public class PlaceFoodForPicnicWithRideIdleTask
extends MaidCheckRateTask {
    public static final int MAX_CHECK_RATE = 300;
    @Nullable
    private EntitySit sitTmp;

    public PlaceFoodForPicnicWithRideIdleTask() {
        super((Map)ImmutableMap.of());
        this.setMaxCheckRate(300);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!super.checkExtraStartConditions(worldIn, maid)) {
            return false;
        }
        Entity entity = maid.m_20202_();
        if (entity instanceof EntitySit) {
            EntitySit sit = (EntitySit)entity;
            if (maid.getTask() instanceof TaskCook) {
                this.sitTmp = sit;
                return true;
            }
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        RangedWrapper outputHandler;
        if (this.sitTmp == null) {
            return;
        }
        BlockPos onPos = this.sitTmp.getAssociatedBlockPos();
        BlockEntity blockEntity = worldIn.m_7702_(onPos);
        if (!(blockEntity instanceof TileEntityPicnicMat)) {
            return;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
        ItemStackHandler picnicMatHandler = picnicMat.getHandler();
        if (this.picnicMatHasFood(picnicMatHandler)) {
            return;
        }
        ItemStack hudItem = ItemCulinaryHub.getItem(maid);
        Map<BagType, ItemStackHandler> handlers = null;
        if (hudItem.m_41619_()) {
            outputHandler = maid.getAvailableBackpackInv();
        } else {
            handlers = ItemCulinaryHub.getContainers(hudItem);
            if (handlers.isEmpty()) {
                return;
            }
            outputHandler = (IItemHandlerModifiable)handlers.get((Object)BagType.OUTPUT);
        }
        if (outputHandler != null && this.placeFood((IItemHandlerModifiable)outputHandler, (IItemHandlerModifiable)picnicMatHandler)) {
            if (handlers != null) {
                ItemCulinaryHub.setContainer(hudItem, handlers);
            }
            MaidUtil.pickupAction(maid);
            TileUtil.makeChanged((BlockEntity)picnicMat);
            return;
        }
        List<BlockPos> validOutputPoses = ItemCulinaryHub.getValidOutputPoses(hudItem, maid);
        if (validOutputPoses.isEmpty()) {
            return;
        }
        List<Integer> aviSlots = this.collectPicnicMatAviFoodSlots((IItemHandlerModifiable)picnicMatHandler);
        boolean place = false;
        block0: for (BlockPos outputPos : validOutputPoses) {
            IItemHandler beInv;
            BlockEntity be = worldIn.m_7702_(outputPos);
            if (be == null || (beInv = ItemCulinaryHub.getBeInv(be)) == null) continue;
            for (int i = 0; i < beInv.getSlots(); ++i) {
                ItemStack itemStack = beInv.getStackInSlot(i);
                if (itemStack.m_41619_() || !itemStack.m_41614_()) continue;
                if (aviSlots.isEmpty()) break block0;
                Integer aviSlot = aviSlots.get(0);
                ItemStack copy = itemStack.m_41777_();
                ItemStack left = picnicMatHandler.insertItem(aviSlot.intValue(), copy, false);
                itemStack.m_41774_(copy.m_41613_() - left.m_41613_());
                aviSlots.remove(0);
                place = true;
            }
        }
        if (place) {
            MaidUtil.pickupAction(maid);
            TileUtil.makeChanged((BlockEntity)picnicMat);
        }
    }

    private List<Integer> collectPicnicMatAviFoodSlots(IItemHandlerModifiable picnicMatHandler) {
        ArrayList<Integer> aviSlots = new ArrayList<Integer>();
        for (int i = 0; i < picnicMatHandler.getSlots(); ++i) {
            ItemStack itemStack = picnicMatHandler.getStackInSlot(i);
            if (!itemStack.m_41619_()) continue;
            aviSlots.add(i);
        }
        return aviSlots;
    }

    private boolean placeFood(IItemHandlerModifiable outputHandler, IItemHandlerModifiable picnicMatHandler) {
        boolean place = false;
        for (int i = 0; i < outputHandler.getSlots(); ++i) {
            ItemStack itemStack = outputHandler.getStackInSlot(i);
            if (itemStack.m_41619_() || !itemStack.m_41614_()) continue;
            int slot = this.findAviFoodSlot(picnicMatHandler);
            if (slot != -1) {
                place = true;
                ItemStack copy = itemStack.m_41777_();
                ItemStack left = picnicMatHandler.insertItem(slot, copy, false);
                itemStack.m_41774_(copy.m_41613_() - left.m_41613_());
                continue;
            }
            return place;
        }
        return place;
    }

    private int findAviFoodSlot(IItemHandlerModifiable handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemStack = handler.getStackInSlot(i);
            if (!itemStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private boolean picnicMatHasFood(TileEntityPicnicMat picnicMat) {
        ItemStackHandler handler = picnicMat.getHandler();
        return this.picnicMatHasFood(handler);
    }

    private boolean picnicMatHasFood(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasRequiredMemories(EntityMaid pOwner) {
        return super.m_22543_((LivingEntity)pOwner);
    }
}

