/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm.handler.berry;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmTask;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatHandlerInfo;
import com.github.wallev.maidsoulkitchen.task.farm.FarmType;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import com.github.wallev.maidsoulkitchen.vhelper.IModInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public abstract class BerryHandler
implements ICompatFarmHandler,
ICompatHandlerInfo {
    private static final Set<BerryHandler> berryHandlers = new HashSet<BerryHandler>();
    private BerryHandler nextHandler;

    protected BerryHandler() {
        berryHandlers.add(this);
    }

    public static Set<BerryHandler> getBerryHandlers() {
        return berryHandlers;
    }

    @Override
    public void setNextHandler(ICompatFarmHandler nextHandler) {
        this.nextHandler = (BerryHandler)nextHandler;
    }

    @Override
    public boolean shouldMoveTo(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return this.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public FarmType getFarmType() {
        return FarmType.BERRY;
    }

    protected abstract ICompatFarmHandler.Result processCanHarvest(EntityMaid var1, BlockPos var2, BlockState var3);

    protected abstract boolean processHarvest(EntityMaid var1, BlockPos var2, BlockState var3);

    protected final boolean harvestWithTool(EntityMaid maid, BlockPos cropPos, BlockState cropState, Predicate<ItemStack> predicate) {
        ItemStack toolStack;
        if (this.processCanHarvest(maid, cropPos, cropState) != ICompatFarmHandler.Result.DENY && !(toolStack = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(true), predicate)).m_41619_()) {
            InteractionResult result = WrappedMaidFakePlayer.get(maid).useOnByItem(cropPos, toolStack);
            if (result == InteractionResult.PASS) {
                ICompatFarmTask.BLACK_LIST.add(cropState.m_60734_());
                IModInfo.LOGGER.warn(ICompatFarmTask.BLACK_LIST.toString());
            }
            return true;
        }
        return false;
    }

    protected final boolean harvestWithoutTool(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (this.processCanHarvest(maid, cropPos, cropState) != ICompatFarmHandler.Result.DENY) {
            InteractionResult result = WrappedMaidFakePlayer.get(maid).useOnByHand(cropPos);
            if (result == InteractionResult.PASS) {
                ICompatFarmTask.BLACK_LIST.add(cropState.m_60734_());
                IModInfo.LOGGER.warn(ICompatFarmTask.BLACK_LIST.toString());
            }
            return true;
        }
        return false;
    }

    public final boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        ICompatFarmHandler.Result actionState = this.processCanHarvest(maid, cropPos, cropState);
        if (actionState == ICompatFarmHandler.Result.DENY) {
            return false;
        }
        if (actionState == ICompatFarmHandler.Result.ALLOW) {
            return true;
        }
        return this.nextHandler != null && this.nextHandler.canHarvest(maid, cropPos, cropState);
    }

    public final void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        ICompatFarmHandler.Result actionState = this.processCanHarvest(maid, cropPos, cropState);
        if (actionState != ICompatFarmHandler.Result.DENY) {
            if (actionState == ICompatFarmHandler.Result.ALLOW) {
                this.processHarvest(maid, cropPos, cropState);
            } else if (this.nextHandler != null) {
                this.nextHandler.harvest(maid, cropPos, cropState);
            }
        }
    }
}

