/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CookMoveTask<B extends BlockEntity, R extends Recipe<? extends Container>>
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private static final int MAX_DELAY_TIME = 200;
    private final float movementSpeed;
    private final int verticalSearchRange;
    private final ICookTask<B, R> task;
    private final MaidCookManager<R> cm;
    private final AbstractCookRule<B, R> rule;
    private final CookBeBase<B> cookBe;
    protected int verticalSearchStart;
    private BlockPos currentWorkPos = null;

    public CookMoveTask(ICookTask<B, R> task, MaidCookManager<R> cm, AbstractCookRule<B, R> rule, CookBeBase<B> cookBe) {
        this(task, cm, rule, cookBe, 0.5f, 2);
    }

    public CookMoveTask(ICookTask<B, R> task, MaidCookManager<R> cm, AbstractCookRule<B, R> rule, CookBeBase<B> cookBe, float movementSpeed, int verticalSearchRange) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)MkEntities.WORK_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.task = task;
        this.cm = cm;
        this.rule = rule;
        this.cookBe = cookBe;
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(200);
        this.cm.checkAndInit();
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return this.checkExtraStartConditions() && this.cm.checkAndInit();
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        this.searchForDestination(worldIn, maid);
    }

    protected boolean shouldMoveTo(ServerLevel worldIn, EntityMaid maid, BlockPos blockPos) {
        BlockEntity blockEntity = worldIn.m_7702_(blockPos);
        if (blockEntity != null && this.cookBe.isCookBe(blockEntity)) {
            this.cm.checkAndCreateRecipes();
            this.cookBe.setBe(blockEntity);
            return this.rule.canMoveTo(this.cookBe, this.cm);
        }
        return false;
    }

    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid) {
        BlockPos centrePos = ICookTask.getSearchPos(maid, this.currentWorkPos);
        int searchRange = (int)maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y + 1, z);
                        if (maid.m_21444_((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, (BlockPos)mutableBlockPos) && ICookTask.checkOwnerPos(maid, (BlockPos)mutableBlockPos)) {
                            BlockPos workPos = mutableBlockPos.m_7949_();
                            MemoryUtil.rememberWorkPos(maid, this.cookBe.getWalkPos(), workPos, this.movementSpeed, 0);
                            this.currentWorkPos = workPos;
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }

    private boolean checkExtraStartConditions() {
        return this.cm.checkExtraStartConditions();
    }

    private void setMaxCheckRate(int maxCheckRate) {
        this.cm.setMaxCheckRate(maxCheckRate);
    }

    private void setNextCheckTickCount(int nextCheckTickCount) {
        this.cm.setNextCheckTickCount(nextCheckTickCount);
    }
}

