/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.init.data;

import dev.xkmc.l2damagetracker.contents.damage.DamageWrapperTagProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class DamageTypeAndTagsGen {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> pvd;
    private final ExistingFileHelper helper;
    private final String modid;
    private final List<DamageTypeHolder> holders = new ArrayList<DamageTypeHolder>();

    public DamageTypeAndTagsGen(PackOutput output, CompletableFuture<HolderLookup.Provider> pvd, ExistingFileHelper helper, String modid) {
        this.output = output;
        this.pvd = pvd;
        this.helper = helper;
        this.modid = modid;
    }

    public void generate(boolean gen, DataGenerator generator) {
        DamageTypeGen entries = new DamageTypeGen();
        generator.addProvider(gen, (DataProvider)entries);
        generator.addProvider(gen, (DataProvider)new DamageTypeTagsGen(entries.getRegistryProvider()));
    }

    protected void addDamageTypes(BootstapContext<DamageType> ctx) {
        for (DamageTypeHolder e : this.holders) {
            ctx.m_255272_(e.key, (Object)e.value);
        }
    }

    protected void addDamageTypeTags(DamageWrapperTagProvider pvd, HolderLookup.Provider lookup) {
        for (DamageTypeHolder e : this.holders) {
            for (TagKey<DamageType> t : e.tags) {
                pvd.tag(t).m_255204_(e.key);
            }
        }
    }

    private class DamageTypeGen
    extends DatapackBuiltinEntriesProvider {
        public DamageTypeGen() {
            super(DamageTypeAndTagsGen.this.output, DamageTypeAndTagsGen.this.pvd, new RegistrySetBuilder().m_254916_(Registries.f_268580_, DamageTypeAndTagsGen.this::addDamageTypes), Set.of(DamageTypeAndTagsGen.this.modid));
        }
    }

    private class DamageTypeTagsGen
    extends TagsProvider<DamageType> {
        public DamageTypeTagsGen(CompletableFuture<HolderLookup.Provider> pvd) {
            super(DamageTypeAndTagsGen.this.output, Registries.f_268580_, pvd, DamageTypeAndTagsGen.this.modid, DamageTypeAndTagsGen.this.helper);
        }

        protected void m_6577_(HolderLookup.Provider lookup) {
            DamageTypeAndTagsGen.this.addDamageTypeTags(x$0 -> this.m_206424_(x$0), lookup);
        }
    }

    public class DamageTypeHolder {
        private final ResourceKey<DamageType> key;
        private final DamageType value;
        private final Set<TagKey<DamageType>> tags = new HashSet<TagKey<DamageType>>();

        public DamageTypeHolder(ResourceKey<DamageType> key, DamageType value) {
            this.key = key;
            this.value = value;
            DamageTypeAndTagsGen.this.holders.add(this);
        }

        @SafeVarargs
        public final DamageTypeHolder add(TagKey<DamageType> ... tags) {
            this.tags.addAll(Arrays.asList(tags));
            return this;
        }

        public final DamageTypeHolder add(DamageTypeTagGroup group) {
            this.add(group.tags());
            return this;
        }
    }

    public record DamageTypeTagGroup(TagKey<DamageType>[] tags) {
        @SafeVarargs
        public static DamageTypeTagGroup of(TagKey<DamageType> ... tags) {
            return new DamageTypeTagGroup(tags);
        }
    }
}

