/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.init;

import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attributes.WrappedAttribute;
import dev.xkmc.l2damagetracker.contents.curios.TotemUseToClient;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeRoot;
import dev.xkmc.l2damagetracker.events.ArsEventCompat;
import dev.xkmc.l2damagetracker.events.GeneralAttackListener;
import dev.xkmc.l2damagetracker.init.data.ArmorEffectConfig;
import dev.xkmc.l2damagetracker.init.data.DTAttributeConfigGen;
import dev.xkmc.l2damagetracker.init.data.L2DTLangData;
import dev.xkmc.l2damagetracker.init.data.L2DamageTrackerConfig;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.serial.config.ConfigTypeEntry;
import dev.xkmc.l2library.serial.config.PacketHandlerWithConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2damagetracker")
@Mod.EventBusSubscriber(modid="l2damagetracker", bus=Mod.EventBusSubscriber.Bus.MOD)
public class L2DamageTracker {
    public static final String MODID = "l2damagetracker";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("l2damagetracker");
    public static final PacketHandlerWithConfig PACKET_HANDLER = new PacketHandlerWithConfig(new ResourceLocation("l2damagetracker", "main"), 2, new Function[]{e -> e.create(TotemUseToClient.class, NetworkDirection.PLAY_TO_CLIENT)});
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<Attribute>> ATTR_TAGS = ProviderType.register((String)"tags/attribute", type -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl(p, type, "attributes", e.getGenerator().getPackOutput(), Registries.f_256728_, e.getLookupProvider(), reg -> (ResourceKey)ForgeRegistries.ATTRIBUTES.getResourceKey(reg).orElseThrow(), e.getExistingFileHelper()));
    public static final TagKey<Attribute> PERCENTAGE = L2DamageTracker.key("percentage");
    public static final TagKey<Attribute> NEGATIVE = L2DamageTracker.key("negative");
    public static final RegistryEntry<WrappedAttribute> CRIT_RATE = L2DamageTracker.regWrapped(REGISTRATE, "crit_rate", 0.0, 0.0, 1.0, "Weapon Crit Rate", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> CRIT_DMG = L2DamageTracker.regWrapped(REGISTRATE, "crit_damage", 0.5, 0.0, 1000.0, "Weapon Crit Damage", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> BOW_STRENGTH = L2DamageTracker.regWrapped(REGISTRATE, "bow_strength", 1.0, 0.0, 1000.0, "Projectile Strength", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> EXPLOSION_FACTOR = L2DamageTracker.regWrapped(REGISTRATE, "explosion_damage", 1.0, 0.0, 1000.0, "Explosion Damage", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> FIRE_FACTOR = L2DamageTracker.regWrapped(REGISTRATE, "fire_damage", 1.0, 0.0, 1000.0, "Fire Damage", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> MAGIC_FACTOR = L2DamageTracker.regWrapped(REGISTRATE, "magic_damage", 1.0, 0.0, 1000.0, "Magic Damage", PERCENTAGE);
    public static final RegistryEntry<WrappedAttribute> ABSORB = L2DamageTracker.regWrapped(REGISTRATE, "damage_absorption", 0.0, 0.0, 10000.0, "Damage Absorption", new TagKey[0]);
    public static final RegistryEntry<WrappedAttribute> REDUCTION = L2DamageTracker.regWrapped(REGISTRATE, "damage_reduction", 1.0, -10000.0, 10000.0, "Damage after Reduction", PERCENTAGE, NEGATIVE);
    public static final ConfigTypeEntry<ArmorEffectConfig> ARMOR = new ConfigTypeEntry(PACKET_HANDLER, "armor", ArmorEffectConfig.class);

    public L2DamageTracker() {
        L2DamageTrackerConfig.init();
        L2DamageTypes.register();
        AttackEventHandler.register(1000, new GeneralAttackListener());
        REGISTRATE.addDataGenerator(ProviderType.LANG, L2DTLangData::genLang);
        if (ModList.get().isLoaded("ars_nouveau")) {
            MinecraftForge.EVENT_BUS.register(ArsEventCompat.class);
        }
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)CRIT_RATE.get());
        event.add(EntityType.f_20532_, (Attribute)CRIT_DMG.get());
        for (EntityType e : event.getTypes()) {
            event.add(e, (Attribute)BOW_STRENGTH.get());
            event.add(e, (Attribute)EXPLOSION_FACTOR.get());
            event.add(e, (Attribute)FIRE_FACTOR.get());
            event.add(e, (Attribute)MAGIC_FACTOR.get());
            event.add(e, (Attribute)REDUCTION.get());
            event.add(e, (Attribute)ABSORB.get());
        }
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean gen = event.includeServer();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        new L2DamageTypes(output, pvd, helper).generate(gen, event.getGenerator());
        if (ModList.get().isLoaded("l2tabs")) {
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DTAttributeConfigGen(event.getGenerator()));
        }
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        DamageTypeRoot.generateAll();
    }

    public static RegistryEntry<WrappedAttribute> regWrapped(L2Registrate reg, String id, double def, double min, double max, String name, TagKey<Attribute> ... keys) {
        reg.addRawLang("attribute." + reg.getModid() + "." + id, name);
        return ((NoConfigBuilder)reg.generic((Object)reg, id, ForgeRegistries.ATTRIBUTES.getRegistryKey(), () -> new WrappedAttribute("attribute." + reg.getModid() + "." + id, def, min, max).setSyncable(true)).tag(ATTR_TAGS, keys)).register();
    }

    public static TagKey<Attribute> key(String id) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256728_, (ResourceLocation)new ResourceLocation(MODID, id));
    }
}

