/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.generic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericTieredItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericAxeItem
extends AxeItem
implements GenericTieredItem {
    private final ExtraToolConfig config;

    public GenericAxeItem(Tier tier, int damage, float speed, Item.Properties prop, ExtraToolConfig config) {
        super(tier, (float)damage, speed, prop);
        this.config = config;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        this.config.inventoryTick(stack, level, entity, slot, selected);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.config.damageItem(stack, amount, entity);
    }

    public boolean m_41465_() {
        return this.config.canBeDepleted;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity user) {
        this.config.onHit(stack, target, user);
        if (this.config.tool_hit > 0) {
            stack.m_41622_(this.config.tool_hit, user, level -> level.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (this.config.tool_mine > 0 && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(this.config.tool_mine, entity, l -> l.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return super.getSweepHitBox(stack, player, target);
    }

    @Override
    public ExtraToolConfig getExtraConfig() {
        return this.config;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap parent = super.getAttributeModifiers(slot, stack);
        if (slot != EquipmentSlot.MAINHAND) {
            return parent;
        }
        HashMultimap cur = HashMultimap.create();
        cur.putAll(parent);
        return this.config.modify((Multimap<Attribute, AttributeModifier>)cur, slot, stack);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float old = super.m_8102_(stack, state);
        return this.config.getDestroySpeed(stack, state, old);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.config.addTooltip(pStack, pTooltipComponents);
    }
}

