/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.generic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraArmorConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GenericArmorItem
extends ArmorItem {
    private final ExtraArmorConfig config;

    public GenericArmorItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties prop, ExtraArmorConfig config) {
        super(material, slot, prop);
        this.config = config;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.config.damageItem(stack, amount, entity);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        this.config.inventoryTick(stack, level, entity, slot, selected);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        this.config.onArmorTick(stack, world, player);
    }

    public ExtraArmorConfig getConfig() {
        return this.config;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap parent = super.getAttributeModifiers(slot, stack);
        if (slot != this.f_265916_.m_266308_()) {
            return parent;
        }
        HashMultimap cur = HashMultimap.create();
        cur.putAll(parent);
        return this.config.modify((Multimap<Attribute, AttributeModifier>)cur, slot, stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.config.addTooltip(pStack, pTooltipComponents);
    }
}

