/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.api;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArmorMat
implements ArmorMaterial {
    private static final int[] HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    public ArmorMat(String name, int durability, int[] protection, int enchant, SoundEvent sound, float tough, float kb, Supplier<Ingredient> repair) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.slotProtections = protection;
        this.enchantmentValue = enchant;
        this.sound = sound;
        this.toughness = tough;
        this.knockbackResistance = kb;
        this.repairIngredient = Suppliers.memoize(repair::get);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_PER_SLOT[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.slotProtections[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }
}

