/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.damage;

import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeRoot;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import dev.xkmc.l2damagetracker.contents.damage.DamageWrapperTagProvider;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public final class DamageTypeVariant
implements DamageTypeWrapper {
    private final ResourceKey<DamageType> type;
    private final DamageTypeRoot root;
    private final int key;
    private final TreeSet<DamageState> enabledStates;

    public DamageTypeVariant(String modid, DamageTypeRoot root, int key, TreeSet<DamageState> set) {
        this.root = root;
        this.key = key;
        this.enabledStates = set;
        StringBuilder name = new StringBuilder(root.type().m_135782_().m_135815_());
        for (DamageState state : set) {
            name.append("-").append(state.getId().m_135815_());
        }
        this.type = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(modid, name.toString()));
    }

    @Override
    public ResourceKey<DamageType> type() {
        return this.type;
    }

    @Override
    public boolean validState(DamageState state) {
        return this.root.validState(state);
    }

    @Override
    public boolean isEnabled(DamageState state) {
        return this.root.isEnabled(this.key, state);
    }

    @Override
    @Nullable
    public DamageTypeWrapper enable(DamageState state) {
        return this.root.get(this.key, state);
    }

    @Override
    public DamageTypeWrapper toRoot() {
        return this.root;
    }

    public DamageTypeRoot root() {
        return this.root;
    }

    @Override
    public void gen(DamageWrapperTagProvider gen, HolderLookup.Provider pvd) {
        TreeSet<TagKey> tags = new TreeSet<TagKey>(Comparator.comparing(TagKey::f_203868_));
        tags.addAll(this.root.inherent);
        for (DamageState state : this.root.states) {
            if (!this.isEnabled(state)) continue;
            state.gatherTags(tags::add);
        }
        for (DamageState state : this.root.states) {
            if (!this.isEnabled(state)) continue;
            state.removeTags(tags::remove);
        }
        for (TagKey tag : tags) {
            gen.tag((TagKey<DamageType>)tag).m_255204_(this.type);
        }
    }

    @Override
    public DamageType getObject() {
        return this.root().sup.apply(this);
    }

    @Override
    public Set<DamageState> states() {
        return this.enabledStates;
    }
}

