/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.attack.LogHelper;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2damagetracker.init.data.L2DamageTrackerConfig;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class LogEntry {
    private final DamageSource source;
    private final LivingEntity target;
    @Nullable
    private final LivingEntity attacker;
    private final String time;
    private final boolean log;
    private final boolean info;
    private final boolean trace;
    private final List<String> output = new ArrayList<String>();
    private final Map<DamageModifier, String> modifiers = new HashMap<DamageModifier, String>();
    private final List<Path> saves = new ArrayList<Path>();

    public static LogEntry of(DamageSource source, LivingEntity target, @Nullable LivingEntity attacker) {
        return new LogEntry(source, target, attacker);
    }

    private static Path path(Player player, @Nullable LivingEntity other, String type, String time) {
        String otherType;
        if (other == null) {
            otherType = "null";
        } else {
            ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)other.m_6095_());
            assert (rl != null);
            otherType = rl.m_135815_().replaceAll("/", "_");
        }
        return FMLPaths.GAMEDIR.get().resolve("logs/damage_tracker/" + player.m_6302_() + "-" + type + "/" + otherType + "/" + time + ".txt");
    }

    private LogEntry(DamageSource source, LivingEntity target, @Nullable LivingEntity attacker) {
        ServerPlayer player;
        this.source = source;
        this.target = target;
        this.attacker = attacker;
        this.time = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(new Date());
        this.info = (Boolean)L2DamageTrackerConfig.COMMON.printDamageTrace.get();
        if (target instanceof ServerPlayer && LogHelper.savePlayerHurt(player = (ServerPlayer)target)) {
            this.saves.add(LogEntry.path((Player)player, attacker, "hurt", this.time));
        }
        if (attacker instanceof ServerPlayer && LogHelper.savePlayerAttack(player = (ServerPlayer)attacker)) {
            this.saves.add(LogEntry.path((Player)player, target, "attack", this.time));
        }
        this.trace = !this.saves.isEmpty();
        boolean bl = this.log = this.info || this.trace;
        if (this.log) {
            this.output.add("------ Damage Tracker Profile START ------");
            this.output.add("Attacked Entity: " + target);
            this.output.add("Attacker Entity: " + attacker);
            this.output.add("Damage Source: " + source.m_269150_().m_203543_().map(e -> e.m_135782_().toString()).orElseGet(() -> source.m_269415_().f_268677_()));
        }
    }

    public void log(Stage stage, float amount) {
        if (!this.log) {
            return;
        }
        this.output.add("Stage " + stage.name() + ": val = " + amount);
        if (stage == Stage.DAMAGE_FINAL) {
            this.output.add("------ Damage Tracker Profile END ------");
            if (this.info) {
                for (String e2 : this.output) {
                    L2DamageTracker.LOGGER.info(e2);
                }
            }
            for (Path path : this.saves) {
                LogEntry.write(path, e -> this.output.forEach(e::println));
            }
        }
    }

    @Nullable
    public LogEntry initModifiers() {
        this.modifiers.clear();
        return this.trace ? this : null;
    }

    public void recordModifier(DamageModifier mod) {
        if (!this.trace) {
            return;
        }
        this.modifiers.put(mod, LogEntry.getStackTrace());
    }

    public void startLayer(DamageModifier.Order key, float val) {
        this.output.add("| - Layer " + key.name() + " start, val = " + val);
    }

    public void processModifier(DamageModifier e, String info) {
        this.output.add("| - | " + info + ", source = " + this.modifiers.get(e));
    }

    public void endLayer(DamageModifier.Order key, float val) {
        this.output.add("| - Layer " + key.name() + " end, val = " + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Path path, Consumer<PrintStream> cons) {
        PrintStream stream = null;
        try {
            stream = LogEntry.getStream(path);
            cons.accept(stream);
        }
        catch (Exception e) {
            L2DamageTracker.LOGGER.throwing(Level.ERROR, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    L2DamageTracker.LOGGER.throwing(Level.FATAL, (Throwable)e);
                }
            }
        }
    }

    private static PrintStream getStream(Path path) throws IOException {
        File file = path.toFile();
        if (!file.exists()) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("failed to create directory " + file.getParentFile());
            }
            if (!file.createNewFile()) {
                throw new IOException("failed to create file " + file);
            }
        }
        return new PrintStream(file);
    }

    private static String getStackTrace() {
        StackTraceElement[] trace;
        for (StackTraceElement e : trace = new Throwable().getStackTrace()) {
            if (e.getClassName().startsWith("dev.xkmc.l2damagetracker.contents.attack")) continue;
            return e.toString();
        }
        return "unknown";
    }

    public static enum Stage {
        ATTACK,
        HURT_PRE,
        HURT_L2,
        HURT_POST,
        DAMAGE_PRE,
        DAMAGE_FINAL;

    }
}

