/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.Additive;
import dev.xkmc.l2damagetracker.contents.attack.Multiplicative;
import dev.xkmc.l2damagetracker.contents.attack.Nonlinear;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;

public interface DamageModifier {
    public static DamageModifier nonlinearPre(int priority, Float2FloatFunction func) {
        return new Nonlinear(Order.PRE_NONLINEAR, priority, func);
    }

    public static DamageModifier multAttr(float val) {
        return new Multiplicative(Order.PRE_MULTIPLICATIVE, val);
    }

    public static DamageModifier add(float val) {
        return new Additive(Order.PRE_ADDITIVE, val);
    }

    public static DamageModifier multBase(float val) {
        return new Additive(Order.POST_MULT_BASE, val);
    }

    public static DamageModifier multTotal(float val) {
        return new Multiplicative(Order.POST_MULTIPLICATIVE, val);
    }

    public static DamageModifier nonlinearMiddle(int priority, Float2FloatFunction func) {
        return new Nonlinear(Order.POST_NONLINEAR, priority, func);
    }

    public static DamageModifier addExtra(float val) {
        return new Additive(Order.POST_ADDITIVE, val);
    }

    public static DamageModifier nonlinearFinal(int priority, Float2FloatFunction func) {
        return new Nonlinear(Order.END_NONLINEAR, priority, func);
    }

    public String info(float var1);

    public float modify(float var1);

    public int priority();

    public Order order();

    public static enum Order {
        PRE_NONLINEAR(Type.NONLINEAR),
        PRE_MULTIPLICATIVE(Type.MULTIPLICATIVE),
        PRE_ADDITIVE(Type.ADDITIVE),
        POST_MULT_BASE(Type.MULTIPLICATIVE),
        POST_MULTIPLICATIVE(Type.MULTIPLICATIVE),
        POST_NONLINEAR(Type.NONLINEAR),
        POST_ADDITIVE(Type.ADDITIVE),
        END_NONLINEAR(Type.NONLINEAR);

        public final Type type;

        private Order(Type type) {
            this.type = type;
        }
    }

    public static enum Type {
        ADDITIVE(v -> 0.0f, (v, n) -> v + n),
        MULTIPLICATIVE(v -> 1.0f, (v, n) -> v * n),
        NONLINEAR(v -> v, (v, n) -> n);

        public final Start start;
        public final End end;

        private Type(Start start, End end) {
            this.start = start;
            this.end = end;
        }

        public static interface Start {
            public float start(float var1);
        }

        public static interface End {
            public float end(float var1, float var2);
        }
    }

    public static enum Time {
        CRIT,
        ATTACK,
        HURT,
        DAMAGE;

    }
}

