/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.attack.LogEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class DamageAccumulator {
    private boolean frozen = true;
    private boolean maximized = false;
    private float finalDamage;
    private final List<DamageModifier> modifiers = new ArrayList<DamageModifier>();

    float run(float original, @Nullable LogEntry log, Consumer<AttackListener> collect, Consumer<AttackListener> maximize) {
        this.frozen = false;
        AttackEventHandler.getListeners().forEach(collect);
        this.frozen = true;
        this.finalDamage = this.accumulate(original, log);
        this.maximized = true;
        AttackEventHandler.getListeners().forEach(maximize);
        return this.finalDamage;
    }

    private float accumulate(float val, @Nullable LogEntry log) {
        TreeMap map = new TreeMap();
        for (DamageModifier damageModifier : this.modifiers) {
            if (!map.containsKey((Object)damageModifier.order())) {
                map.put(damageModifier.order(), new TreeMap());
            }
            TreeMap sub = (TreeMap)map.get((Object)damageModifier.order());
            int i = damageModifier.priority();
            while (sub.containsKey(i)) {
                ++i;
            }
            sub.put(i, damageModifier);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (log != null) {
                log.startLayer((DamageModifier.Order)((Object)entry.getKey()), val);
            }
            float num = ((DamageModifier.Order)((Object)entry.getKey())).type.start.start(val);
            for (DamageModifier e : ((TreeMap)entry.getValue()).values()) {
                num = e.modify(num);
                if (log == null) continue;
                log.processModifier(e, e.info(num));
            }
            val = ((DamageModifier.Order)((Object)entry.getKey())).type.end.end(val, num);
            if (log == null) continue;
            log.endLayer((DamageModifier.Order)((Object)entry.getKey()), val);
        }
        return val;
    }

    public float getMaximized() {
        if (!this.maximized) {
            throw new IllegalStateException("damage not calculated yet");
        }
        return this.finalDamage;
    }

    public void addHurtModifier(DamageModifier mod) {
        if (this.frozen) {
            throw new IllegalStateException("modify damage only on event.");
        }
        this.modifiers.add(mod);
    }
}

