/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.PlayerAttackCache;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeRoot;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CreateSourceEvent {
    private final Registry<DamageType> registry;
    private final ResourceKey<DamageType> original;
    private LivingEntity attacker;
    private Entity direct;
    @Nullable
    private PlayerAttackCache playerAttackCache = null;
    @Nullable
    private DamageTypeWrapper result;

    public CreateSourceEvent(Registry<DamageType> registry, ResourceKey<DamageType> mobAttack, LivingEntity entity, @Nullable Entity direct) {
        this.registry = registry;
        this.original = mobAttack;
        this.attacker = entity;
        this.direct = direct;
        this.result = DamageTypeRoot.ROOTS.get(this.original);
    }

    public ResourceKey<DamageType> getOriginal() {
        return this.original;
    }

    public LivingEntity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public Entity getDirect() {
        return this.direct;
    }

    public void setDirect(@Nullable Entity entity) {
        this.direct = entity;
    }

    @Nullable
    public DamageTypeWrapper getResult() {
        return this.result;
    }

    @Deprecated
    public void setResult(DamageTypeWrapper result) {
        this.result = result;
    }

    @Nullable
    public PlayerAttackCache getPlayerAttackCache() {
        return this.playerAttackCache;
    }

    public void setPlayerAttackCache(PlayerAttackCache playerAttackCache) {
        this.playerAttackCache = playerAttackCache;
    }

    public Registry<DamageType> getRegistry() {
        return this.registry;
    }

    public void enable(DamageState state) {
        if (this.result == null) {
            L2DamageTracker.LOGGER.warn("DamageType " + this.original.m_135782_() + " is not mutable");
            return;
        }
        if (!this.result.validState(state)) {
            L2DamageTracker.LOGGER.warn("DamageType " + this.result.type().m_135782_() + " does not contain state " + state.getId());
            return;
        }
        if (this.result.isEnabled(state)) {
            return;
        }
        DamageTypeWrapper next = this.result.enable(state);
        if (next == null || !this.registry.m_142003_(next.type())) {
            boolean all = true;
            boolean covered = false;
            for (DamageState old : this.result.states()) {
                all &= state.overrides(old);
                covered |= old.overrides(state);
            }
            if (all) {
                next = this.result.toRoot().enable(state);
            } else if (covered) {
                next = this.result;
            } else {
                L2DamageTracker.LOGGER.warn("DamageType " + this.result.type().m_135782_() + " cannot enable state " + state.getId());
                return;
            }
        }
        if (next != null) {
            this.result = next;
        }
    }
}

