/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.DamageAccumulator;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.attack.LogEntry;
import dev.xkmc.l2damagetracker.contents.attack.PlayerAttackCache;
import dev.xkmc.l2damagetracker.contents.attack.Stage;
import dev.xkmc.l2damagetracker.init.data.L2DamageTrackerConfig;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class AttackCache {
    int recursive = 0;
    private Stage stage = Stage.PREINIT;
    private PlayerAttackCache player;
    private LivingAttackEvent attack;
    private LivingHurtEvent hurt;
    private LivingDamageEvent damage;
    private LivingEntity target;
    private LivingEntity attacker;
    private ItemStack weapon = ItemStack.f_41583_;
    private float damage_pre;
    private final DamageAccumulator hurtDamage = new DamageAccumulator();
    private final DamageAccumulator dealtDamage = new DamageAccumulator();
    private LogEntry log;

    private boolean shouldLog() {
        if (this.getAttacker() instanceof Player && ((Boolean)L2DamageTrackerConfig.COMMON.savePlayerAttack.get()).booleanValue()) {
            return true;
        }
        if (this.getAttackTarget() instanceof Player && ((Boolean)L2DamageTrackerConfig.COMMON.savePlayerHurt.get()).booleanValue()) {
            return true;
        }
        return (Boolean)L2DamageTrackerConfig.COMMON.printDamageTrace.get();
    }

    void pushAttackPre(LivingAttackEvent event) {
        LivingEntity le;
        this.stage = Stage.HURT_PRE;
        this.attack = event;
        this.target = this.attack.getEntity();
        Entity entity = this.attack.getSource().m_7639_();
        this.attacker = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        AttackEventHandler.getListeners().forEach(e -> e.setupProfile(this, this::setupAttackerProfile));
        this.damage_pre = event.getAmount();
        this.log = LogEntry.of(this.attack.getSource(), this.getAttackTarget(), this.getAttacker());
        AttackEventHandler.getListeners().forEach(e -> e.onAttack(this, this.weapon));
    }

    void pushAttackPost(LivingAttackEvent event) {
        this.stage = Stage.HURT_POST;
        AttackEventHandler.getListeners().forEach(e -> e.postAttack(this, event, this.weapon));
        this.log.log(LogEntry.Stage.ATTACK, event.getAmount());
    }

    void pushHurtPre(LivingHurtEvent event) {
        this.stage = Stage.ACTUALLY_HURT_PRE;
        this.hurt = event;
        this.log.log(LogEntry.Stage.HURT_PRE, event.getAmount());
        float damage = this.hurtDamage.run(event.getAmount(), this.log.initModifiers(), e -> e.onHurt(this, this.weapon), e -> e.onHurtMaximized(this, this.weapon));
        this.log.log(LogEntry.Stage.HURT_L2, damage);
        event.setAmount(damage);
    }

    void pushHurtPost(LivingHurtEvent event) {
        this.stage = Stage.ACTUALLY_HURT_POST;
        AttackEventHandler.getListeners().forEach(e -> e.postHurt(this, event, this.weapon));
        this.log.log(LogEntry.Stage.HURT_POST, event.getAmount());
    }

    void pushDamagePre(LivingDamageEvent event) {
        this.stage = Stage.DAMAGE;
        this.damage = event;
        this.log.log(LogEntry.Stage.DAMAGE_PRE, event.getAmount());
        float damage = this.dealtDamage.run(event.getAmount(), this.log.initModifiers(), e -> e.onDamage(this, this.weapon), e -> e.onDamageFinalized(this, this.weapon));
        this.log.log(LogEntry.Stage.DAMAGE_FINAL, damage);
        event.setAmount(damage);
    }

    void setupAttackerProfile(@Nullable LivingEntity entity, @Nullable ItemStack stack) {
        if (this.attacker == null && entity != null) {
            this.attacker = entity;
        }
        if (this.weapon.m_41619_() && stack != null) {
            this.weapon = stack;
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    @Nullable
    public AttackEntityEvent getPlayerAttackEntityEvent() {
        return this.player == null ? null : this.player.getPlayerAttackEntityEvent();
    }

    @Nullable
    public CriticalHitEvent getCriticalHitEvent() {
        return this.player == null ? null : this.player.getCriticalHitEvent();
    }

    @Nullable
    public LivingAttackEvent getLivingAttackEvent() {
        return this.attack;
    }

    @Nullable
    public LivingHurtEvent getLivingHurtEvent() {
        return this.hurt;
    }

    @Nullable
    public LivingDamageEvent getLivingDamageEvent() {
        return this.damage;
    }

    public LivingEntity getAttackTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public float getStrength() {
        return this.player == null ? 1.0f : this.player.getStrength();
    }

    public float getPreDamageOriginal() {
        if (this.stage.ordinal() < Stage.HURT_PRE.ordinal()) {
            throw new IllegalStateException("dealt damage not calculated yet");
        }
        return this.damage_pre;
    }

    public float correctPreDamageOriginal(float actual) {
        if (this.stage.ordinal() < Stage.HURT_PRE.ordinal()) {
            throw new IllegalStateException("dealt damage not calculated yet");
        }
        return this.damage_pre;
    }

    public float getPreDamage() {
        return this.hurtDamage.getMaximized();
    }

    public void addHurtModifier(DamageModifier mod) {
        this.log.recordModifier(mod);
        this.hurtDamage.addHurtModifier(mod);
    }

    public float getDamageDealt() {
        return this.dealtDamage.getMaximized();
    }

    public void addDealtModifier(DamageModifier mod) {
        this.log.recordModifier(mod);
        this.dealtDamage.addHurtModifier(mod);
    }

    public void setupPlayer(PlayerAttackCache prev) {
        this.player = prev;
        this.attacker = prev.getAttacker();
        if (!prev.getWeapon().m_41619_()) {
            this.weapon = prev.getWeapon();
        }
    }
}

