/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemDefinition {
    public static final ItemDefinition EMPTY = new ItemDefinition(ItemStack.f_41583_);
    public static final Codec<ItemDefinition> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(ItemDefinition::item), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(o -> Optional.ofNullable(o.tag))).apply((Applicative)ins, (item, tag) -> new ItemDefinition((Item)item, tag.orElse(null))));
    private final Item item;
    private final boolean testTag;
    @Nullable
    private final CompoundTag tag;
    private final ItemStack stack;

    protected ItemDefinition(ItemStack stack) {
        this(stack.m_41720_(), stack.m_41783_());
    }

    protected ItemDefinition(Item item) {
        this(item, null);
    }

    protected ItemDefinition(Item item, @Nullable CompoundTag tag) {
        this.item = item;
        this.stack = this.makeStack();
        this.tag = tag;
        this.testTag = this.stack.m_41763_() ? false : tag != null;
    }

    public static ItemDefinition of(Item item, @Nullable CompoundTag tag) {
        return new ItemDefinition(item, tag);
    }

    public static ItemDefinition of(ItemStack stack) {
        return new ItemDefinition(stack);
    }

    public static ItemDefinition of(Item item) {
        return new ItemDefinition(item);
    }

    private ItemStack makeStack() {
        ItemStack copy = new ItemStack((ItemLike)this.item, 1);
        if (this.tag != null) {
            copy.m_41751_(this.tag);
        }
        return copy;
    }

    public ItemStack toStack(int count) {
        int c = Math.min(count, this.stack.m_41741_());
        this.stack.m_41764_(c);
        return this.stack;
    }

    public ItemStack toStack(long count) {
        int c = (int)Math.min(count, (long)this.stack.m_41741_());
        this.stack.m_41764_(c);
        return this.stack;
    }

    public boolean is(ItemDefinition itemDef) {
        if (itemDef.testTag) {
            return this.item.equals(itemDef.item) && Objects.equals(this.tag, itemDef.tag);
        }
        return this.item.equals(itemDef.item);
    }

    public boolean is(ItemStack itemStack) {
        if (this.testTag) {
            return this.item.equals(itemStack.m_41720_()) && Objects.equals(this.tag, itemStack.m_41783_());
        }
        return this.item.equals(itemStack.m_41720_());
    }

    public boolean is(Item item) {
        return this.item.equals(item);
    }

    public ItemStack stack() {
        this.stack.m_41764_(1);
        return this.stack;
    }

    public int getMaxStackSize() {
        return this.stack.m_41741_();
    }

    public boolean isStackable() {
        return this.stack.m_41753_();
    }

    public Item item() {
        return this.item;
    }

    @Nullable
    public CompoundTag tag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (o != null) {
            if (o instanceof ItemDefinition) {
                ItemDefinition that = (ItemDefinition)o;
                return this.is(that);
            }
            if (o instanceof ItemStack) {
                ItemStack that = (ItemStack)o;
                return this.is(that);
            }
            if (o instanceof Item) {
                Item that = (Item)o;
                return this.is(that);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.testTag ? Objects.hash(this.item, this.tag) : this.item.hashCode();
    }

    public String toString() {
        return this.item.toString();
    }
}

