/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.cook.be;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.ICookBeAccessor;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.IInvHandler;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import com.github.wallev.maidsoulkitchen.vhelper.server.item.VItemStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class CookBeBase<B extends BlockEntity> {
    protected final EntityMaid maid;
    protected final WrappedMaidFakePlayer fakePlayer;
    protected final ServerLevel serverLevel;
    protected B be;
    protected List<ItemStack> activeItems;

    public CookBeBase(EntityMaid maid) {
        this.maid = maid;
        this.serverLevel = (ServerLevel)maid.f_19853_;
        this.fakePlayer = WrappedMaidFakePlayer.get(maid);
        this.initActiveItemStacks();
    }

    public boolean hasResult() {
        return !this.getResult().m_41619_();
    }

    public void extractResult(IItemHandler result2Inv) {
        this.takeItem(this.getResult(), result2Inv);
    }

    public boolean hasInputs() {
        IInvHandler ingredientInv = this.getIngredientInv();
        int start = this.getIngredientSlotStart();
        int size = start + this.getIngredientSize();
        for (int i = start; i < size; ++i) {
            if (ingredientInv.kl$getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void takeInputs(IItemHandler inputs2Inv) {
        IInvHandler ingredientInv = this.getIngredientInv();
        int start = this.getIngredientSlotStart();
        int size = start + this.getIngredientSize();
        for (int i = start; i < size; ++i) {
            this.takeItem(ingredientInv.kl$getStackInSlot(i), inputs2Inv);
        }
    }

    protected boolean insertFluidItems(MaidItem fluidItem, ItemInventory itemInventory) {
        ItemDefinition item = fluidItem.item();
        int amount = fluidItem.count();
        LinkedList<ItemStack> fluidItems = itemInventory.getItemStacks(item);
        for (ItemStack itemStack : fluidItems) {
            if (itemStack.m_41619_()) continue;
            int count0 = itemStack.m_41613_();
            if (count0 >= amount) {
                this.useItem(itemStack, amount);
                break;
            }
            this.useItem(itemStack, count0);
            if ((amount -= count0) > 0) continue;
            break;
        }
        return true;
    }

    protected void useItem(ItemStack itemStack, int times) {
        InteractionResult result;
        for (int i = 0; i < times && (result = this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack)) != InteractionResult.FAIL && result != InteractionResult.PASS; ++i) {
        }
    }

    protected void useItem(ItemStack itemStack, Supplier<Boolean> condition) {
        InteractionResult result;
        while (!itemStack.m_41619_() && condition.get().booleanValue() && (result = this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack)) != InteractionResult.FAIL && result != InteractionResult.PASS) {
        }
    }

    protected void useItem(ItemStack itemStack) {
        this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack);
    }

    public boolean insertFluidItems(MaidItem fluidItem, ItemInventory itemInventory, IItemHandlerModifiable toInv) {
        ItemDefinition item = fluidItem.item();
        int amount = fluidItem.count();
        LinkedList<ItemStack> fluidItems = itemInventory.getItemStacks(item);
        for (ItemStack itemStack : fluidItems) {
            if (itemStack.m_41619_()) continue;
            int count0 = itemStack.m_41613_();
            if (count0 >= amount) {
                this.useItem(itemStack, amount, toInv);
                break;
            }
            this.useItem(itemStack, count0, toInv);
            if ((amount -= count0) > 0) continue;
            break;
        }
        return true;
    }

    public InteractionResult useItem(ItemStack itemStack, int times, IItemHandlerModifiable toInv) {
        for (int i = 0; i < times; ++i) {
            InteractionResult result = this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack, toInv);
            if (result != InteractionResult.FAIL && result != InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useItem(ItemStack itemStack, Supplier<Boolean> condition, IItemHandlerModifiable toInv) {
        while (!itemStack.m_41619_() && condition.get().booleanValue()) {
            InteractionResult result = this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack, toInv);
            if (result != InteractionResult.FAIL && result != InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useItem(ItemStack itemStack, IItemHandlerModifiable toInv) {
        return this.fakePlayer.useOnByItem(this.be.m_58899_(), itemStack, toInv);
    }

    public InteractionResult useItemWithSneak(ItemStack itemStack, IItemHandlerModifiable toInv) {
        return this.fakePlayer.useOnByItemWithSneak(this.be.m_58899_(), itemStack, toInv);
    }

    public boolean insertInputs(MaidRec rec, ItemInventory itemInventory) {
        IInvHandler ingredientInv = this.getIngredientInv();
        int index = 0;
        for (MaidItem maidItem : rec.maidItems()) {
            if (!maidItem.isEmpty()) {
                ItemDefinition item = maidItem.item();
                int count = maidItem.count();
                this.insertAndShrink(ingredientInv, count, itemInventory.getItemStacks(item), index);
            }
            ++index;
        }
        return true;
    }

    public void insertAndShrink(IInvHandler beInv, Integer amount, Collection<ItemStack> ingredient, int slotIndex) {
        if (ingredient == null) {
            return;
        }
        for (ItemStack itemStack : ingredient) {
            ItemStack leftInsertedStack;
            if (itemStack.m_41619_()) continue;
            int count = itemStack.m_41613_();
            if (count >= amount) {
                leftInsertedStack = beInv.kl$insertItem(slotIndex, VItemStack.copyWithCount(itemStack, amount), false);
                itemStack.m_41774_(amount - leftInsertedStack.m_41613_());
                break;
            }
            leftInsertedStack = beInv.kl$insertItem(slotIndex, VItemStack.copyWithCount(itemStack, count), false);
            itemStack.m_41774_(count - leftInsertedStack.m_41613_());
            if ((amount = Integer.valueOf(amount - count)) > 0) continue;
            break;
        }
    }

    public boolean hasEnoughIngredient(MaidRec rec, Map<Item, Collection<ItemStack>> invIngredients) {
        for (MaidItem maidItem : rec.maidItems()) {
            ItemStack itemStack;
            ItemDefinition item = maidItem.item();
            int actualCount = maidItem.count();
            Iterator iterator = ((Collection)invIngredients.getOrDefault(item.item(), new LinkedList())).iterator();
            while (iterator.hasNext() && (actualCount -= (itemStack = (ItemStack)iterator.next()).m_41613_()) > 0) {
            }
            if (actualCount <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasMeal() {
        return !this.getMeal().m_41619_();
    }

    public boolean hasContainer() {
        return !this.getNowContainer().m_41619_();
    }

    public boolean takeContainer(IItemHandler item2Inv) {
        return this.takeItem(this.getNowContainer(), item2Inv);
    }

    public boolean insertContainer(ItemStack container) {
        return this.insertItem(container, this.getContainerInv(), this.getContainerSlot());
    }

    public boolean hasActiveItem() {
        return !this.activeItemStack().m_41619_();
    }

    public boolean takeActiveItem(IItemHandler item2Inv) {
        return this.takeItem(this.activeItemStack(), item2Inv);
    }

    public boolean insertActiveItem(ItemStack activeItem) {
        return this.insertItem(activeItem, this.activeItemInv(), this.activeItemSlot());
    }

    public boolean takeItem(ItemStack takeItem, IItemHandler item2Inv) {
        if (!takeItem.m_41619_()) {
            ItemStack copy = takeItem.m_41777_();
            ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)item2Inv, (ItemStack)copy, (boolean)false);
            takeItem.m_41774_(copy.m_41613_() - leftStack.m_41613_());
            return leftStack.m_41613_() == 0;
        }
        return false;
    }

    public boolean insertItem(ItemStack insertItem, IInvHandler insertInv, int insertSlot) {
        ItemStack copy = insertItem.m_41777_();
        ItemStack leftStack = insertInv.kl$insertItem(insertSlot, copy, false);
        insertItem.m_41774_(copy.m_41613_() - leftStack.m_41613_());
        return leftStack.m_41613_() == 0;
    }

    public abstract boolean isCookBe(BlockEntity var1);

    public abstract IInvHandler getInv();

    public IInvHandler getIngredientInv() {
        return this.getInv();
    }

    public int getIngredientSlotStart() {
        return 0;
    }

    public abstract int getIngredientSize();

    public IInvHandler getResultInv() {
        return this.getInv();
    }

    public ItemStack getResult() {
        return this.getResultInv().kl$getStackInSlot(this.getResultSlot());
    }

    public abstract int getResultSlot();

    public ItemStack getMeal() {
        return ItemStack.f_41583_;
    }

    public ItemStack getNeedContainer() {
        return ItemStack.f_41583_;
    }

    public ItemStack getNowContainer() {
        return this.getContainerInv().kl$getStackInSlot(this.getContainerSlot());
    }

    public int getContainerSlot() {
        return 0;
    }

    public IInvHandler getContainerInv() {
        return this.getInv();
    }

    public int activeItemSlot() {
        return 0;
    }

    public ItemStack activeItemStack() {
        return this.activeItemInv().kl$getStackInSlot(this.activeItemSlot());
    }

    public void initActiveItemStacks() {
        if (this.activeItems == null) {
            this.activeItems = this.contActiveItemStacks();
        }
    }

    protected List<ItemStack> contActiveItemStacks() {
        return Collections.emptyList();
    }

    public List<ItemStack> getActiveItems() {
        return this.activeItems;
    }

    public IInvHandler activeItemInv() {
        return this.getInv();
    }

    public abstract boolean recMatch();

    protected final <C extends Container, T extends Recipe<C>> boolean recMatch(C container, Function<C, Optional<T>> recipeFunc) {
        if (container != null) {
            Optional<T> apply = recipeFunc.apply(container);
            return apply.isPresent();
        }
        return false;
    }

    protected final boolean recMatchAccessor() {
        return ((ICookBeAccessor)this.be).kl$canCook();
    }

    public abstract boolean cookStateMatch();

    protected final boolean cookStateMatchAccessor() {
        return ((ICookBeAccessor)this.be).kl$matchCookState();
    }

    public boolean canTakeResult() {
        return true;
    }

    public void awardExp() {
        B b = this.be;
        if (b instanceof ICookBeAccessor) {
            ICookBeAccessor accessor = (ICookBeAccessor)b;
            accessor.kl$awardExp((Entity)this.maid);
        }
    }

    public boolean hasEnoughCategory() {
        return true;
    }

    public List<ItemStack> getCategoryItems() {
        return Collections.emptyList();
    }

    public FluidTank getFluidTank() {
        return null;
    }

    public FluidStack getFluidStack() {
        return this.getFluidTank().getFluid();
    }

    public boolean hasFluid() {
        return !this.getFluidStack().isEmpty();
    }

    public Fluid getFluid() {
        return this.getFluidStack().getFluid();
    }

    public Fluid getOutputFluid() {
        return this.getFluid();
    }

    public Fluid getInputFluid() {
        return this.getFluid();
    }

    public abstract void markChanged();

    protected final void defaultChanged() {
        this.be.m_6596_();
    }

    public B getBe() {
        return this.be;
    }

    public void setBe(B be) {
        this.be = be;
    }

    public void setBlockEntity(BlockEntity be) {
        this.setBe(be);
    }

    public BlockPos getWalkPos() {
        BlockPos blockPos = this.be.m_58899_();
        Direction facingDirection = this.be.m_58900_().m_61145_((Property)HorizontalDirectionalBlock.f_54117_).orElse(null);
        if (facingDirection == null) {
            return this.defaultWalkPos(blockPos);
        }
        return this.directionPos(blockPos, facingDirection);
    }

    protected BlockPos directionPos(BlockPos bePos, Direction facingDirection) {
        return bePos.m_121955_(facingDirection.m_122436_()).m_7495_();
    }

    protected BlockPos defaultWalkPos(BlockPos bePos) {
        return bePos;
    }

    public BlockPos getPos() {
        return this.be.m_58899_();
    }

    public void clear() {
        this.be = null;
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public WrappedMaidFakePlayer getFakePlayer() {
        return this.fakePlayer;
    }
}

