/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.crokckpot.crockpot;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.task.cook.crokckpot.crockpot.rec.FoodValue;
import com.github.wallev.maidsoulkitchen.task.cook.crokckpot.crockpot.rec.MKCrockPotRecipe;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.EnumUtils;

@TaskClassAnalyzer(value=TaskInfo.CP_CROCK_POT)
public class CrockPotRecSerializerManager
extends RecSerializerManager<CrockPotCookingRecipe> {
    public static final String BLACK_REC = "crock_pot_cooking/wet_goop";
    private static final CrockPotRecSerializerManager INSTANCE = new CrockPotRecSerializerManager();
    public final Map<FoodCategory, List<Item>> FOOD_CATEGORY_INGREDIENT_MAP = new HashMap<FoodCategory, List<Item>>();
    public final Map<IRequirement, FoodCategory> REQUIREMENT_FOOD_CATEGORY_MAP = new HashMap<IRequirement, FoodCategory>();
    public final Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP = new HashMap<IRequirement, List<Item>>();
    public final Map<FoodCategory, FoodValue> REQUIREMENT_FOOD_VALUE_HASH_MAP = new HashMap<FoodCategory, FoodValue>();
    public final Set<Item> validIngres = Sets.newHashSet();

    public static CrockPotRecSerializerManager getInstance() {
        return INSTANCE;
    }

    protected CrockPotRecSerializerManager() {
        super((RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get());
    }

    private static <IR extends IRequirement> boolean processRequires(int times, List<Pair<IR, Set<Item>>> requirementItems, Map<ItemDefinition, Long> available, int[] leftUnlockSlot, boolean[] single, List<ItemDefinition> invIngredient, Map<ItemDefinition, ItemAmount> itemTimes) {
        if (requirementItems.isEmpty()) {
            return true;
        }
        for (Pair<IR, Set<Item>> requirementItem : requirementItems) {
            Set quireItems = (Set)requirementItem.getSecond();
            for (int i = 0; i < times && leftUnlockSlot[0] > 0; ++i) {
                boolean hasIngredient = false;
                for (Map.Entry<ItemDefinition, Long> entry : available.entrySet()) {
                    int amount;
                    ItemDefinition key = entry.getKey();
                    Item item = key.item();
                    if (!quireItems.contains(item)) continue;
                    hasIngredient = true;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    invIngredient.add(key);
                    if (key.getMaxStackSize() == 1) {
                        single[0] = true;
                        itemAmount = new ItemAmount(1);
                        itemTimes.put(key, itemAmount);
                        amount = itemAmount.needCount();
                    } else {
                        itemAmount = itemTimes.computeIfAbsent(key, k -> new ItemAmount(1, 0));
                        itemAmount.addCount();
                        amount = itemAmount.needCount();
                    }
                    if (entry.getValue() >= (long)amount) break;
                    return false;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected List<MaidRec> recProcess(MKRecipe<CrockPotCookingRecipe> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        boolean processRequires;
        MKCrockPotRecipe cookRec = (MKCrockPotRecipe)r;
        HashMap retainAvailable = Maps.newHashMap(available);
        retainAvailable.keySet().retainAll(cookRec.validInItemDefinitions());
        if (retainAvailable.isEmpty()) {
            return Collections.emptyList();
        }
        ((MKCrockPotRecipe)r).getNoRequiresItemDefinitions().forEach(retainAvailable.keySet()::remove);
        if (retainAvailable.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<Pair<IRequirement, Set<Item>>>> needRequires = cookRec.getNeedRequires();
        int[] leftUnlockSlot = new int[]{4};
        for (List list : needRequires) {
            processRequires = CrockPotRecSerializerManager.processRequires(1, list, retainAvailable, leftUnlockSlot, single, invIngredient, itemTimes);
            if (!processRequires) {
                return Collections.emptyList();
            }
            if (leftUnlockSlot[0] != 0) continue;
            return this.createCookRec(r, available, single, invIngredient, itemTimes);
        }
        if (leftUnlockSlot[0] > 0) {
            for (List list : needRequires) {
                processRequires = CrockPotRecSerializerManager.processRequires(list.isEmpty() ? 0 : (list.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), list, retainAvailable, leftUnlockSlot, single, invIngredient, itemTimes);
                if (!processRequires) {
                    return Collections.emptyList();
                }
                if (leftUnlockSlot[0] != 0) continue;
                return this.createCookRec(r, available, single, invIngredient, itemTimes);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected void initRecs(Level level) {
        List<CrockPotCookingRecipe> recs = this.getRecsFromRm(level).stream().filter(r -> !BLACK_REC.equals(r.m_6423_().m_135815_())).toList();
        for (FoodCategory value : FoodCategory.values()) {
            List<Item> items2 = FoodValuesDefinition.getMatchedItems((FoodCategory)value, (Level)level).stream().map(ItemStack::m_41720_).toList();
            this.FOOD_CATEGORY_INGREDIENT_MAP.put(value, items2);
        }
        for (CrockPotCookingRecipe crockPotCookingRecipe : recs) {
            for (IRequirement requirement : crockPotCookingRecipe.getRequirements()) {
                List<Item> list;
                ItemStack[] items3;
                if (this.REQUIREMENT_INGREDIENTY_MAP.containsKey(requirement)) continue;
                if (requirement instanceof RequirementMustContainIngredient) {
                    RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                    items3 = requirementMustContainIngredient.getIngredient().m_43908_();
                    list = Arrays.stream(items3).map(ItemStack::m_41720_).toList();
                    this.REQUIREMENT_INGREDIENTY_MAP.put((IRequirement)requirementMustContainIngredient, list);
                    continue;
                }
                if (requirement instanceof RequirementMustContainIngredientLessThan) {
                    RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
                    items3 = requirementMustContainIngredientLessThan.getIngredient().m_43908_();
                    list = Arrays.stream(items3).map(ItemStack::m_41720_).toList();
                    this.REQUIREMENT_INGREDIENTY_MAP.put((IRequirement)requirementMustContainIngredientLessThan, list);
                    continue;
                }
                JsonElement json = requirement.toJson();
                JsonElement category2 = json.getAsJsonObject().get("category");
                if (category2 == null) continue;
                String category1 = category2.getAsString();
                FoodCategory category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)category1.toUpperCase());
                this.REQUIREMENT_FOOD_CATEGORY_MAP.put(requirement, category);
                List<Item> items1 = this.FOOD_CATEGORY_INGREDIENT_MAP.get(category);
                this.REQUIREMENT_INGREDIENTY_MAP.put(requirement, items1);
            }
        }
        this.FOOD_CATEGORY_INGREDIENT_MAP.forEach((foodCategory, items) -> {
            HashMap<Item, Float> itemFloatHashMap = new HashMap<Item, Float>();
            for (Item item : items) {
                FoodValues foodValues = FoodValuesDefinition.getFoodValues((ItemStack)item.m_7968_(), (Level)level);
                itemFloatHashMap.put(item, Float.valueOf(foodValues.get(foodCategory)));
            }
            this.validIngres.addAll((Collection<Item>)items);
            this.REQUIREMENT_FOOD_VALUE_HASH_MAP.put((FoodCategory)foodCategory, new FoodValue((FoodCategory)foodCategory, (Map<Item, Float>)itemFloatHashMap));
        });
        this.recipes = recs.stream().map(r -> new MKCrockPotRecipe((CrockPotCookingRecipe)r, this.REQUIREMENT_INGREDIENTY_MAP)).toList();
    }

    @Override
    protected void initFuels() {
        this.fuels = this.createDefaultFuels();
    }
}

