/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class DevUtil {
    private static final String MOD_ID = "maidsoulkitchen";
    private static final String VERSION = "[,0.0]";
    private static final boolean DEBUG = !FMLEnvironment.production;
    private static final boolean MAIDSOUL_KITCHEN_DEV;

    private static boolean isMaidsoulKitchenDev() throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)VERSION);
        IModFileInfo modFileById = ModList.get().getModFileById(MOD_ID);
        ArtifactVersion version = ((IModInfo)modFileById.getMods().get(0)).getVersion();
        return versionRange.containsVersion(version);
    }

    private static boolean isDev() {
        return DevUtil.isDevEnv() || User.IS_DEV_USER;
    }

    public static boolean isDevEnv() {
        return DEBUG && MAIDSOUL_KITCHEN_DEV;
    }

    static {
        try {
            MAIDSOUL_KITCHEN_DEV = DevUtil.isMaidsoulKitchenDev();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class User {
        private static final UUID DEV_USER = UUID.fromString("81d2e1b0-1c89-48ec-8d68-98f7995aaff7");
        private static final List<String> DEV_USER_NAME = List.of("seven_lifet", "Abert_Cat", "Albert_Cat", "Catbert");
        private static final boolean IS_DEV_USER = User.isDevUser();

        private User() {
        }

        private static boolean isDevUser() {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                return false;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            String userId = minecraft.m_91094_().m_92545_();
            return DEV_USER.toString().equals(userId);
        }
    }
}

